CREATE DATABASE IF NOT EXISTS weberpdemo;
USE weberpdemo;
SET FOREIGN_KEY_CHECKS = 0;
-- MySQL dump 10.16  Distrib 10.1.44-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: weberpdemo
-- ------------------------------------------------------
-- Server version	10.1.44-MariaDB-0ubuntu0.18.04.1
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accountgroups`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accountgroups` (
  `groupname` char(30) NOT NULL DEFAULT '',
  `sectioninaccounts` int(11) NOT NULL DEFAULT '0',
  `pandl` tinyint(4) NOT NULL DEFAULT '1',
  `sequenceintb` smallint(6) NOT NULL DEFAULT '0',
  `parentgroupname` varchar(30) NOT NULL,
  PRIMARY KEY (`groupname`),
  KEY `SequenceInTB` (`sequenceintb`),
  KEY `sectioninaccounts` (`sectioninaccounts`),
  KEY `parentgroupname` (`parentgroupname`),
  CONSTRAINT `accountgroups_ibfk_1` FOREIGN KEY (`sectioninaccounts`) REFERENCES `accountsection` (`sectionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `accountsection`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accountsection` (
  `sectionid` int(11) NOT NULL DEFAULT '0',
  `sectionname` text NOT NULL,
  PRIMARY KEY (`sectionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `areas`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `areas` (
  `areacode` char(3) NOT NULL,
  `areadescription` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`areacode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetmanager`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assetmanager` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `serialno` varchar(30) NOT NULL DEFAULT '',
  `location` varchar(15) NOT NULL DEFAULT '',
  `cost` double NOT NULL DEFAULT '0',
  `depn` double NOT NULL DEFAULT '0',
  `datepurchased` date NOT NULL DEFAULT '1000-01-01',
  `disposalvalue` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `audittrail`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `audittrail` (
  `transactiondate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `userid` varchar(20) NOT NULL DEFAULT '',
  `querystring` text,
  KEY `UserID` (`userid`),
  KEY `transactiondate` (`transactiondate`),
  KEY `transactiondate_2` (`transactiondate`),
  KEY `transactiondate_3` (`transactiondate`),
  CONSTRAINT `audittrail_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `www_users` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bankaccounts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bankaccounts` (
  `accountcode` varchar(20) NOT NULL DEFAULT '0',
  `currcode` char(3) NOT NULL,
  `invoice` smallint(2) NOT NULL DEFAULT '0',
  `bankaccountcode` varchar(50) NOT NULL DEFAULT '',
  `bankaccountname` char(50) NOT NULL DEFAULT '',
  `bankaccountnumber` char(50) NOT NULL DEFAULT '',
  `bankaddress` char(50) DEFAULT NULL,
  `importformat` varchar(10) NOT NULL DEFAULT '''''',
  PRIMARY KEY (`accountcode`),
  KEY `currcode` (`currcode`),
  KEY `BankAccountName` (`bankaccountname`),
  KEY `BankAccountNumber` (`bankaccountnumber`),
  CONSTRAINT `bankaccounts_ibfk_1` FOREIGN KEY (`accountcode`) REFERENCES `chartmaster` (`accountcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bankaccountusers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bankaccountusers` (
  `accountcode` varchar(20) NOT NULL COMMENT 'Bank account code',
  `userid` varchar(20) NOT NULL COMMENT 'User code'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `banktrans`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banktrans` (
  `banktransid` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `transno` bigint(20) NOT NULL DEFAULT '0',
  `bankact` varchar(20) NOT NULL DEFAULT '0',
  `ref` varchar(50) NOT NULL DEFAULT '',
  `amountcleared` double NOT NULL DEFAULT '0',
  `exrate` double NOT NULL DEFAULT '1' COMMENT 'From bank account currency to payment currency',
  `functionalexrate` double NOT NULL DEFAULT '1' COMMENT 'Account currency to functional currency',
  `transdate` date NOT NULL DEFAULT '1000-01-01',
  `banktranstype` varchar(30) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `currcode` char(3) NOT NULL DEFAULT '',
  `chequeno` varchar(16) NOT NULL DEFAULT '',
  PRIMARY KEY (`banktransid`),
  KEY `BankAct` (`bankact`,`ref`),
  KEY `TransDate` (`transdate`),
  KEY `TransType` (`banktranstype`),
  KEY `Type` (`type`,`transno`),
  KEY `CurrCode` (`currcode`),
  KEY `ref` (`ref`),
  CONSTRAINT `banktrans_ibfk_1` FOREIGN KEY (`type`) REFERENCES `systypes` (`typeid`),
  CONSTRAINT `banktrans_ibfk_2` FOREIGN KEY (`bankact`) REFERENCES `bankaccounts` (`accountcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bom`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bom` (
  `parent` char(20) NOT NULL DEFAULT '',
  `sequence` int(11) NOT NULL DEFAULT '0',
  `component` char(20) NOT NULL DEFAULT '',
  `workcentreadded` char(5) NOT NULL DEFAULT '',
  `loccode` char(5) NOT NULL DEFAULT '',
  `effectiveafter` date NOT NULL DEFAULT '1000-01-01',
  `effectiveto` date NOT NULL DEFAULT '9999-12-31',
  `quantity` double NOT NULL DEFAULT '1',
  `autoissue` tinyint(4) NOT NULL DEFAULT '0',
  `remark` varchar(500) NOT NULL DEFAULT '',
  `digitals` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`parent`,`component`,`workcentreadded`,`loccode`),
  KEY `Component` (`component`),
  KEY `EffectiveAfter` (`effectiveafter`),
  KEY `EffectiveTo` (`effectiveto`),
  KEY `LocCode` (`loccode`),
  KEY `Parent` (`parent`,`effectiveafter`,`effectiveto`,`loccode`),
  KEY `Parent_2` (`parent`),
  KEY `WorkCentreAdded` (`workcentreadded`),
  CONSTRAINT `bom_ibfk_1` FOREIGN KEY (`parent`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `bom_ibfk_2` FOREIGN KEY (`component`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `bom_ibfk_3` FOREIGN KEY (`workcentreadded`) REFERENCES `workcentres` (`code`),
  CONSTRAINT `bom_ibfk_4` FOREIGN KEY (`loccode`) REFERENCES `locations` (`loccode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `chartdetails`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chartdetails` (
  `accountcode` varchar(20) NOT NULL DEFAULT '0',
  `period` smallint(6) NOT NULL DEFAULT '0',
  `budget` double NOT NULL DEFAULT '0',
  `actual` double NOT NULL DEFAULT '0',
  `bfwd` double NOT NULL DEFAULT '0',
  `bfwdbudget` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`accountcode`,`period`),
  KEY `Period` (`period`),
  CONSTRAINT `chartdetails_ibfk_1` FOREIGN KEY (`accountcode`) REFERENCES `chartmaster` (`accountcode`),
  CONSTRAINT `chartdetails_ibfk_2` FOREIGN KEY (`period`) REFERENCES `periods` (`periodno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `chartmaster`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chartmaster` (
  `accountcode` varchar(20) NOT NULL DEFAULT '0',
  `accountname` char(50) NOT NULL DEFAULT '',
  `group_` char(30) NOT NULL DEFAULT '',
  `cashflowsactivity` tinyint(1) NOT NULL DEFAULT '-1' COMMENT 'Cash flows activity',
  PRIMARY KEY (`accountcode`),
  KEY `AccountName` (`accountname`),
  KEY `Group_` (`group_`),
  CONSTRAINT `chartmaster_ibfk_1` FOREIGN KEY (`group_`) REFERENCES `accountgroups` (`groupname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cogsglpostings`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cogsglpostings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area` char(3) NOT NULL DEFAULT '',
  `stkcat` varchar(6) NOT NULL DEFAULT '',
  `glcode` varchar(20) NOT NULL DEFAULT '0',
  `salestype` char(2) NOT NULL DEFAULT 'AN',
  PRIMARY KEY (`id`),
  UNIQUE KEY `Area_StkCat` (`area`,`stkcat`,`salestype`),
  KEY `Area` (`area`),
  KEY `StkCat` (`stkcat`),
  KEY `GLCode` (`glcode`),
  KEY `SalesType` (`salestype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `companies`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `companies` (
  `coycode` int(11) NOT NULL DEFAULT '1',
  `coyname` varchar(50) NOT NULL DEFAULT '',
  `gstno` varchar(20) NOT NULL DEFAULT '',
  `companynumber` varchar(20) NOT NULL DEFAULT '0',
  `regoffice1` varchar(40) NOT NULL DEFAULT '',
  `regoffice2` varchar(40) NOT NULL DEFAULT '',
  `regoffice3` varchar(40) NOT NULL DEFAULT '',
  `regoffice4` varchar(40) NOT NULL DEFAULT '',
  `regoffice5` varchar(20) NOT NULL DEFAULT '',
  `regoffice6` varchar(15) NOT NULL DEFAULT '',
  `telephone` varchar(25) NOT NULL DEFAULT '',
  `fax` varchar(25) NOT NULL DEFAULT '',
  `email` varchar(55) NOT NULL DEFAULT '',
  `currencydefault` varchar(4) NOT NULL DEFAULT '',
  `debtorsact` varchar(20) NOT NULL DEFAULT '70000',
  `pytdiscountact` varchar(20) NOT NULL DEFAULT '55000',
  `creditorsact` varchar(20) NOT NULL DEFAULT '80000',
  `payrollact` varchar(20) NOT NULL DEFAULT '84000',
  `grnact` varchar(20) NOT NULL DEFAULT '72000',
  `exchangediffact` varchar(20) NOT NULL DEFAULT '65000',
  `purchasesexchangediffact` varchar(20) NOT NULL DEFAULT '0',
  `retainedearnings` varchar(20) NOT NULL DEFAULT '90000',
  `gllink_debtors` tinyint(1) DEFAULT '1',
  `gllink_creditors` tinyint(1) DEFAULT '1',
  `gllink_stock` tinyint(1) DEFAULT '1',
  `freightact` varchar(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coycode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `config`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `config` (
  `confname` varchar(35) NOT NULL DEFAULT '',
  `confvalue` text NOT NULL,
  PRIMARY KEY (`confname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contractbom`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contractbom` (
  `contractref` varchar(20) NOT NULL DEFAULT '0',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `workcentreadded` char(5) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`contractref`,`stockid`,`workcentreadded`),
  KEY `Stockid` (`stockid`),
  KEY `ContractRef` (`contractref`),
  KEY `WorkCentreAdded` (`workcentreadded`),
  CONSTRAINT `contractbom_ibfk_1` FOREIGN KEY (`workcentreadded`) REFERENCES `workcentres` (`code`),
  CONSTRAINT `contractbom_ibfk_3` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contractcharges`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contractcharges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contractref` varchar(20) NOT NULL,
  `transtype` smallint(6) NOT NULL DEFAULT '20',
  `transno` int(11) NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  `narrative` text NOT NULL,
  `anticipated` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `contractref` (`contractref`,`transtype`,`transno`),
  KEY `contractcharges_ibfk_2` (`transtype`),
  CONSTRAINT `contractcharges_ibfk_1` FOREIGN KEY (`contractref`) REFERENCES `contracts` (`contractref`),
  CONSTRAINT `contractcharges_ibfk_2` FOREIGN KEY (`transtype`) REFERENCES `systypes` (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contractreqts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contractreqts` (
  `contractreqid` int(11) NOT NULL AUTO_INCREMENT,
  `contractref` varchar(20) NOT NULL DEFAULT '0',
  `requirement` varchar(40) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '1',
  `costperunit` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`contractreqid`),
  KEY `ContractRef` (`contractref`),
  CONSTRAINT `contractreqts_ibfk_1` FOREIGN KEY (`contractref`) REFERENCES `contracts` (`contractref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contracts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contracts` (
  `contractref` varchar(20) NOT NULL DEFAULT '',
  `contractdescription` text NOT NULL,
  `debtorno` varchar(10) NOT NULL DEFAULT '',
  `branchcode` varchar(10) NOT NULL DEFAULT '',
  `loccode` varchar(5) NOT NULL DEFAULT '',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `categoryid` varchar(6) NOT NULL DEFAULT '',
  `orderno` int(11) NOT NULL DEFAULT '0',
  `customerref` varchar(20) NOT NULL DEFAULT '',
  `margin` double NOT NULL DEFAULT '1',
  `wo` int(11) NOT NULL DEFAULT '0',
  `requireddate` date NOT NULL DEFAULT '1000-01-01',
  `drawing` varchar(50) NOT NULL DEFAULT '',
  `exrate` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`contractref`),
  KEY `OrderNo` (`orderno`),
  KEY `CategoryID` (`categoryid`),
  KEY `Status` (`status`),
  KEY `WO` (`wo`),
  KEY `loccode` (`loccode`),
  KEY `DebtorNo` (`debtorno`,`branchcode`),
  KEY `contracts_ibfk_1` (`branchcode`,`debtorno`),
  CONSTRAINT `contracts_ibfk_1` FOREIGN KEY (`branchcode`, `debtorno`) REFERENCES `custbranch` (`branchcode`, `debtorno`),
  CONSTRAINT `contracts_ibfk_2` FOREIGN KEY (`categoryid`) REFERENCES `stockcategory` (`categoryid`),
  CONSTRAINT `contracts_ibfk_3` FOREIGN KEY (`loccode`) REFERENCES `locations` (`loccode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `currencies`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `currency` char(20) NOT NULL DEFAULT '',
  `currabrev` char(3) NOT NULL DEFAULT '',
  `country` char(50) NOT NULL DEFAULT '',
  `hundredsname` char(15) NOT NULL DEFAULT 'Cents',
  `decimalplaces` tinyint(3) NOT NULL DEFAULT '2',
  `rate` double NOT NULL DEFAULT '1',
  `webcart` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'If 1 shown in weberp cart. if 0 no show',
  PRIMARY KEY (`currabrev`),
  KEY `Country` (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `custallocns`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custallocns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amt` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `datealloc` date NOT NULL DEFAULT '1000-01-01',
  `transid_allocfrom` int(11) NOT NULL DEFAULT '0',
  `transid_allocto` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `DateAlloc` (`datealloc`),
  KEY `TransID_AllocFrom` (`transid_allocfrom`),
  KEY `TransID_AllocTo` (`transid_allocto`),
  CONSTRAINT `custallocns_ibfk_1` FOREIGN KEY (`transid_allocfrom`) REFERENCES `debtortrans` (`id`),
  CONSTRAINT `custallocns_ibfk_2` FOREIGN KEY (`transid_allocto`) REFERENCES `debtortrans` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `custbranch`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custbranch` (
  `branchcode` varchar(10) NOT NULL DEFAULT '',
  `debtorno` varchar(10) NOT NULL DEFAULT '',
  `brname` varchar(40) NOT NULL DEFAULT '',
  `braddress1` varchar(40) NOT NULL DEFAULT '',
  `braddress2` varchar(40) NOT NULL DEFAULT '',
  `braddress3` varchar(40) NOT NULL DEFAULT '',
  `braddress4` varchar(50) NOT NULL DEFAULT '',
  `braddress5` varchar(20) NOT NULL DEFAULT '',
  `braddress6` varchar(40) NOT NULL DEFAULT '',
  `lat` float(12,8) NOT NULL DEFAULT '0.00000000',
  `lng` float(12,8) NOT NULL DEFAULT '0.00000000',
  `estdeliverydays` smallint(6) NOT NULL DEFAULT '1',
  `area` char(3) NOT NULL,
  `salesman` varchar(4) NOT NULL DEFAULT '',
  `fwddate` smallint(6) NOT NULL DEFAULT '0',
  `phoneno` varchar(20) NOT NULL DEFAULT '',
  `faxno` varchar(20) NOT NULL DEFAULT '',
  `contactname` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(55) NOT NULL DEFAULT '',
  `defaultlocation` varchar(5) NOT NULL DEFAULT '',
  `taxgroupid` tinyint(4) NOT NULL DEFAULT '1',
  `defaultshipvia` int(11) NOT NULL DEFAULT '1',
  `deliverblind` tinyint(1) DEFAULT '1',
  `disabletrans` tinyint(4) NOT NULL DEFAULT '0',
  `brpostaddr1` varchar(40) NOT NULL DEFAULT '',
  `brpostaddr2` varchar(40) NOT NULL DEFAULT '',
  `brpostaddr3` varchar(40) NOT NULL DEFAULT '',
  `brpostaddr4` varchar(50) NOT NULL DEFAULT '',
  `brpostaddr5` varchar(20) NOT NULL DEFAULT '',
  `brpostaddr6` varchar(40) NOT NULL DEFAULT '',
  `specialinstructions` text NOT NULL,
  `custbranchcode` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`branchcode`,`debtorno`),
  KEY `BrName` (`brname`),
  KEY `DebtorNo` (`debtorno`),
  KEY `Salesman` (`salesman`),
  KEY `Area` (`area`),
  KEY `DefaultLocation` (`defaultlocation`),
  KEY `DefaultShipVia` (`defaultshipvia`),
  KEY `taxgroupid` (`taxgroupid`),
  CONSTRAINT `custbranch_ibfk_1` FOREIGN KEY (`debtorno`) REFERENCES `debtorsmaster` (`debtorno`),
  CONSTRAINT `custbranch_ibfk_2` FOREIGN KEY (`area`) REFERENCES `areas` (`areacode`),
  CONSTRAINT `custbranch_ibfk_3` FOREIGN KEY (`salesman`) REFERENCES `salesman` (`salesmancode`),
  CONSTRAINT `custbranch_ibfk_4` FOREIGN KEY (`defaultlocation`) REFERENCES `locations` (`loccode`),
  CONSTRAINT `custbranch_ibfk_6` FOREIGN KEY (`defaultshipvia`) REFERENCES `shippers` (`shipper_id`),
  CONSTRAINT `custbranch_ibfk_7` FOREIGN KEY (`taxgroupid`) REFERENCES `taxgroups` (`taxgroupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `custcontacts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custcontacts` (
  `contid` int(11) NOT NULL AUTO_INCREMENT,
  `debtorno` varchar(10) NOT NULL,
  `contactname` varchar(40) NOT NULL,
  `role` varchar(40) NOT NULL,
  `phoneno` varchar(20) NOT NULL,
  `notes` varchar(255) NOT NULL,
  `email` varchar(55) NOT NULL,
  `statement` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`contid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `custitem`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custitem` (
  `debtorno` char(10) NOT NULL DEFAULT '',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `cust_part` varchar(20) NOT NULL DEFAULT '',
  `cust_description` varchar(30) NOT NULL DEFAULT '',
  `customersuom` char(50) NOT NULL DEFAULT '',
  `conversionfactor` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`debtorno`,`stockid`),
  KEY `StockID` (`stockid`),
  KEY `Debtorno` (`debtorno`),
  CONSTRAINT ` custitem _ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT ` custitem _ibfk_2` FOREIGN KEY (`debtorno`) REFERENCES `debtorsmaster` (`debtorno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `custnotes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custnotes` (
  `noteid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `debtorno` varchar(10) NOT NULL DEFAULT '0',
  `href` varchar(100) NOT NULL,
  `note` text NOT NULL,
  `date` date NOT NULL DEFAULT '1000-01-01',
  `priority` varchar(20) NOT NULL,
  PRIMARY KEY (`noteid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `debtorsmaster`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `debtorsmaster` (
  `debtorno` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(40) NOT NULL DEFAULT '',
  `address1` varchar(40) NOT NULL DEFAULT '',
  `address2` varchar(40) NOT NULL DEFAULT '',
  `address3` varchar(40) NOT NULL DEFAULT '',
  `address4` varchar(50) NOT NULL DEFAULT '',
  `address5` varchar(20) NOT NULL DEFAULT '',
  `address6` varchar(40) NOT NULL DEFAULT '',
  `currcode` char(3) NOT NULL DEFAULT '',
  `salestype` char(2) NOT NULL DEFAULT '',
  `clientsince` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `holdreason` smallint(6) NOT NULL DEFAULT '0',
  `paymentterms` char(2) NOT NULL DEFAULT 'f',
  `discount` double NOT NULL DEFAULT '0',
  `pymtdiscount` double NOT NULL DEFAULT '0',
  `lastpaid` double NOT NULL DEFAULT '0',
  `lastpaiddate` datetime DEFAULT NULL,
  `creditlimit` double NOT NULL DEFAULT '1000',
  `invaddrbranch` tinyint(4) NOT NULL DEFAULT '0',
  `discountcode` char(2) NOT NULL DEFAULT '',
  `ediinvoices` tinyint(4) NOT NULL DEFAULT '0',
  `ediorders` tinyint(4) NOT NULL DEFAULT '0',
  `edireference` varchar(20) NOT NULL DEFAULT '',
  `editransport` varchar(5) NOT NULL DEFAULT 'email',
  `ediaddress` varchar(50) NOT NULL DEFAULT '',
  `ediserveruser` varchar(20) NOT NULL DEFAULT '',
  `ediserverpwd` varchar(20) NOT NULL DEFAULT '',
  `taxref` varchar(20) NOT NULL DEFAULT '',
  `customerpoline` tinyint(1) NOT NULL DEFAULT '0',
  `typeid` tinyint(4) NOT NULL DEFAULT '1',
  `language_id` varchar(10) NOT NULL DEFAULT 'en_GB.utf8',
  PRIMARY KEY (`debtorno`),
  KEY `Currency` (`currcode`),
  KEY `HoldReason` (`holdreason`),
  KEY `Name` (`name`),
  KEY `PaymentTerms` (`paymentterms`),
  KEY `SalesType` (`salestype`),
  KEY `EDIInvoices` (`ediinvoices`),
  KEY `EDIOrders` (`ediorders`),
  KEY `debtorsmaster_ibfk_5` (`typeid`),
  CONSTRAINT `debtorsmaster_ibfk_1` FOREIGN KEY (`holdreason`) REFERENCES `holdreasons` (`reasoncode`),
  CONSTRAINT `debtorsmaster_ibfk_2` FOREIGN KEY (`currcode`) REFERENCES `currencies` (`currabrev`),
  CONSTRAINT `debtorsmaster_ibfk_3` FOREIGN KEY (`paymentterms`) REFERENCES `paymentterms` (`termsindicator`),
  CONSTRAINT `debtorsmaster_ibfk_4` FOREIGN KEY (`salestype`) REFERENCES `salestypes` (`typeabbrev`),
  CONSTRAINT `debtorsmaster_ibfk_5` FOREIGN KEY (`typeid`) REFERENCES `debtortype` (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `debtortrans`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `debtortrans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transno` int(11) NOT NULL DEFAULT '0',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `debtorno` varchar(10) NOT NULL DEFAULT '',
  `branchcode` varchar(10) NOT NULL DEFAULT '',
  `trandate` date NOT NULL DEFAULT '1000-01-01',
  `inputdate` datetime NOT NULL,
  `prd` smallint(6) NOT NULL DEFAULT '0',
  `settled` tinyint(4) NOT NULL DEFAULT '0',
  `reference` varchar(20) NOT NULL DEFAULT '',
  `tpe` char(2) NOT NULL DEFAULT '',
  `order_` int(11) NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '0',
  `ovamount` double NOT NULL DEFAULT '0',
  `ovgst` double NOT NULL DEFAULT '0',
  `ovfreight` double NOT NULL DEFAULT '0',
  `ovdiscount` double NOT NULL DEFAULT '0',
  `diffonexch` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `invtext` text,
  `shipvia` int(11) NOT NULL DEFAULT '0',
  `edisent` tinyint(4) NOT NULL DEFAULT '0',
  `consignment` varchar(20) NOT NULL DEFAULT '',
  `packages` int(11) NOT NULL DEFAULT '1' COMMENT 'number of cartons',
  `salesperson` varchar(4) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `DebtorNo` (`debtorno`,`branchcode`),
  KEY `Order_` (`order_`),
  KEY `Prd` (`prd`),
  KEY `Tpe` (`tpe`),
  KEY `Type` (`type`),
  KEY `Settled` (`settled`),
  KEY `TranDate` (`trandate`),
  KEY `TransNo` (`transno`),
  KEY `Type_2` (`type`,`transno`),
  KEY `EDISent` (`edisent`),
  KEY `salesperson` (`salesperson`),
  CONSTRAINT `debtortrans_ibfk_2` FOREIGN KEY (`type`) REFERENCES `systypes` (`typeid`),
  CONSTRAINT `debtortrans_ibfk_3` FOREIGN KEY (`prd`) REFERENCES `periods` (`periodno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `debtortranstaxes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `debtortranstaxes` (
  `debtortransid` int(11) NOT NULL DEFAULT '0',
  `taxauthid` tinyint(4) NOT NULL DEFAULT '0',
  `taxamount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`debtortransid`,`taxauthid`),
  KEY `taxauthid` (`taxauthid`),
  CONSTRAINT `debtortranstaxes_ibfk_1` FOREIGN KEY (`taxauthid`) REFERENCES `taxauthorities` (`taxid`),
  CONSTRAINT `debtortranstaxes_ibfk_2` FOREIGN KEY (`debtortransid`) REFERENCES `debtortrans` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `debtortype`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `debtortype` (
  `typeid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `typename` varchar(100) NOT NULL,
  PRIMARY KEY (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `debtortypenotes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `debtortypenotes` (
  `noteid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(4) NOT NULL DEFAULT '0',
  `href` varchar(100) NOT NULL,
  `note` varchar(200) NOT NULL,
  `date` date NOT NULL DEFAULT '1000-01-01',
  `priority` varchar(20) NOT NULL,
  PRIMARY KEY (`noteid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `departments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `departments` (
  `departmentid` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(100) NOT NULL DEFAULT '',
  `authoriser` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`departmentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `discountmatrix`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discountmatrix` (
  `salestype` char(2) NOT NULL DEFAULT '',
  `discountcategory` char(2) NOT NULL DEFAULT '',
  `quantitybreak` int(11) NOT NULL DEFAULT '1',
  `discountrate` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`salestype`,`discountcategory`,`quantitybreak`),
  KEY `QuantityBreak` (`quantitybreak`),
  KEY `DiscountCategory` (`discountcategory`),
  KEY `SalesType` (`salestype`),
  CONSTRAINT `discountmatrix_ibfk_1` FOREIGN KEY (`salestype`) REFERENCES `salestypes` (`typeabbrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `edi_orders_seg_groups`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `edi_orders_seg_groups` (
  `seggroupno` tinyint(4) NOT NULL DEFAULT '0',
  `maxoccur` int(4) NOT NULL DEFAULT '0',
  `parentseggroup` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`seggroupno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `edi_orders_segs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `edi_orders_segs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `segtag` char(3) NOT NULL DEFAULT '',
  `seggroup` tinyint(4) NOT NULL DEFAULT '0',
  `maxoccur` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `SegTag` (`segtag`),
  KEY `SegNo` (`seggroup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ediitemmapping`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ediitemmapping` (
  `supporcust` varchar(4) NOT NULL DEFAULT '',
  `partnercode` varchar(10) NOT NULL DEFAULT '',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `partnerstockid` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`supporcust`,`partnercode`,`stockid`),
  KEY `PartnerCode` (`partnercode`),
  KEY `StockID` (`stockid`),
  KEY `PartnerStockID` (`partnerstockid`),
  KEY `SuppOrCust` (`supporcust`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `edimessageformat`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `edimessageformat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `partnercode` varchar(10) NOT NULL DEFAULT '',
  `messagetype` varchar(6) NOT NULL DEFAULT '',
  `section` varchar(7) NOT NULL DEFAULT '',
  `sequenceno` int(11) NOT NULL DEFAULT '0',
  `linetext` varchar(70) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `PartnerCode` (`partnercode`,`messagetype`,`sequenceno`),
  KEY `Section` (`section`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `emailsettings`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailsettings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(30) NOT NULL,
  `port` char(5) NOT NULL,
  `heloaddress` varchar(20) NOT NULL,
  `username` varchar(50) DEFAULT NULL,
  `password` varchar(30) DEFAULT NULL,
  `timeout` int(11) DEFAULT '5',
  `companyname` varchar(50) DEFAULT NULL,
  `auth` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `employees`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `surname` varchar(20) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `stockid` varchar(20) NOT NULL COMMENT 'FK with stockmaster - ',
  `manager` int(11) DEFAULT NULL,
  `normalhours` double NOT NULL DEFAULT '40',
  `userid` varchar(20) NOT NULL,
  `email` varchar(55) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `surname` (`surname`),
  KEY `firstname` (`firstname`),
  KEY `stockid` (`stockid`),
  KEY `manager` (`manager`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `factorcompanies`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `factorcompanies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coyname` varchar(50) NOT NULL DEFAULT '',
  `address1` varchar(40) NOT NULL DEFAULT '',
  `address2` varchar(40) NOT NULL DEFAULT '',
  `address3` varchar(40) NOT NULL DEFAULT '',
  `address4` varchar(40) NOT NULL DEFAULT '',
  `address5` varchar(20) NOT NULL DEFAULT '',
  `address6` varchar(15) NOT NULL DEFAULT '',
  `contact` varchar(25) NOT NULL DEFAULT '',
  `telephone` varchar(25) NOT NULL DEFAULT '',
  `fax` varchar(25) NOT NULL DEFAULT '',
  `email` varchar(55) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `factor_name` (`coyname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `favourites`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `favourites` (
  `userid` varchar(20) NOT NULL DEFAULT '',
  `caption` varchar(50) NOT NULL DEFAULT '',
  `href` varchar(200) NOT NULL DEFAULT '#',
  PRIMARY KEY (`userid`,`caption`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fixedassetcategories`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fixedassetcategories` (
  `categoryid` char(6) NOT NULL DEFAULT '',
  `categorydescription` char(20) NOT NULL DEFAULT '',
  `costact` varchar(20) NOT NULL DEFAULT '0',
  `depnact` varchar(20) NOT NULL DEFAULT '0',
  `disposalact` varchar(20) NOT NULL DEFAULT '80000',
  `accumdepnact` varchar(20) NOT NULL DEFAULT '0',
  `defaultdepnrate` double NOT NULL DEFAULT '0.2',
  `defaultdepntype` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fixedassetlocations`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fixedassetlocations` (
  `locationid` char(6) NOT NULL DEFAULT '',
  `locationdescription` char(20) NOT NULL DEFAULT '',
  `parentlocationid` char(6) DEFAULT '',
  PRIMARY KEY (`locationid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fixedassets`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fixedassets` (
  `assetid` int(11) NOT NULL AUTO_INCREMENT,
  `serialno` varchar(30) NOT NULL DEFAULT '',
  `barcode` varchar(20) NOT NULL,
  `assetlocation` varchar(6) NOT NULL DEFAULT '',
  `cost` double NOT NULL DEFAULT '0',
  `accumdepn` double NOT NULL DEFAULT '0',
  `datepurchased` date NOT NULL DEFAULT '1000-01-01',
  `disposalproceeds` double NOT NULL DEFAULT '0',
  `assetcategoryid` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(50) NOT NULL DEFAULT '',
  `longdescription` text NOT NULL,
  `depntype` int(11) NOT NULL DEFAULT '1',
  `depnrate` double NOT NULL,
  `disposaldate` date NOT NULL DEFAULT '1000-01-01',
  PRIMARY KEY (`assetid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fixedassettasks`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fixedassettasks` (
  `taskid` int(11) NOT NULL AUTO_INCREMENT,
  `assetid` int(11) NOT NULL,
  `taskdescription` text NOT NULL,
  `frequencydays` int(11) NOT NULL DEFAULT '365',
  `lastcompleted` date NOT NULL,
  `userresponsible` varchar(20) NOT NULL,
  `manager` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`taskid`),
  KEY `assetid` (`assetid`),
  KEY `userresponsible` (`userresponsible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fixedassettrans`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fixedassettrans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `assetid` int(11) NOT NULL,
  `transtype` tinyint(4) NOT NULL,
  `transdate` date NOT NULL,
  `transno` int(11) NOT NULL,
  `periodno` smallint(6) NOT NULL,
  `inputdate` date NOT NULL,
  `fixedassettranstype` varchar(8) NOT NULL,
  `amount` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `assetid` (`assetid`,`transtype`,`transno`),
  KEY `inputdate` (`inputdate`),
  KEY `transdate` (`transdate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freightcosts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freightcosts` (
  `shipcostfromid` int(11) NOT NULL AUTO_INCREMENT,
  `locationfrom` varchar(5) NOT NULL DEFAULT '',
  `destinationcountry` varchar(40) NOT NULL,
  `destination` varchar(40) NOT NULL DEFAULT '',
  `shipperid` int(11) NOT NULL DEFAULT '0',
  `cubrate` double NOT NULL DEFAULT '0',
  `kgrate` double NOT NULL DEFAULT '0',
  `maxkgs` double NOT NULL DEFAULT '999999',
  `maxcub` double NOT NULL DEFAULT '999999',
  `fixedprice` double NOT NULL DEFAULT '0',
  `minimumchg` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`shipcostfromid`),
  KEY `Destination` (`destination`),
  KEY `LocationFrom` (`locationfrom`),
  KEY `ShipperID` (`shipperid`),
  KEY `Destination_2` (`destination`,`locationfrom`,`shipperid`),
  CONSTRAINT `freightcosts_ibfk_1` FOREIGN KEY (`locationfrom`) REFERENCES `locations` (`loccode`),
  CONSTRAINT `freightcosts_ibfk_2` FOREIGN KEY (`shipperid`) REFERENCES `shippers` (`shipper_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `geocode_param`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `geocode_param` (
  `geocodeid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `geocode_key` varchar(200) NOT NULL DEFAULT '',
  `center_long` varchar(20) NOT NULL DEFAULT '',
  `center_lat` varchar(20) NOT NULL DEFAULT '',
  `map_height` varchar(10) NOT NULL DEFAULT '',
  `map_width` varchar(10) NOT NULL DEFAULT '',
  `map_host` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`geocodeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `glaccountusers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `glaccountusers` (
  `accountcode` varchar(20) NOT NULL COMMENT 'GL account code from chartmaster',
  `userid` varchar(20) NOT NULL,
  `canview` tinyint(4) NOT NULL DEFAULT '0',
  `canupd` tinyint(4) NOT NULL DEFAULT '0',
  UNIQUE KEY `useraccount` (`userid`,`accountcode`),
  UNIQUE KEY `accountuser` (`accountcode`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gltrans`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gltrans` (
  `counterindex` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `typeno` bigint(16) NOT NULL DEFAULT '1',
  `chequeno` int(11) NOT NULL DEFAULT '0',
  `trandate` date NOT NULL DEFAULT '1000-01-01',
  `periodno` smallint(6) NOT NULL DEFAULT '0',
  `account` varchar(20) NOT NULL DEFAULT '0',
  `narrative` varchar(200) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `posted` tinyint(4) NOT NULL DEFAULT '0',
  `jobref` varchar(20) NOT NULL DEFAULT '',
  `tag` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`counterindex`),
  KEY `Account` (`account`),
  KEY `ChequeNo` (`chequeno`),
  KEY `PeriodNo` (`periodno`),
  KEY `Posted` (`posted`),
  KEY `TranDate` (`trandate`),
  KEY `TypeNo` (`typeno`),
  KEY `Type_and_Number` (`type`,`typeno`),
  KEY `JobRef` (`jobref`),
  KEY `tag` (`tag`),
  CONSTRAINT `gltrans_ibfk_1` FOREIGN KEY (`account`) REFERENCES `chartmaster` (`accountcode`),
  CONSTRAINT `gltrans_ibfk_2` FOREIGN KEY (`type`) REFERENCES `systypes` (`typeid`),
  CONSTRAINT `gltrans_ibfk_3` FOREIGN KEY (`periodno`) REFERENCES `periods` (`periodno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `grns`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `grns` (
  `grnbatch` smallint(6) NOT NULL DEFAULT '0',
  `grnno` int(11) NOT NULL AUTO_INCREMENT,
  `podetailitem` int(11) NOT NULL DEFAULT '0',
  `itemcode` varchar(20) NOT NULL DEFAULT '',
  `deliverydate` date NOT NULL DEFAULT '1000-01-01',
  `itemdescription` varchar(100) NOT NULL DEFAULT '',
  `qtyrecd` double NOT NULL DEFAULT '0',
  `quantityinv` double NOT NULL DEFAULT '0',
  `supplierid` varchar(10) NOT NULL DEFAULT '',
  `stdcostunit` double NOT NULL DEFAULT '0',
  `supplierref` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`grnno`),
  KEY `DeliveryDate` (`deliverydate`),
  KEY `ItemCode` (`itemcode`),
  KEY `PODetailItem` (`podetailitem`),
  KEY `SupplierID` (`supplierid`),
  CONSTRAINT `grns_ibfk_1` FOREIGN KEY (`supplierid`) REFERENCES `suppliers` (`supplierid`),
  CONSTRAINT `grns_ibfk_2` FOREIGN KEY (`podetailitem`) REFERENCES `purchorderdetails` (`podetailitem`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `holdreasons`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `holdreasons` (
  `reasoncode` smallint(6) NOT NULL DEFAULT '1',
  `reasondescription` char(30) NOT NULL DEFAULT '',
  `dissallowinvoices` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`reasoncode`),
  KEY `ReasonDescription` (`reasondescription`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `internalstockcatrole`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `internalstockcatrole` (
  `categoryid` varchar(6) NOT NULL,
  `secroleid` int(11) NOT NULL,
  PRIMARY KEY (`categoryid`,`secroleid`),
  KEY `internalstockcatrole_ibfk_1` (`categoryid`),
  KEY `internalstockcatrole_ibfk_2` (`secroleid`),
  CONSTRAINT `internalstockcatrole_ibfk_1` FOREIGN KEY (`categoryid`) REFERENCES `stockcategory` (`categoryid`),
  CONSTRAINT `internalstockcatrole_ibfk_2` FOREIGN KEY (`secroleid`) REFERENCES `securityroles` (`secroleid`),
  CONSTRAINT `internalstockcatrole_ibfk_3` FOREIGN KEY (`categoryid`) REFERENCES `stockcategory` (`categoryid`),
  CONSTRAINT `internalstockcatrole_ibfk_4` FOREIGN KEY (`secroleid`) REFERENCES `securityroles` (`secroleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `jnltmpldetails`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jnltmpldetails` (
  `linenumber` int(11) NOT NULL DEFAULT '0',
  `templateid` int(11) NOT NULL DEFAULT '0',
  `tags` varchar(50) NOT NULL DEFAULT '0',
  `accountcode` varchar(20) NOT NULL DEFAULT '1',
  `amount` double NOT NULL DEFAULT '0',
  `narrative` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`templateid`,`linenumber`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `jnltmplheader`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jnltmplheader` (
  `templateid` int(11) NOT NULL DEFAULT '0',
  `templatedescription` varchar(50) NOT NULL DEFAULT '',
  `journaltype` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`templateid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `labelfields`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `labelfields` (
  `labelfieldid` int(11) NOT NULL AUTO_INCREMENT,
  `labelid` tinyint(4) NOT NULL,
  `fieldvalue` varchar(20) NOT NULL,
  `vpos` double NOT NULL DEFAULT '0',
  `hpos` double NOT NULL DEFAULT '0',
  `fontsize` tinyint(4) NOT NULL,
  `barcode` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`labelfieldid`),
  KEY `labelid` (`labelid`),
  KEY `vpos` (`vpos`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `labels`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `labels` (
  `labelid` tinyint(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL,
  `pagewidth` double NOT NULL DEFAULT '0',
  `pageheight` double NOT NULL DEFAULT '0',
  `height` double NOT NULL DEFAULT '0',
  `width` double NOT NULL DEFAULT '0',
  `topmargin` double NOT NULL DEFAULT '0',
  `leftmargin` double NOT NULL DEFAULT '0',
  `rowheight` double NOT NULL DEFAULT '0',
  `columnwidth` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`labelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `lastcostrollup`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `lastcostrollup` (
  `stockid` char(20) NOT NULL DEFAULT '',
  `totalonhand` double NOT NULL DEFAULT '0',
  `matcost` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `labcost` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `oheadcost` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `categoryid` char(6) NOT NULL DEFAULT '',
  `stockact` varchar(20) NOT NULL DEFAULT '0',
  `adjglact` varchar(20) NOT NULL DEFAULT '0',
  `newmatcost` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `newlabcost` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `newoheadcost` decimal(20,4) NOT NULL DEFAULT '0.0000'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `locations`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `locations` (
  `loccode` varchar(5) NOT NULL DEFAULT '',
  `locationname` varchar(50) NOT NULL DEFAULT '',
  `deladd1` varchar(40) NOT NULL DEFAULT '',
  `deladd2` varchar(40) NOT NULL DEFAULT '',
  `deladd3` varchar(40) NOT NULL DEFAULT '',
  `deladd4` varchar(40) NOT NULL DEFAULT '',
  `deladd5` varchar(20) NOT NULL DEFAULT '',
  `deladd6` varchar(15) NOT NULL DEFAULT '',
  `tel` varchar(30) NOT NULL DEFAULT '',
  `fax` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(55) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL DEFAULT '',
  `taxprovinceid` tinyint(4) NOT NULL DEFAULT '1',
  `cashsalecustomer` varchar(10) DEFAULT '',
  `managed` int(11) DEFAULT '0',
  `cashsalebranch` varchar(10) DEFAULT '',
  `internalrequest` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Allow (1) or not (0) internal request from this location',
  `usedforwo` tinyint(4) NOT NULL DEFAULT '1',
  `glaccountcode` varchar(20) NOT NULL DEFAULT '' COMMENT 'GL account of the location',
  `allowinvoicing` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Allow invoicing of items at this location',
  PRIMARY KEY (`loccode`),
  UNIQUE KEY `locationname` (`locationname`),
  KEY `taxprovinceid` (`taxprovinceid`),
  CONSTRAINT `locations_ibfk_1` FOREIGN KEY (`taxprovinceid`) REFERENCES `taxprovinces` (`taxprovinceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `locationusers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `locationusers` (
  `loccode` varchar(5) NOT NULL,
  `userid` varchar(20) NOT NULL,
  `canview` tinyint(4) NOT NULL DEFAULT '0',
  `canupd` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`loccode`,`userid`),
  KEY `UserId` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `locstock`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `locstock` (
  `loccode` varchar(5) NOT NULL DEFAULT '',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '0',
  `reorderlevel` bigint(20) NOT NULL DEFAULT '0',
  `bin` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`loccode`,`stockid`),
  KEY `StockID` (`stockid`),
  KEY `bin` (`bin`),
  CONSTRAINT `locstock_ibfk_1` FOREIGN KEY (`loccode`) REFERENCES `locations` (`loccode`),
  CONSTRAINT `locstock_ibfk_2` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `loctransfercancellations`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `loctransfercancellations` (
  `reference` int(11) NOT NULL,
  `stockid` varchar(20) NOT NULL,
  `cancelqty` double NOT NULL,
  `canceldate` datetime NOT NULL,
  `canceluserid` varchar(20) NOT NULL,
  KEY `Index1` (`reference`,`stockid`),
  KEY `Index2` (`canceldate`,`reference`,`stockid`),
  KEY `refstockid` (`reference`,`stockid`),
  KEY `cancelrefstockid` (`canceldate`,`reference`,`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `loctransfers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `loctransfers` (
  `reference` int(11) NOT NULL DEFAULT '0',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `shipqty` double NOT NULL DEFAULT '0',
  `recqty` double NOT NULL DEFAULT '0',
  `shipdate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `recdate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `shiploc` varchar(7) NOT NULL DEFAULT '',
  `recloc` varchar(7) NOT NULL DEFAULT '',
  KEY `Reference` (`reference`,`stockid`),
  KEY `ShipLoc` (`shiploc`),
  KEY `RecLoc` (`recloc`),
  KEY `StockID` (`stockid`),
  CONSTRAINT `loctransfers_ibfk_1` FOREIGN KEY (`shiploc`) REFERENCES `locations` (`loccode`),
  CONSTRAINT `loctransfers_ibfk_2` FOREIGN KEY (`recloc`) REFERENCES `locations` (`loccode`),
  CONSTRAINT `loctransfers_ibfk_3` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores Shipments To And From Locations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mailgroupdetails`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mailgroupdetails` (
  `groupname` varchar(100) NOT NULL,
  `userid` varchar(20) NOT NULL,
  KEY `userid` (`userid`),
  KEY `groupname` (`groupname`),
  CONSTRAINT `mailgroupdetails_ibfk_1` FOREIGN KEY (`groupname`) REFERENCES `mailgroups` (`groupname`),
  CONSTRAINT `mailgroupdetails_ibfk_2` FOREIGN KEY (`userid`) REFERENCES `www_users` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mailgroups`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mailgroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupname` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `groupname` (`groupname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `manufacturers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `manufacturers` (
  `manufacturers_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturers_name` varchar(32) NOT NULL,
  `manufacturers_url` varchar(50) NOT NULL DEFAULT '',
  `manufacturers_image` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`manufacturers_id`),
  KEY `manufacturers_name` (`manufacturers_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mrpcalendar`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mrpcalendar` (
  `calendardate` date NOT NULL,
  `daynumber` int(6) NOT NULL,
  `manufacturingflag` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`calendardate`),
  KEY `daynumber` (`daynumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mrpdemands`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mrpdemands` (
  `demandid` int(11) NOT NULL AUTO_INCREMENT,
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `mrpdemandtype` varchar(6) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '0',
  `duedate` date NOT NULL DEFAULT '1000-01-01',
  PRIMARY KEY (`demandid`),
  KEY `StockID` (`stockid`),
  KEY `mrpdemands_ibfk_1` (`mrpdemandtype`),
  CONSTRAINT `mrpdemands_ibfk_1` FOREIGN KEY (`mrpdemandtype`) REFERENCES `mrpdemandtypes` (`mrpdemandtype`),
  CONSTRAINT `mrpdemands_ibfk_2` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mrpdemandtypes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mrpdemandtypes` (
  `mrpdemandtype` varchar(6) NOT NULL DEFAULT '',
  `description` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`mrpdemandtype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mrpplannedorders`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mrpplannedorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `part` char(20) DEFAULT NULL,
  `duedate` date DEFAULT NULL,
  `supplyquantity` double DEFAULT NULL,
  `ordertype` varchar(6) DEFAULT NULL,
  `orderno` int(11) DEFAULT NULL,
  `mrpdate` date DEFAULT NULL,
  `updateflag` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `offers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `offers` (
  `offerid` int(11) NOT NULL AUTO_INCREMENT,
  `tenderid` int(11) NOT NULL DEFAULT '0',
  `supplierid` varchar(10) NOT NULL DEFAULT '',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '0',
  `uom` varchar(15) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  `expirydate` date NOT NULL DEFAULT '1000-01-01',
  `currcode` char(3) NOT NULL DEFAULT '',
  PRIMARY KEY (`offerid`),
  KEY `offers_ibfk_1` (`supplierid`),
  KEY `offers_ibfk_2` (`stockid`),
  CONSTRAINT `offers_ibfk_1` FOREIGN KEY (`supplierid`) REFERENCES `suppliers` (`supplierid`),
  CONSTRAINT `offers_ibfk_2` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `orderdeliverydifferenceslog`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orderdeliverydifferenceslog` (
  `orderno` int(11) NOT NULL DEFAULT '0',
  `invoiceno` int(11) NOT NULL DEFAULT '0',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `quantitydiff` double NOT NULL DEFAULT '0',
  `debtorno` varchar(10) NOT NULL DEFAULT '',
  `branch` varchar(10) NOT NULL DEFAULT '',
  `can_or_bo` char(3) NOT NULL DEFAULT 'CAN',
  KEY `StockID` (`stockid`),
  KEY `DebtorNo` (`debtorno`,`branch`),
  KEY `Can_or_BO` (`can_or_bo`),
  KEY `OrderNo` (`orderno`),
  KEY `orderdeliverydifferenceslog_ibfk_2` (`branch`,`debtorno`),
  CONSTRAINT `orderdeliverydifferenceslog_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `orderdeliverydifferenceslog_ibfk_2` FOREIGN KEY (`branch`, `debtorno`) REFERENCES `custbranch` (`branchcode`, `debtorno`),
  CONSTRAINT `orderdeliverydifferenceslog_ibfk_3` FOREIGN KEY (`orderno`) REFERENCES `salesorders` (`orderno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paymentmethods`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `paymentmethods` (
  `paymentid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `paymentname` varchar(15) NOT NULL DEFAULT '',
  `paymenttype` int(11) NOT NULL DEFAULT '1',
  `receipttype` int(11) NOT NULL DEFAULT '1',
  `usepreprintedstationery` tinyint(4) NOT NULL DEFAULT '0',
  `opencashdrawer` tinyint(4) NOT NULL DEFAULT '0',
  `percentdiscount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`paymentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paymentterms`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `paymentterms` (
  `termsindicator` char(2) NOT NULL DEFAULT '',
  `terms` char(40) NOT NULL DEFAULT '',
  `daysbeforedue` smallint(6) NOT NULL DEFAULT '0',
  `dayinfollowingmonth` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`termsindicator`),
  KEY `DaysBeforeDue` (`daysbeforedue`),
  KEY `DayInFollowingMonth` (`dayinfollowingmonth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pcashdetails`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pcashdetails` (
  `counterindex` int(20) NOT NULL AUTO_INCREMENT,
  `tabcode` varchar(20) NOT NULL,
  `tag` int(11) NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `codeexpense` varchar(20) NOT NULL,
  `amount` double NOT NULL,
  `authorized` date NOT NULL COMMENT 'date cash assigment was revised and authorized by authorizer from tabs table',
  `posted` tinyint(4) NOT NULL COMMENT 'has (or has not) been posted into gltrans',
  `purpose` text,
  `notes` text NOT NULL,
  `receipt` text COMMENT 'Column redundant. Replaced by receipt file upload. Nov 2017.',
  PRIMARY KEY (`counterindex`),
  UNIQUE KEY `tabcodedate` (`tabcode`,`date`,`codeexpense`,`counterindex`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pcashdetailtaxes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pcashdetailtaxes` (
  `counterindex` int(20) NOT NULL AUTO_INCREMENT,
  `pccashdetail` int(20) NOT NULL DEFAULT '0',
  `calculationorder` tinyint(4) NOT NULL DEFAULT '0',
  `description` varchar(40) NOT NULL DEFAULT '',
  `taxauthid` tinyint(4) NOT NULL DEFAULT '0',
  `purchtaxglaccount` varchar(20) NOT NULL DEFAULT '',
  `taxontax` tinyint(4) NOT NULL DEFAULT '0',
  `taxrate` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`counterindex`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pcexpenses`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pcexpenses` (
  `codeexpense` varchar(20) NOT NULL COMMENT 'code for the group',
  `description` varchar(50) NOT NULL COMMENT 'text description, e.g. meals, train tickets, fuel, etc',
  `glaccount` varchar(20) NOT NULL DEFAULT '0',
  `tag` tinyint(4) NOT NULL DEFAULT '0',
  `taxcatid` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`codeexpense`),
  KEY `glaccount` (`glaccount`),
  CONSTRAINT `pcexpenses_ibfk_1` FOREIGN KEY (`glaccount`) REFERENCES `chartmaster` (`accountcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pcreceipts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pcreceipts` (
  `counterindex` int(20) NOT NULL AUTO_INCREMENT,
  `pccashdetail` int(20) NOT NULL DEFAULT '0' COMMENT 'Expenses record identity',
  `hashfile` varchar(32) NOT NULL DEFAULT '' COMMENT 'MD5 hash of uploaded receipt file',
  `type` varchar(80) NOT NULL DEFAULT '' COMMENT 'Mime type of uploaded receipt file',
  `extension` varchar(4) NOT NULL DEFAULT '' COMMENT 'File extension of uploaded receipt',
  `size` int(20) NOT NULL DEFAULT '0' COMMENT 'File size of uploaded receipt',
  PRIMARY KEY (`counterindex`),
  KEY `pcreceipts_ibfk_1` (`pccashdetail`),
  CONSTRAINT `pcreceipts_ibfk_1` FOREIGN KEY (`pccashdetail`) REFERENCES `pcashdetails` (`counterindex`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pctabexpenses`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pctabexpenses` (
  `typetabcode` varchar(20) NOT NULL,
  `codeexpense` varchar(20) NOT NULL,
  KEY `typetabcode` (`typetabcode`),
  KEY `codeexpense` (`codeexpense`),
  CONSTRAINT `pctabexpenses_ibfk_1` FOREIGN KEY (`typetabcode`) REFERENCES `pctypetabs` (`typetabcode`),
  CONSTRAINT `pctabexpenses_ibfk_2` FOREIGN KEY (`codeexpense`) REFERENCES `pcexpenses` (`codeexpense`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pctabs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pctabs` (
  `tabcode` varchar(20) NOT NULL,
  `usercode` varchar(20) NOT NULL COMMENT 'code of user employee from www_users',
  `typetabcode` varchar(20) NOT NULL,
  `currency` char(3) NOT NULL,
  `tablimit` double NOT NULL,
  `assigner` varchar(100) DEFAULT NULL,
  `authorizer` varchar(100) DEFAULT NULL,
  `authorizerexpenses` varchar(20) NOT NULL,
  `glaccountassignment` varchar(20) NOT NULL DEFAULT '0',
  `glaccountpcash` varchar(20) NOT NULL DEFAULT '0',
  `defaulttag` tinyint(4) NOT NULL DEFAULT '0',
  `taxgroupid` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`tabcode`),
  KEY `usercode` (`usercode`),
  KEY `typetabcode` (`typetabcode`),
  KEY `currency` (`currency`),
  KEY `authorizer` (`authorizer`),
  KEY `glaccountassignment` (`glaccountassignment`),
  CONSTRAINT `pctabs_ibfk_1` FOREIGN KEY (`usercode`) REFERENCES `www_users` (`userid`),
  CONSTRAINT `pctabs_ibfk_2` FOREIGN KEY (`typetabcode`) REFERENCES `pctypetabs` (`typetabcode`),
  CONSTRAINT `pctabs_ibfk_3` FOREIGN KEY (`currency`) REFERENCES `currencies` (`currabrev`),
  CONSTRAINT `pctabs_ibfk_5` FOREIGN KEY (`glaccountassignment`) REFERENCES `chartmaster` (`accountcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pctypetabs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pctypetabs` (
  `typetabcode` varchar(20) NOT NULL COMMENT 'code for the type of petty cash tab',
  `typetabdescription` varchar(50) NOT NULL COMMENT 'text description, e.g. tab for CEO',
  PRIMARY KEY (`typetabcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `periods`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `periods` (
  `periodno` smallint(6) NOT NULL DEFAULT '0',
  `lastdate_in_period` date NOT NULL DEFAULT '1000-01-01',
  PRIMARY KEY (`periodno`),
  KEY `LastDate_in_Period` (`lastdate_in_period`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pickinglistdetails`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pickinglistdetails` (
  `pickinglistno` int(11) NOT NULL DEFAULT '0',
  `pickinglistlineno` int(11) NOT NULL DEFAULT '0',
  `orderlineno` int(11) NOT NULL DEFAULT '0',
  `qtyexpected` double NOT NULL DEFAULT '0',
  `qtypicked` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`pickinglistno`,`pickinglistlineno`),
  CONSTRAINT `pickinglistdetails_ibfk_1` FOREIGN KEY (`pickinglistno`) REFERENCES `pickinglists` (`pickinglistno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pickinglists`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pickinglists` (
  `pickinglistno` int(11) NOT NULL DEFAULT '0',
  `orderno` int(11) NOT NULL DEFAULT '0',
  `pickinglistdate` date NOT NULL DEFAULT '1000-01-01',
  `dateprinted` date NOT NULL DEFAULT '1000-01-01',
  `deliverynotedate` date NOT NULL DEFAULT '1000-01-01',
  PRIMARY KEY (`pickinglistno`),
  KEY `pickinglists_ibfk_1` (`orderno`),
  CONSTRAINT `pickinglists_ibfk_1` FOREIGN KEY (`orderno`) REFERENCES `salesorders` (`orderno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pickreq`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pickreq` (
  `prid` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(20) NOT NULL DEFAULT '',
  `shippedby` varchar(20) NOT NULL DEFAULT '',
  `initdate` date NOT NULL DEFAULT '1000-01-01',
  `requestdate` date NOT NULL DEFAULT '1000-01-01',
  `shipdate` date NOT NULL DEFAULT '1000-01-01',
  `status` varchar(12) NOT NULL DEFAULT '',
  `comments` text,
  `closed` tinyint(4) NOT NULL DEFAULT '0',
  `loccode` varchar(5) NOT NULL DEFAULT '',
  `orderno` int(11) NOT NULL DEFAULT '1',
  `consignment` varchar(15) NOT NULL DEFAULT '',
  `packages` int(11) NOT NULL DEFAULT '1' COMMENT 'number of cartons',
  PRIMARY KEY (`prid`),
  KEY `orderno` (`orderno`),
  KEY `requestdate` (`requestdate`),
  KEY `shipdate` (`shipdate`),
  KEY `status` (`status`),
  KEY `closed` (`closed`),
  KEY `loccode` (`loccode`),
  CONSTRAINT `pickreq_ibfk_1` FOREIGN KEY (`loccode`) REFERENCES `locations` (`loccode`),
  CONSTRAINT `pickreq_ibfk_2` FOREIGN KEY (`orderno`) REFERENCES `salesorders` (`orderno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pickreqdetails`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pickreqdetails` (
  `detailno` int(11) NOT NULL AUTO_INCREMENT,
  `prid` int(11) NOT NULL DEFAULT '1',
  `orderlineno` int(11) NOT NULL DEFAULT '0',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `qtyexpected` double NOT NULL DEFAULT '0',
  `qtypicked` double NOT NULL DEFAULT '0',
  `invoicedqty` double NOT NULL DEFAULT '0',
  `shipqty` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`detailno`),
  KEY `prid` (`prid`),
  KEY `stockid` (`stockid`),
  CONSTRAINT `pickreqdetails_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `pickreqdetails_ibfk_2` FOREIGN KEY (`prid`) REFERENCES `pickreq` (`prid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pickserialdetails`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pickserialdetails` (
  `serialmoveid` int(11) NOT NULL AUTO_INCREMENT,
  `detailno` int(11) NOT NULL DEFAULT '1',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `serialno` varchar(30) NOT NULL DEFAULT '',
  `moveqty` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialmoveid`),
  KEY `detailno` (`detailno`),
  KEY `stockid` (`stockid`,`serialno`),
  KEY `serialno` (`serialno`),
  CONSTRAINT `pickserialdetails_ibfk_1` FOREIGN KEY (`detailno`) REFERENCES `pickreqdetails` (`detailno`),
  CONSTRAINT `pickserialdetails_ibfk_2` FOREIGN KEY (`stockid`, `serialno`) REFERENCES `stockserialitems` (`stockid`, `serialno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pricematrix`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pricematrix` (
  `salestype` char(2) NOT NULL DEFAULT '',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `quantitybreak` int(11) NOT NULL DEFAULT '1',
  `price` double NOT NULL DEFAULT '0',
  `currabrev` char(3) NOT NULL DEFAULT '',
  `startdate` date NOT NULL DEFAULT '1000-01-01',
  `enddate` date NOT NULL DEFAULT '9999-12-31',
  PRIMARY KEY (`salestype`,`stockid`,`currabrev`,`quantitybreak`,`startdate`,`enddate`),
  KEY `SalesType` (`salestype`),
  KEY `currabrev` (`currabrev`),
  KEY `stockid` (`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `prices`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `prices` (
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `typeabbrev` char(2) NOT NULL DEFAULT '',
  `currabrev` char(3) NOT NULL DEFAULT '',
  `debtorno` varchar(10) NOT NULL DEFAULT '',
  `price` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `branchcode` varchar(10) NOT NULL DEFAULT '',
  `startdate` date NOT NULL DEFAULT '1000-01-01',
  `enddate` date NOT NULL DEFAULT '9999-12-31',
  PRIMARY KEY (`stockid`,`typeabbrev`,`currabrev`,`debtorno`,`branchcode`,`startdate`,`enddate`),
  KEY `CurrAbrev` (`currabrev`),
  KEY `DebtorNo` (`debtorno`),
  KEY `StockID` (`stockid`),
  KEY `TypeAbbrev` (`typeabbrev`),
  CONSTRAINT `prices_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `prices_ibfk_2` FOREIGN KEY (`currabrev`) REFERENCES `currencies` (`currabrev`),
  CONSTRAINT `prices_ibfk_3` FOREIGN KEY (`typeabbrev`) REFERENCES `salestypes` (`typeabbrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `prodspecs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `prodspecs` (
  `keyval` varchar(25) NOT NULL,
  `testid` int(11) NOT NULL,
  `defaultvalue` varchar(150) NOT NULL DEFAULT '',
  `targetvalue` varchar(30) NOT NULL DEFAULT '',
  `rangemin` float DEFAULT NULL,
  `rangemax` float DEFAULT NULL,
  `showoncert` tinyint(11) NOT NULL DEFAULT '1',
  `showonspec` tinyint(4) NOT NULL DEFAULT '1',
  `showontestplan` tinyint(4) NOT NULL DEFAULT '1',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`keyval`,`testid`),
  KEY `testid` (`testid`),
  CONSTRAINT `prodspecs_ibfk_1` FOREIGN KEY (`testid`) REFERENCES `qatests` (`testid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `purchdata`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchdata` (
  `supplierno` char(10) NOT NULL DEFAULT '',
  `stockid` char(20) NOT NULL DEFAULT '',
  `price` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `suppliersuom` char(50) NOT NULL DEFAULT '',
  `conversionfactor` double NOT NULL DEFAULT '1',
  `supplierdescription` char(50) NOT NULL DEFAULT '',
  `leadtime` smallint(6) NOT NULL DEFAULT '1',
  `preferred` tinyint(4) NOT NULL DEFAULT '0',
  `effectivefrom` date NOT NULL,
  `suppliers_partno` varchar(50) NOT NULL DEFAULT '',
  `minorderqty` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`supplierno`,`stockid`,`effectivefrom`),
  KEY `StockID` (`stockid`),
  KEY `SupplierNo` (`supplierno`),
  KEY `Preferred` (`preferred`),
  CONSTRAINT `purchdata_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `purchdata_ibfk_2` FOREIGN KEY (`supplierno`) REFERENCES `suppliers` (`supplierid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `purchorderauth`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchorderauth` (
  `userid` varchar(20) NOT NULL DEFAULT '',
  `currabrev` char(3) NOT NULL DEFAULT '',
  `cancreate` smallint(2) NOT NULL DEFAULT '0',
  `authlevel` double NOT NULL DEFAULT '0',
  `offhold` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`,`currabrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `purchorderdetails`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchorderdetails` (
  `podetailitem` int(11) NOT NULL AUTO_INCREMENT,
  `orderno` int(11) NOT NULL DEFAULT '0',
  `itemcode` varchar(20) NOT NULL DEFAULT '',
  `deliverydate` date NOT NULL DEFAULT '1000-01-01',
  `itemdescription` varchar(100) NOT NULL,
  `glcode` varchar(20) NOT NULL DEFAULT '0',
  `qtyinvoiced` double NOT NULL DEFAULT '0',
  `unitprice` double NOT NULL DEFAULT '0',
  `actprice` double NOT NULL DEFAULT '0',
  `stdcostunit` double NOT NULL DEFAULT '0',
  `quantityord` double NOT NULL DEFAULT '0',
  `quantityrecd` double NOT NULL DEFAULT '0',
  `shiptref` int(11) NOT NULL DEFAULT '0',
  `jobref` varchar(20) NOT NULL DEFAULT '',
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  `suppliersunit` varchar(50) DEFAULT NULL,
  `suppliers_partno` varchar(50) NOT NULL DEFAULT '',
  `assetid` int(11) NOT NULL DEFAULT '0',
  `conversionfactor` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`podetailitem`),
  KEY `DeliveryDate` (`deliverydate`),
  KEY `GLCode` (`glcode`),
  KEY `ItemCode` (`itemcode`),
  KEY `JobRef` (`jobref`),
  KEY `OrderNo` (`orderno`),
  KEY `ShiptRef` (`shiptref`),
  KEY `Completed` (`completed`),
  CONSTRAINT `purchorderdetails_ibfk_1` FOREIGN KEY (`orderno`) REFERENCES `purchorders` (`orderno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `purchorders`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchorders` (
  `orderno` int(11) NOT NULL AUTO_INCREMENT,
  `supplierno` varchar(10) NOT NULL DEFAULT '',
  `comments` longblob,
  `orddate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `rate` double NOT NULL DEFAULT '1',
  `dateprinted` datetime DEFAULT NULL,
  `allowprint` tinyint(4) NOT NULL DEFAULT '1',
  `initiator` varchar(20) DEFAULT NULL,
  `requisitionno` varchar(15) DEFAULT NULL,
  `intostocklocation` varchar(5) NOT NULL DEFAULT '',
  `deladd1` varchar(40) NOT NULL DEFAULT '',
  `deladd2` varchar(40) NOT NULL DEFAULT '',
  `deladd3` varchar(40) NOT NULL DEFAULT '',
  `deladd4` varchar(40) NOT NULL DEFAULT '',
  `deladd5` varchar(20) NOT NULL DEFAULT '',
  `deladd6` varchar(15) NOT NULL DEFAULT '',
  `tel` varchar(30) NOT NULL DEFAULT '',
  `suppdeladdress1` varchar(40) NOT NULL DEFAULT '',
  `suppdeladdress2` varchar(40) NOT NULL DEFAULT '',
  `suppdeladdress3` varchar(40) NOT NULL DEFAULT '',
  `suppdeladdress4` varchar(40) NOT NULL DEFAULT '',
  `suppdeladdress5` varchar(20) NOT NULL DEFAULT '',
  `suppdeladdress6` varchar(15) NOT NULL DEFAULT '',
  `suppliercontact` varchar(30) NOT NULL DEFAULT '',
  `supptel` varchar(30) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL DEFAULT '',
  `version` decimal(3,2) NOT NULL DEFAULT '1.00',
  `revised` date NOT NULL DEFAULT '1000-01-01',
  `realorderno` varchar(16) NOT NULL DEFAULT '',
  `deliveryby` varchar(100) NOT NULL DEFAULT '',
  `deliverydate` date NOT NULL DEFAULT '1000-01-01',
  `status` varchar(12) NOT NULL DEFAULT '',
  `stat_comment` text NOT NULL,
  `paymentterms` char(2) NOT NULL DEFAULT '',
  `port` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`orderno`),
  KEY `OrdDate` (`orddate`),
  KEY `SupplierNo` (`supplierno`),
  KEY `IntoStockLocation` (`intostocklocation`),
  KEY `AllowPrintPO` (`allowprint`),
  CONSTRAINT `purchorders_ibfk_1` FOREIGN KEY (`supplierno`) REFERENCES `suppliers` (`supplierid`),
  CONSTRAINT `purchorders_ibfk_2` FOREIGN KEY (`intostocklocation`) REFERENCES `locations` (`loccode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `qasamples`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qasamples` (
  `sampleid` int(11) NOT NULL AUTO_INCREMENT,
  `prodspeckey` varchar(25) NOT NULL DEFAULT '',
  `lotkey` varchar(25) NOT NULL DEFAULT '',
  `identifier` varchar(10) NOT NULL DEFAULT '',
  `createdby` varchar(15) NOT NULL DEFAULT '',
  `sampledate` date NOT NULL DEFAULT '1000-01-01',
  `comments` varchar(255) NOT NULL DEFAULT '',
  `cert` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sampleid`),
  KEY `prodspeckey` (`prodspeckey`,`lotkey`),
  CONSTRAINT `qasamples_ibfk_1` FOREIGN KEY (`prodspeckey`) REFERENCES `prodspecs` (`keyval`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `qatests`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qatests` (
  `testid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `method` varchar(20) DEFAULT NULL,
  `groupby` varchar(20) DEFAULT NULL,
  `units` varchar(20) NOT NULL,
  `type` varchar(15) NOT NULL,
  `defaultvalue` varchar(150) NOT NULL DEFAULT '''''',
  `numericvalue` tinyint(4) NOT NULL DEFAULT '0',
  `showoncert` int(11) NOT NULL DEFAULT '1',
  `showonspec` int(11) NOT NULL DEFAULT '1',
  `showontestplan` tinyint(4) NOT NULL DEFAULT '1',
  `active` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`testid`),
  KEY `name` (`name`),
  KEY `groupname` (`groupby`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recurringsalesorders`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recurringsalesorders` (
  `recurrorderno` int(11) NOT NULL AUTO_INCREMENT,
  `debtorno` varchar(10) NOT NULL DEFAULT '',
  `branchcode` varchar(10) NOT NULL DEFAULT '',
  `customerref` varchar(50) NOT NULL DEFAULT '',
  `buyername` varchar(50) DEFAULT NULL,
  `comments` longblob,
  `orddate` date NOT NULL DEFAULT '1000-01-01',
  `ordertype` char(2) NOT NULL DEFAULT '',
  `shipvia` int(11) NOT NULL DEFAULT '0',
  `deladd1` varchar(40) NOT NULL DEFAULT '',
  `deladd2` varchar(40) NOT NULL DEFAULT '',
  `deladd3` varchar(40) NOT NULL DEFAULT '',
  `deladd4` varchar(40) DEFAULT NULL,
  `deladd5` varchar(20) NOT NULL DEFAULT '',
  `deladd6` varchar(15) NOT NULL DEFAULT '',
  `contactphone` varchar(25) DEFAULT NULL,
  `contactemail` varchar(25) DEFAULT NULL,
  `deliverto` varchar(40) NOT NULL DEFAULT '',
  `freightcost` double NOT NULL DEFAULT '0',
  `fromstkloc` varchar(5) NOT NULL DEFAULT '',
  `lastrecurrence` date NOT NULL DEFAULT '1000-01-01',
  `stopdate` date NOT NULL DEFAULT '1000-01-01',
  `frequency` tinyint(4) NOT NULL DEFAULT '1',
  `autoinvoice` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`recurrorderno`),
  KEY `debtorno` (`debtorno`),
  KEY `orddate` (`orddate`),
  KEY `ordertype` (`ordertype`),
  KEY `locationindex` (`fromstkloc`),
  KEY `branchcode` (`branchcode`,`debtorno`),
  CONSTRAINT `recurringsalesorders_ibfk_1` FOREIGN KEY (`branchcode`, `debtorno`) REFERENCES `custbranch` (`branchcode`, `debtorno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recurrsalesorderdetails`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recurrsalesorderdetails` (
  `recurrorderno` int(11) NOT NULL DEFAULT '0',
  `stkcode` varchar(20) NOT NULL DEFAULT '',
  `unitprice` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `discountpercent` double NOT NULL DEFAULT '0',
  `narrative` text NOT NULL,
  KEY `orderno` (`recurrorderno`),
  KEY `stkcode` (`stkcode`),
  CONSTRAINT `recurrsalesorderdetails_ibfk_1` FOREIGN KEY (`recurrorderno`) REFERENCES `recurringsalesorders` (`recurrorderno`),
  CONSTRAINT `recurrsalesorderdetails_ibfk_2` FOREIGN KEY (`stkcode`) REFERENCES `stockmaster` (`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `relateditems`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `relateditems` (
  `stockid` varchar(20) CHARACTER SET utf8 NOT NULL,
  `related` varchar(20) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`stockid`,`related`),
  UNIQUE KEY `Related` (`related`,`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reportcolumns`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reportcolumns` (
  `reportid` smallint(6) NOT NULL DEFAULT '0',
  `colno` smallint(6) NOT NULL DEFAULT '0',
  `heading1` varchar(15) NOT NULL DEFAULT '',
  `heading2` varchar(15) DEFAULT NULL,
  `calculation` tinyint(1) NOT NULL DEFAULT '0',
  `periodfrom` smallint(6) DEFAULT NULL,
  `periodto` smallint(6) DEFAULT NULL,
  `datatype` varchar(15) DEFAULT NULL,
  `colnumerator` tinyint(4) DEFAULT NULL,
  `coldenominator` tinyint(4) DEFAULT NULL,
  `calcoperator` char(1) DEFAULT NULL,
  `budgetoractual` tinyint(1) NOT NULL DEFAULT '0',
  `valformat` char(1) NOT NULL DEFAULT 'N',
  `constant` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`reportid`,`colno`),
  CONSTRAINT `reportcolumns_ibfk_1` FOREIGN KEY (`reportid`) REFERENCES `reportheaders` (`reportid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reportfields`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reportfields` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `reportid` int(5) NOT NULL DEFAULT '0',
  `entrytype` varchar(15) NOT NULL DEFAULT '',
  `seqnum` int(3) NOT NULL DEFAULT '0',
  `fieldname` varchar(80) NOT NULL DEFAULT '',
  `displaydesc` varchar(25) NOT NULL DEFAULT '',
  `visible` enum('1','0') NOT NULL DEFAULT '1',
  `columnbreak` enum('1','0') NOT NULL DEFAULT '1',
  `params` text,
  PRIMARY KEY (`id`),
  KEY `reportid` (`reportid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reportheaders`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reportheaders` (
  `reportid` smallint(6) NOT NULL AUTO_INCREMENT,
  `reportheading` varchar(80) NOT NULL DEFAULT '',
  `groupbydata1` varchar(15) NOT NULL DEFAULT '',
  `newpageafter1` tinyint(1) NOT NULL DEFAULT '0',
  `lower1` varchar(10) NOT NULL DEFAULT '',
  `upper1` varchar(10) NOT NULL DEFAULT '',
  `groupbydata2` varchar(15) DEFAULT NULL,
  `newpageafter2` tinyint(1) NOT NULL DEFAULT '0',
  `lower2` varchar(10) DEFAULT NULL,
  `upper2` varchar(10) DEFAULT NULL,
  `groupbydata3` varchar(15) DEFAULT NULL,
  `newpageafter3` tinyint(1) NOT NULL DEFAULT '0',
  `lower3` varchar(10) DEFAULT NULL,
  `upper3` varchar(10) DEFAULT NULL,
  `groupbydata4` varchar(15) NOT NULL DEFAULT '',
  `newpageafter4` tinyint(1) NOT NULL DEFAULT '0',
  `upper4` varchar(10) NOT NULL DEFAULT '',
  `lower4` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`reportid`),
  KEY `ReportHeading` (`reportheading`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reportlinks`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reportlinks` (
  `table1` varchar(25) NOT NULL DEFAULT '',
  `table2` varchar(25) NOT NULL DEFAULT '',
  `equation` varchar(75) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reports`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reports` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `reportname` varchar(30) NOT NULL DEFAULT '',
  `reporttype` char(3) NOT NULL DEFAULT 'rpt',
  `groupname` varchar(9) NOT NULL DEFAULT 'misc',
  `defaultreport` enum('1','0') NOT NULL DEFAULT '0',
  `papersize` varchar(15) NOT NULL DEFAULT 'A4,210,297',
  `paperorientation` enum('P','L') NOT NULL DEFAULT 'P',
  `margintop` int(3) NOT NULL DEFAULT '10',
  `marginbottom` int(3) NOT NULL DEFAULT '10',
  `marginleft` int(3) NOT NULL DEFAULT '10',
  `marginright` int(3) NOT NULL DEFAULT '10',
  `coynamefont` varchar(20) NOT NULL DEFAULT 'Helvetica',
  `coynamefontsize` int(3) NOT NULL DEFAULT '12',
  `coynamefontcolor` varchar(11) NOT NULL DEFAULT '0,0,0',
  `coynamealign` enum('L','C','R') NOT NULL DEFAULT 'C',
  `coynameshow` enum('1','0') NOT NULL DEFAULT '1',
  `title1desc` varchar(50) NOT NULL DEFAULT '%reportname%',
  `title1font` varchar(20) NOT NULL DEFAULT 'Helvetica',
  `title1fontsize` int(3) NOT NULL DEFAULT '10',
  `title1fontcolor` varchar(11) NOT NULL DEFAULT '0,0,0',
  `title1fontalign` enum('L','C','R') NOT NULL DEFAULT 'C',
  `title1show` enum('1','0') NOT NULL DEFAULT '1',
  `title2desc` varchar(50) NOT NULL DEFAULT 'Report Generated %date%',
  `title2font` varchar(20) NOT NULL DEFAULT 'Helvetica',
  `title2fontsize` int(3) NOT NULL DEFAULT '10',
  `title2fontcolor` varchar(11) NOT NULL DEFAULT '0,0,0',
  `title2fontalign` enum('L','C','R') NOT NULL DEFAULT 'C',
  `title2show` enum('1','0') NOT NULL DEFAULT '1',
  `filterfont` varchar(10) NOT NULL DEFAULT 'Helvetica',
  `filterfontsize` int(3) NOT NULL DEFAULT '8',
  `filterfontcolor` varchar(11) NOT NULL DEFAULT '0,0,0',
  `filterfontalign` enum('L','C','R') NOT NULL DEFAULT 'L',
  `datafont` varchar(10) NOT NULL DEFAULT 'Helvetica',
  `datafontsize` int(3) NOT NULL DEFAULT '10',
  `datafontcolor` varchar(10) NOT NULL DEFAULT 'black',
  `datafontalign` enum('L','C','R') NOT NULL DEFAULT 'L',
  `totalsfont` varchar(10) NOT NULL DEFAULT 'Helvetica',
  `totalsfontsize` int(3) NOT NULL DEFAULT '10',
  `totalsfontcolor` varchar(11) NOT NULL DEFAULT '0,0,0',
  `totalsfontalign` enum('L','C','R') NOT NULL DEFAULT 'L',
  `col1width` int(3) NOT NULL DEFAULT '25',
  `col2width` int(3) NOT NULL DEFAULT '25',
  `col3width` int(3) NOT NULL DEFAULT '25',
  `col4width` int(3) NOT NULL DEFAULT '25',
  `col5width` int(3) NOT NULL DEFAULT '25',
  `col6width` int(3) NOT NULL DEFAULT '25',
  `col7width` int(3) NOT NULL DEFAULT '25',
  `col8width` int(3) NOT NULL DEFAULT '25',
  `col9width` int(3) NOT NULL DEFAULT '25',
  `col10width` int(3) NOT NULL DEFAULT '25',
  `col11width` int(3) NOT NULL DEFAULT '25',
  `col12width` int(3) NOT NULL DEFAULT '25',
  `col13width` int(3) NOT NULL DEFAULT '25',
  `col14width` int(3) NOT NULL DEFAULT '25',
  `col15width` int(3) NOT NULL DEFAULT '25',
  `col16width` int(3) NOT NULL DEFAULT '25',
  `col17width` int(3) NOT NULL DEFAULT '25',
  `col18width` int(3) NOT NULL DEFAULT '25',
  `col19width` int(3) NOT NULL DEFAULT '25',
  `col20width` int(3) NOT NULL DEFAULT '25',
  `table1` varchar(25) NOT NULL DEFAULT '',
  `table2` varchar(25) DEFAULT NULL,
  `table2criteria` varchar(75) DEFAULT NULL,
  `table3` varchar(25) DEFAULT NULL,
  `table3criteria` varchar(75) DEFAULT NULL,
  `table4` varchar(25) DEFAULT NULL,
  `table4criteria` varchar(75) DEFAULT NULL,
  `table5` varchar(25) DEFAULT NULL,
  `table5criteria` varchar(75) DEFAULT NULL,
  `table6` varchar(25) DEFAULT NULL,
  `table6criteria` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`reportname`,`groupname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesanalysis`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `salesanalysis` (
  `typeabbrev` char(2) NOT NULL DEFAULT '',
  `periodno` smallint(6) NOT NULL DEFAULT '0',
  `amt` double NOT NULL DEFAULT '0',
  `cost` double NOT NULL DEFAULT '0',
  `cust` varchar(10) NOT NULL DEFAULT '',
  `custbranch` varchar(10) NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '0',
  `disc` double NOT NULL DEFAULT '0',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `area` varchar(3) NOT NULL,
  `budgetoractual` tinyint(1) NOT NULL DEFAULT '0',
  `salesperson` varchar(4) NOT NULL DEFAULT '',
  `stkcategory` varchar(6) NOT NULL DEFAULT '',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `CustBranch` (`custbranch`),
  KEY `Cust` (`cust`),
  KEY `PeriodNo` (`periodno`),
  KEY `StkCategory` (`stkcategory`),
  KEY `StockID` (`stockid`),
  KEY `TypeAbbrev` (`typeabbrev`),
  KEY `Area` (`area`),
  KEY `BudgetOrActual` (`budgetoractual`),
  KEY `Salesperson` (`salesperson`),
  CONSTRAINT `salesanalysis_ibfk_1` FOREIGN KEY (`periodno`) REFERENCES `periods` (`periodno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salescat`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `salescat` (
  `salescatid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `parentcatid` tinyint(4) DEFAULT NULL,
  `salescatname` varchar(50) DEFAULT NULL,
  `active` int(11) NOT NULL DEFAULT '1' COMMENT '1 if active 0 if inactive',
  PRIMARY KEY (`salescatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salescatprod`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `salescatprod` (
  `salescatid` tinyint(4) NOT NULL DEFAULT '0',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `manufacturers_id` int(11) NOT NULL,
  `featured` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`salescatid`,`stockid`),
  KEY `salescatid` (`salescatid`),
  KEY `stockid` (`stockid`),
  KEY `manufacturer_id` (`manufacturers_id`),
  CONSTRAINT `salescatprod_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `salescatprod_ibfk_2` FOREIGN KEY (`salescatid`) REFERENCES `salescat` (`salescatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salescattranslations`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `salescattranslations` (
  `salescatid` tinyint(4) NOT NULL DEFAULT '0',
  `language_id` varchar(10) NOT NULL DEFAULT 'en_GB.utf8',
  `salescattranslation` varchar(40) NOT NULL,
  PRIMARY KEY (`salescatid`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesglpostings`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `salesglpostings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area` varchar(3) NOT NULL,
  `stkcat` varchar(6) NOT NULL DEFAULT '',
  `discountglcode` varchar(20) NOT NULL DEFAULT '0',
  `salesglcode` varchar(20) NOT NULL DEFAULT '0',
  `salestype` char(2) NOT NULL DEFAULT 'AN',
  PRIMARY KEY (`id`),
  UNIQUE KEY `Area_StkCat` (`area`,`stkcat`,`salestype`),
  KEY `Area` (`area`),
  KEY `StkCat` (`stkcat`),
  KEY `SalesType` (`salestype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesman`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `salesman` (
  `salesmancode` varchar(4) NOT NULL DEFAULT '',
  `salesmanname` char(30) NOT NULL DEFAULT '',
  `smantel` char(20) NOT NULL DEFAULT '',
  `smanfax` char(20) NOT NULL DEFAULT '',
  `commissionrate1` double NOT NULL DEFAULT '0',
  `breakpoint` decimal(10,0) NOT NULL DEFAULT '0',
  `commissionrate2` double NOT NULL DEFAULT '0',
  `current` tinyint(4) NOT NULL COMMENT 'Salesman current (1) or not (0)',
  PRIMARY KEY (`salesmancode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesorderdetails`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `salesorderdetails` (
  `orderlineno` int(11) NOT NULL DEFAULT '0',
  `orderno` int(11) NOT NULL DEFAULT '0',
  `stkcode` varchar(20) NOT NULL DEFAULT '',
  `qtyinvoiced` double NOT NULL DEFAULT '0',
  `unitprice` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `estimate` tinyint(4) NOT NULL DEFAULT '0',
  `discountpercent` double NOT NULL DEFAULT '0',
  `actualdispatchdate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `narrative` text,
  `itemdue` date DEFAULT NULL COMMENT 'Due date for line item.  Some customers require \r\nacknowledgements with due dates by line item',
  `poline` varchar(10) DEFAULT NULL COMMENT 'Some Customers require acknowledgements with a PO line number for each sales line',
  PRIMARY KEY (`orderlineno`,`orderno`),
  KEY `OrderNo` (`orderno`),
  KEY `StkCode` (`stkcode`),
  KEY `Completed` (`completed`),
  CONSTRAINT `salesorderdetails_ibfk_1` FOREIGN KEY (`orderno`) REFERENCES `salesorders` (`orderno`),
  CONSTRAINT `salesorderdetails_ibfk_2` FOREIGN KEY (`stkcode`) REFERENCES `stockmaster` (`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesorders`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `salesorders` (
  `orderno` int(11) NOT NULL,
  `debtorno` varchar(10) NOT NULL DEFAULT '',
  `branchcode` varchar(10) NOT NULL DEFAULT '',
  `customerref` varchar(50) NOT NULL DEFAULT '',
  `buyername` varchar(50) DEFAULT NULL,
  `comments` longblob,
  `orddate` date NOT NULL DEFAULT '1000-01-01',
  `ordertype` char(2) NOT NULL DEFAULT '',
  `shipvia` int(11) NOT NULL DEFAULT '0',
  `deladd1` varchar(40) NOT NULL DEFAULT '',
  `deladd2` varchar(40) NOT NULL DEFAULT '',
  `deladd3` varchar(40) NOT NULL DEFAULT '',
  `deladd4` varchar(40) DEFAULT NULL,
  `deladd5` varchar(20) NOT NULL DEFAULT '',
  `deladd6` varchar(15) NOT NULL DEFAULT '',
  `contactphone` varchar(25) DEFAULT NULL,
  `contactemail` varchar(40) DEFAULT NULL,
  `deliverto` varchar(40) NOT NULL DEFAULT '',
  `deliverblind` tinyint(1) DEFAULT '1',
  `freightcost` double NOT NULL DEFAULT '0',
  `fromstkloc` varchar(5) NOT NULL DEFAULT '',
  `deliverydate` date NOT NULL DEFAULT '1000-01-01',
  `confirmeddate` date NOT NULL DEFAULT '1000-01-01',
  `printedpackingslip` tinyint(4) NOT NULL DEFAULT '0',
  `datepackingslipprinted` date NOT NULL DEFAULT '1000-01-01',
  `quotation` tinyint(4) NOT NULL DEFAULT '0',
  `quotedate` date NOT NULL DEFAULT '1000-01-01',
  `poplaced` tinyint(4) NOT NULL DEFAULT '0',
  `salesperson` varchar(4) NOT NULL,
  `internalcomment` blob,
  PRIMARY KEY (`orderno`),
  KEY `DebtorNo` (`debtorno`),
  KEY `OrdDate` (`orddate`),
  KEY `OrderType` (`ordertype`),
  KEY `LocationIndex` (`fromstkloc`),
  KEY `BranchCode` (`branchcode`,`debtorno`),
  KEY `ShipVia` (`shipvia`),
  KEY `quotation` (`quotation`),
  KEY `poplaced` (`poplaced`),
  KEY `salesperson` (`salesperson`),
  CONSTRAINT `salesorders_ibfk_1` FOREIGN KEY (`branchcode`, `debtorno`) REFERENCES `custbranch` (`branchcode`, `debtorno`),
  CONSTRAINT `salesorders_ibfk_2` FOREIGN KEY (`shipvia`) REFERENCES `shippers` (`shipper_id`),
  CONSTRAINT `salesorders_ibfk_3` FOREIGN KEY (`fromstkloc`) REFERENCES `locations` (`loccode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salestypes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `salestypes` (
  `typeabbrev` char(2) NOT NULL DEFAULT '',
  `sales_type` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`typeabbrev`),
  KEY `Sales_Type` (`sales_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sampleresults`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sampleresults` (
  `resultid` bigint(20) NOT NULL AUTO_INCREMENT,
  `sampleid` int(11) NOT NULL,
  `testid` int(11) NOT NULL,
  `defaultvalue` varchar(150) NOT NULL,
  `targetvalue` varchar(30) NOT NULL,
  `rangemin` float DEFAULT NULL,
  `rangemax` float DEFAULT NULL,
  `testvalue` varchar(30) NOT NULL DEFAULT '',
  `testdate` date NOT NULL DEFAULT '1000-01-01',
  `testedby` varchar(15) NOT NULL DEFAULT '',
  `comments` varchar(255) NOT NULL DEFAULT '',
  `isinspec` tinyint(4) NOT NULL DEFAULT '0',
  `showoncert` tinyint(4) NOT NULL DEFAULT '1',
  `showontestplan` tinyint(4) NOT NULL DEFAULT '1',
  `manuallyadded` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`resultid`),
  KEY `sampleid` (`sampleid`),
  KEY `testid` (`testid`),
  CONSTRAINT `sampleresults_ibfk_1` FOREIGN KEY (`testid`) REFERENCES `qatests` (`testid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `scripts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `scripts` (
  `script` varchar(78) NOT NULL DEFAULT '',
  `pagesecurity` int(11) NOT NULL DEFAULT '1',
  `description` text NOT NULL,
  PRIMARY KEY (`script`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `securitygroups`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `securitygroups` (
  `secroleid` int(11) NOT NULL DEFAULT '0',
  `tokenid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`secroleid`,`tokenid`),
  KEY `secroleid` (`secroleid`),
  KEY `tokenid` (`tokenid`),
  CONSTRAINT `securitygroups_secroleid_fk` FOREIGN KEY (`secroleid`) REFERENCES `securityroles` (`secroleid`),
  CONSTRAINT `securitygroups_tokenid_fk` FOREIGN KEY (`tokenid`) REFERENCES `securitytokens` (`tokenid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `securityroles`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `securityroles` (
  `secroleid` int(11) NOT NULL AUTO_INCREMENT,
  `secrolename` text NOT NULL,
  PRIMARY KEY (`secroleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `securitytokens`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `securitytokens` (
  `tokenid` int(11) NOT NULL DEFAULT '0',
  `tokenname` text NOT NULL,
  PRIMARY KEY (`tokenid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sellthroughsupport`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sellthroughsupport` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplierno` varchar(10) NOT NULL,
  `debtorno` varchar(10) NOT NULL DEFAULT '',
  `categoryid` char(6) NOT NULL DEFAULT '',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `narrative` varchar(20) NOT NULL DEFAULT '',
  `rebatepercent` double NOT NULL DEFAULT '0',
  `rebateamount` double NOT NULL DEFAULT '0',
  `effectivefrom` date NOT NULL,
  `effectiveto` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplierno` (`supplierno`),
  KEY `debtorno` (`debtorno`),
  KEY `effectivefrom` (`effectivefrom`),
  KEY `effectiveto` (`effectiveto`),
  KEY `stockid` (`stockid`),
  KEY `categoryid` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shipmentcharges`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipmentcharges` (
  `shiptchgid` int(11) NOT NULL AUTO_INCREMENT,
  `shiptref` int(11) NOT NULL DEFAULT '0',
  `transtype` smallint(6) NOT NULL DEFAULT '0',
  `transno` int(11) NOT NULL DEFAULT '0',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `value` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`shiptchgid`),
  KEY `TransType` (`transtype`,`transno`),
  KEY `ShiptRef` (`shiptref`),
  KEY `StockID` (`stockid`),
  KEY `TransType_2` (`transtype`),
  CONSTRAINT `shipmentcharges_ibfk_1` FOREIGN KEY (`shiptref`) REFERENCES `shipments` (`shiptref`),
  CONSTRAINT `shipmentcharges_ibfk_2` FOREIGN KEY (`transtype`) REFERENCES `systypes` (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shipments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipments` (
  `shiptref` int(11) NOT NULL DEFAULT '0',
  `voyageref` varchar(20) NOT NULL DEFAULT '0',
  `vessel` varchar(50) NOT NULL DEFAULT '',
  `eta` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `accumvalue` double NOT NULL DEFAULT '0',
  `supplierid` varchar(10) NOT NULL DEFAULT '',
  `closed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`shiptref`),
  KEY `ETA` (`eta`),
  KEY `SupplierID` (`supplierid`),
  KEY `ShipperRef` (`voyageref`),
  KEY `Vessel` (`vessel`),
  CONSTRAINT `shipments_ibfk_1` FOREIGN KEY (`supplierid`) REFERENCES `suppliers` (`supplierid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shippers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shippername` char(40) NOT NULL DEFAULT '',
  `mincharge` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`shipper_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockcategory`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockcategory` (
  `categoryid` char(6) NOT NULL DEFAULT '',
  `categorydescription` char(20) NOT NULL DEFAULT '',
  `stocktype` char(1) NOT NULL DEFAULT 'F',
  `stockact` varchar(20) NOT NULL DEFAULT '0',
  `adjglact` varchar(20) NOT NULL DEFAULT '0',
  `issueglact` varchar(20) NOT NULL DEFAULT '0',
  `purchpricevaract` varchar(20) NOT NULL DEFAULT '80000',
  `materialuseagevarac` varchar(20) NOT NULL DEFAULT '80000',
  `wipact` varchar(20) NOT NULL DEFAULT '0',
  `defaulttaxcatid` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`categoryid`),
  KEY `CategoryDescription` (`categorydescription`),
  KEY `StockType` (`stocktype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockcatproperties`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockcatproperties` (
  `stkcatpropid` int(11) NOT NULL AUTO_INCREMENT,
  `categoryid` char(6) NOT NULL,
  `label` text NOT NULL,
  `controltype` tinyint(4) NOT NULL DEFAULT '0',
  `defaultvalue` varchar(100) NOT NULL DEFAULT '''''',
  `maximumvalue` double NOT NULL DEFAULT '999999999',
  `reqatsalesorder` tinyint(4) NOT NULL DEFAULT '0',
  `minimumvalue` double NOT NULL DEFAULT '-999999999',
  `numericvalue` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stkcatpropid`),
  KEY `categoryid` (`categoryid`),
  CONSTRAINT `stockcatproperties_ibfk_1` FOREIGN KEY (`categoryid`) REFERENCES `stockcategory` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockcheckfreeze`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockcheckfreeze` (
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `loccode` varchar(5) NOT NULL DEFAULT '',
  `qoh` double NOT NULL DEFAULT '0',
  `stockcheckdate` date NOT NULL DEFAULT '1000-01-01',
  PRIMARY KEY (`stockid`,`loccode`),
  KEY `LocCode` (`loccode`),
  CONSTRAINT `stockcheckfreeze_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `stockcheckfreeze_ibfk_2` FOREIGN KEY (`loccode`) REFERENCES `locations` (`loccode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockcounts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockcounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `loccode` varchar(5) NOT NULL DEFAULT '',
  `qtycounted` double NOT NULL DEFAULT '0',
  `reference` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `StockID` (`stockid`),
  KEY `LocCode` (`loccode`),
  CONSTRAINT `stockcounts_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `stockcounts_ibfk_2` FOREIGN KEY (`loccode`) REFERENCES `locations` (`loccode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockdescriptiontranslations`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockdescriptiontranslations` (
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `language_id` varchar(10) NOT NULL DEFAULT 'en_GB.utf8',
  `descriptiontranslation` varchar(50) DEFAULT NULL COMMENT 'Item''s short description',
  `longdescriptiontranslation` text COMMENT 'Item''s long description',
  `needsrevision` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stockid`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockitemproperties`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockitemproperties` (
  `stockid` varchar(20) NOT NULL,
  `stkcatpropid` int(11) NOT NULL,
  `value` varchar(50) NOT NULL,
  PRIMARY KEY (`stockid`,`stkcatpropid`),
  KEY `stockid` (`stockid`),
  KEY `value` (`value`),
  KEY `stkcatpropid` (`stkcatpropid`),
  CONSTRAINT `stockitemproperties_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `stockitemproperties_ibfk_2` FOREIGN KEY (`stkcatpropid`) REFERENCES `stockcatproperties` (`stkcatpropid`),
  CONSTRAINT `stockitemproperties_ibfk_3` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `stockitemproperties_ibfk_4` FOREIGN KEY (`stkcatpropid`) REFERENCES `stockcatproperties` (`stkcatpropid`),
  CONSTRAINT `stockitemproperties_ibfk_5` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `stockitemproperties_ibfk_6` FOREIGN KEY (`stkcatpropid`) REFERENCES `stockcatproperties` (`stkcatpropid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockmaster`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockmaster` (
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `categoryid` varchar(6) NOT NULL DEFAULT '',
  `description` varchar(50) NOT NULL DEFAULT '',
  `longdescription` text NOT NULL,
  `units` varchar(20) NOT NULL DEFAULT 'each',
  `mbflag` char(1) NOT NULL DEFAULT 'B',
  `actualcost` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `lastcost` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `materialcost` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `labourcost` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `overheadcost` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `lowestlevel` smallint(6) NOT NULL DEFAULT '0',
  `discontinued` tinyint(4) NOT NULL DEFAULT '0',
  `controlled` tinyint(4) NOT NULL DEFAULT '0',
  `eoq` double NOT NULL DEFAULT '0',
  `volume` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `grossweight` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `barcode` varchar(50) NOT NULL DEFAULT '',
  `discountcategory` char(2) NOT NULL DEFAULT '',
  `taxcatid` tinyint(4) NOT NULL DEFAULT '1',
  `serialised` tinyint(4) NOT NULL DEFAULT '0',
  `perishable` tinyint(1) NOT NULL DEFAULT '0',
  `decimalplaces` tinyint(4) NOT NULL DEFAULT '0',
  `pansize` double NOT NULL DEFAULT '0',
  `shrinkfactor` double NOT NULL DEFAULT '0',
  `nextserialno` bigint(20) NOT NULL DEFAULT '0',
  `netweight` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `lastcostupdate` date NOT NULL DEFAULT '1000-01-01',
  PRIMARY KEY (`stockid`),
  KEY `CategoryID` (`categoryid`),
  KEY `Description` (`description`),
  KEY `MBflag` (`mbflag`),
  KEY `StockID` (`stockid`,`categoryid`),
  KEY `Controlled` (`controlled`),
  KEY `DiscountCategory` (`discountcategory`),
  KEY `taxcatid` (`taxcatid`),
  CONSTRAINT `stockmaster_ibfk_1` FOREIGN KEY (`categoryid`) REFERENCES `stockcategory` (`categoryid`),
  CONSTRAINT `stockmaster_ibfk_2` FOREIGN KEY (`taxcatid`) REFERENCES `taxcategories` (`taxcatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockmoves`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockmoves` (
  `stkmoveno` int(11) NOT NULL AUTO_INCREMENT,
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `transno` int(11) NOT NULL DEFAULT '0',
  `loccode` varchar(5) NOT NULL DEFAULT '',
  `trandate` date NOT NULL DEFAULT '1000-01-01',
  `userid` varchar(20) NOT NULL,
  `debtorno` varchar(10) NOT NULL DEFAULT '',
  `branchcode` varchar(10) NOT NULL DEFAULT '',
  `price` decimal(21,5) NOT NULL DEFAULT '0.00000',
  `prd` smallint(6) NOT NULL DEFAULT '0',
  `reference` varchar(100) NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '1',
  `discountpercent` double NOT NULL DEFAULT '0',
  `standardcost` double NOT NULL DEFAULT '0',
  `show_on_inv_crds` tinyint(4) NOT NULL DEFAULT '1',
  `newqoh` double NOT NULL DEFAULT '0',
  `hidemovt` tinyint(4) NOT NULL DEFAULT '0',
  `narrative` text,
  PRIMARY KEY (`stkmoveno`),
  KEY `DebtorNo` (`debtorno`),
  KEY `LocCode` (`loccode`),
  KEY `Prd` (`prd`),
  KEY `StockID_2` (`stockid`),
  KEY `TranDate` (`trandate`),
  KEY `TransNo` (`transno`),
  KEY `Type` (`type`),
  KEY `Show_On_Inv_Crds` (`show_on_inv_crds`),
  KEY `Hide` (`hidemovt`),
  KEY `reference` (`reference`),
  CONSTRAINT `stockmoves_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `stockmoves_ibfk_2` FOREIGN KEY (`type`) REFERENCES `systypes` (`typeid`),
  CONSTRAINT `stockmoves_ibfk_3` FOREIGN KEY (`loccode`) REFERENCES `locations` (`loccode`),
  CONSTRAINT `stockmoves_ibfk_4` FOREIGN KEY (`prd`) REFERENCES `periods` (`periodno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockmovestaxes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockmovestaxes` (
  `stkmoveno` int(11) NOT NULL DEFAULT '0',
  `taxauthid` tinyint(4) NOT NULL DEFAULT '0',
  `taxrate` double NOT NULL DEFAULT '0',
  `taxontax` tinyint(4) NOT NULL DEFAULT '0',
  `taxcalculationorder` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stkmoveno`,`taxauthid`),
  KEY `taxauthid` (`taxauthid`),
  KEY `calculationorder` (`taxcalculationorder`),
  CONSTRAINT `stockmovestaxes_ibfk_1` FOREIGN KEY (`taxauthid`) REFERENCES `taxauthorities` (`taxid`),
  CONSTRAINT `stockmovestaxes_ibfk_2` FOREIGN KEY (`stkmoveno`) REFERENCES `stockmoves` (`stkmoveno`),
  CONSTRAINT `stockmovestaxes_ibfk_3` FOREIGN KEY (`stkmoveno`) REFERENCES `stockmoves` (`stkmoveno`),
  CONSTRAINT `stockmovestaxes_ibfk_4` FOREIGN KEY (`stkmoveno`) REFERENCES `stockmoves` (`stkmoveno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockrequest`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockrequest` (
  `dispatchid` int(11) NOT NULL AUTO_INCREMENT,
  `loccode` varchar(5) NOT NULL DEFAULT '',
  `departmentid` int(11) NOT NULL DEFAULT '0',
  `despatchdate` date NOT NULL DEFAULT '1000-01-01',
  `authorised` tinyint(4) NOT NULL DEFAULT '0',
  `closed` tinyint(4) NOT NULL DEFAULT '0',
  `narrative` text NOT NULL,
  `initiator` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`dispatchid`),
  KEY `loccode` (`loccode`),
  KEY `departmentid` (`departmentid`),
  CONSTRAINT `stockrequest_ibfk_1` FOREIGN KEY (`loccode`) REFERENCES `locations` (`loccode`),
  CONSTRAINT `stockrequest_ibfk_2` FOREIGN KEY (`departmentid`) REFERENCES `departments` (`departmentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockrequestitems`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockrequestitems` (
  `dispatchitemsid` int(11) NOT NULL DEFAULT '0',
  `dispatchid` int(11) NOT NULL DEFAULT '0',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '0',
  `qtydelivered` double NOT NULL DEFAULT '0',
  `decimalplaces` int(11) NOT NULL DEFAULT '0',
  `uom` varchar(20) NOT NULL DEFAULT '',
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`dispatchitemsid`,`dispatchid`),
  KEY `dispatchid` (`dispatchid`),
  KEY `stockid` (`stockid`),
  CONSTRAINT `stockrequestitems_ibfk_1` FOREIGN KEY (`dispatchid`) REFERENCES `stockrequest` (`dispatchid`),
  CONSTRAINT `stockrequestitems_ibfk_2` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `stockrequestitems_ibfk_3` FOREIGN KEY (`dispatchid`) REFERENCES `stockrequest` (`dispatchid`),
  CONSTRAINT `stockrequestitems_ibfk_4` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockserialitems`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockserialitems` (
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `loccode` varchar(5) NOT NULL DEFAULT '',
  `serialno` varchar(30) NOT NULL DEFAULT '',
  `expirationdate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `quantity` double NOT NULL DEFAULT '0',
  `qualitytext` text NOT NULL,
  `createdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`stockid`,`serialno`,`loccode`),
  KEY `StockID` (`stockid`),
  KEY `LocCode` (`loccode`),
  KEY `serialno` (`serialno`),
  KEY `createdate` (`createdate`),
  CONSTRAINT `stockserialitems_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `stockserialitems_ibfk_2` FOREIGN KEY (`loccode`) REFERENCES `locations` (`loccode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stockserialmoves`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stockserialmoves` (
  `stkitmmoveno` int(11) NOT NULL AUTO_INCREMENT,
  `stockmoveno` int(11) NOT NULL DEFAULT '0',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `serialno` varchar(30) NOT NULL DEFAULT '',
  `moveqty` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`stkitmmoveno`),
  KEY `StockMoveNo` (`stockmoveno`),
  KEY `StockID_SN` (`stockid`,`serialno`),
  KEY `serialno` (`serialno`),
  CONSTRAINT `stockserialmoves_ibfk_1` FOREIGN KEY (`stockmoveno`) REFERENCES `stockmoves` (`stkmoveno`),
  CONSTRAINT `stockserialmoves_ibfk_2` FOREIGN KEY (`stockid`, `serialno`) REFERENCES `stockserialitems` (`stockid`, `serialno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `suppallocs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `suppallocs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amt` double NOT NULL DEFAULT '0',
  `datealloc` date NOT NULL DEFAULT '1000-01-01',
  `transid_allocfrom` int(11) NOT NULL DEFAULT '0',
  `transid_allocto` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `TransID_AllocFrom` (`transid_allocfrom`),
  KEY `TransID_AllocTo` (`transid_allocto`),
  KEY `DateAlloc` (`datealloc`),
  CONSTRAINT `suppallocs_ibfk_1` FOREIGN KEY (`transid_allocfrom`) REFERENCES `supptrans` (`id`),
  CONSTRAINT `suppallocs_ibfk_2` FOREIGN KEY (`transid_allocto`) REFERENCES `supptrans` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `suppinvstogrn`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `suppinvstogrn` (
  `suppinv` int(11) NOT NULL,
  `grnno` int(11) NOT NULL,
  PRIMARY KEY (`suppinv`,`grnno`),
  KEY `suppinvstogrn_ibfk_1` (`grnno`),
  CONSTRAINT `suppinvstogrn_ibfk_1` FOREIGN KEY (`grnno`) REFERENCES `grns` (`grnno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `suppliercontacts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `suppliercontacts` (
  `supplierid` varchar(10) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `tel` varchar(30) NOT NULL DEFAULT '',
  `fax` varchar(30) NOT NULL DEFAULT '',
  `mobile` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(55) NOT NULL DEFAULT '',
  `ordercontact` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`supplierid`,`contact`),
  KEY `Contact` (`contact`),
  KEY `SupplierID` (`supplierid`),
  CONSTRAINT `suppliercontacts_ibfk_1` FOREIGN KEY (`supplierid`) REFERENCES `suppliers` (`supplierid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `supplierdiscounts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supplierdiscounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplierno` varchar(10) NOT NULL,
  `stockid` varchar(20) NOT NULL,
  `discountnarrative` varchar(20) NOT NULL,
  `discountpercent` double NOT NULL,
  `discountamount` double NOT NULL,
  `effectivefrom` date NOT NULL,
  `effectiveto` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplierno` (`supplierno`),
  KEY `effectivefrom` (`effectivefrom`),
  KEY `effectiveto` (`effectiveto`),
  KEY `stockid` (`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `suppliers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `suppliers` (
  `supplierid` varchar(10) NOT NULL DEFAULT '',
  `suppname` varchar(40) NOT NULL DEFAULT '',
  `address1` varchar(40) NOT NULL DEFAULT '',
  `address2` varchar(40) NOT NULL DEFAULT '',
  `address3` varchar(40) NOT NULL DEFAULT '',
  `address4` varchar(50) NOT NULL DEFAULT '',
  `address5` varchar(20) NOT NULL DEFAULT '',
  `address6` varchar(40) NOT NULL DEFAULT '',
  `supptype` tinyint(4) NOT NULL DEFAULT '1',
  `lat` float(10,6) NOT NULL DEFAULT '0.000000',
  `lng` float(10,6) NOT NULL DEFAULT '0.000000',
  `currcode` char(3) NOT NULL DEFAULT '',
  `suppliersince` date NOT NULL DEFAULT '1000-01-01',
  `paymentterms` char(2) NOT NULL DEFAULT '',
  `lastpaid` double NOT NULL DEFAULT '0',
  `lastpaiddate` datetime DEFAULT NULL,
  `bankact` varchar(30) NOT NULL DEFAULT '',
  `bankref` varchar(12) NOT NULL DEFAULT '',
  `bankpartics` varchar(12) NOT NULL DEFAULT '',
  `remittance` tinyint(4) NOT NULL DEFAULT '1',
  `taxgroupid` tinyint(4) NOT NULL DEFAULT '1',
  `factorcompanyid` int(11) NOT NULL DEFAULT '1',
  `taxref` varchar(20) NOT NULL DEFAULT '',
  `phn` varchar(50) NOT NULL DEFAULT '',
  `port` varchar(200) NOT NULL DEFAULT '',
  `email` varchar(55) DEFAULT NULL,
  `fax` varchar(25) DEFAULT NULL,
  `telephone` varchar(25) DEFAULT NULL,
  `url` varchar(50) NOT NULL DEFAULT '',
  `defaultshipper` int(11) NOT NULL DEFAULT '0',
  `defaultgl` varchar(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`supplierid`),
  KEY `CurrCode` (`currcode`),
  KEY `PaymentTerms` (`paymentterms`),
  KEY `SuppName` (`suppname`),
  KEY `taxgroupid` (`taxgroupid`),
  CONSTRAINT `suppliers_ibfk_1` FOREIGN KEY (`currcode`) REFERENCES `currencies` (`currabrev`),
  CONSTRAINT `suppliers_ibfk_2` FOREIGN KEY (`paymentterms`) REFERENCES `paymentterms` (`termsindicator`),
  CONSTRAINT `suppliers_ibfk_3` FOREIGN KEY (`taxgroupid`) REFERENCES `taxgroups` (`taxgroupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `suppliertype`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `suppliertype` (
  `typeid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `typename` varchar(100) NOT NULL,
  PRIMARY KEY (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `supptrans`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supptrans` (
  `transno` int(11) NOT NULL DEFAULT '0',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `supplierno` varchar(10) NOT NULL DEFAULT '',
  `suppreference` varchar(20) NOT NULL DEFAULT '',
  `trandate` date NOT NULL DEFAULT '1000-01-01',
  `duedate` date NOT NULL DEFAULT '1000-01-01',
  `inputdate` datetime NOT NULL,
  `settled` tinyint(4) NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `ovamount` double NOT NULL DEFAULT '0',
  `ovgst` double NOT NULL DEFAULT '0',
  `diffonexch` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `transtext` text,
  `hold` tinyint(4) NOT NULL DEFAULT '0',
  `chequeno` varchar(16) NOT NULL DEFAULT '',
  `void` tinyint(1) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `DueDate` (`duedate`),
  KEY `Hold` (`hold`),
  KEY `SupplierNo` (`supplierno`),
  KEY `Settled` (`settled`),
  KEY `SupplierNo_2` (`supplierno`,`suppreference`),
  KEY `SuppReference` (`suppreference`),
  KEY `TranDate` (`trandate`),
  KEY `TransNo` (`transno`),
  KEY `Type` (`type`),
  KEY `TypeTransNo` (`transno`,`type`),
  CONSTRAINT `supptrans_ibfk_1` FOREIGN KEY (`type`) REFERENCES `systypes` (`typeid`),
  CONSTRAINT `supptrans_ibfk_2` FOREIGN KEY (`supplierno`) REFERENCES `suppliers` (`supplierid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `supptranstaxes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supptranstaxes` (
  `supptransid` int(11) NOT NULL DEFAULT '0',
  `taxauthid` tinyint(4) NOT NULL DEFAULT '0',
  `taxamount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`supptransid`,`taxauthid`),
  KEY `taxauthid` (`taxauthid`),
  CONSTRAINT `supptranstaxes_ibfk_1` FOREIGN KEY (`taxauthid`) REFERENCES `taxauthorities` (`taxid`),
  CONSTRAINT `supptranstaxes_ibfk_2` FOREIGN KEY (`supptransid`) REFERENCES `supptrans` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `systypes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `systypes` (
  `typeid` smallint(6) NOT NULL DEFAULT '0',
  `typename` char(50) NOT NULL DEFAULT '',
  `typeno` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`typeid`),
  KEY `TypeNo` (`typeno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tags`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tags` (
  `tagref` tinyint(4) NOT NULL AUTO_INCREMENT,
  `tagdescription` varchar(50) NOT NULL,
  PRIMARY KEY (`tagref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taxauthorities`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taxauthorities` (
  `taxid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `description` varchar(20) NOT NULL DEFAULT '',
  `taxglcode` varchar(20) NOT NULL DEFAULT '0',
  `purchtaxglaccount` varchar(20) NOT NULL DEFAULT '0',
  `bank` varchar(50) NOT NULL DEFAULT '',
  `bankacctype` varchar(20) NOT NULL DEFAULT '',
  `bankacc` varchar(50) NOT NULL DEFAULT '',
  `bankswift` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`taxid`),
  KEY `TaxGLCode` (`taxglcode`),
  KEY `PurchTaxGLAccount` (`purchtaxglaccount`),
  CONSTRAINT `taxauthorities_ibfk_1` FOREIGN KEY (`taxglcode`) REFERENCES `chartmaster` (`accountcode`),
  CONSTRAINT `taxauthorities_ibfk_2` FOREIGN KEY (`purchtaxglaccount`) REFERENCES `chartmaster` (`accountcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taxauthrates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taxauthrates` (
  `taxauthority` tinyint(4) NOT NULL DEFAULT '1',
  `dispatchtaxprovince` tinyint(4) NOT NULL DEFAULT '1',
  `taxcatid` tinyint(4) NOT NULL DEFAULT '0',
  `taxrate` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`taxauthority`,`dispatchtaxprovince`,`taxcatid`),
  KEY `TaxAuthority` (`taxauthority`),
  KEY `dispatchtaxprovince` (`dispatchtaxprovince`),
  KEY `taxcatid` (`taxcatid`),
  CONSTRAINT `taxauthrates_ibfk_1` FOREIGN KEY (`taxauthority`) REFERENCES `taxauthorities` (`taxid`),
  CONSTRAINT `taxauthrates_ibfk_2` FOREIGN KEY (`taxcatid`) REFERENCES `taxcategories` (`taxcatid`),
  CONSTRAINT `taxauthrates_ibfk_3` FOREIGN KEY (`dispatchtaxprovince`) REFERENCES `taxprovinces` (`taxprovinceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taxcategories`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taxcategories` (
  `taxcatid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `taxcatname` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`taxcatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taxgroups`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taxgroups` (
  `taxgroupid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `taxgroupdescription` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`taxgroupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taxgrouptaxes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taxgrouptaxes` (
  `taxgroupid` tinyint(4) NOT NULL DEFAULT '0',
  `taxauthid` tinyint(4) NOT NULL DEFAULT '0',
  `calculationorder` tinyint(4) NOT NULL DEFAULT '0',
  `taxontax` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`taxgroupid`,`taxauthid`),
  KEY `taxgroupid` (`taxgroupid`),
  KEY `taxauthid` (`taxauthid`),
  CONSTRAINT `taxgrouptaxes_ibfk_1` FOREIGN KEY (`taxgroupid`) REFERENCES `taxgroups` (`taxgroupid`),
  CONSTRAINT `taxgrouptaxes_ibfk_2` FOREIGN KEY (`taxauthid`) REFERENCES `taxauthorities` (`taxid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taxprovinces`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taxprovinces` (
  `taxprovinceid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `taxprovincename` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`taxprovinceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tenderitems`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tenderitems` (
  `tenderid` int(11) NOT NULL DEFAULT '0',
  `stockid` varchar(20) NOT NULL DEFAULT '',
  `quantity` varchar(40) NOT NULL DEFAULT '',
  `units` varchar(20) NOT NULL DEFAULT 'each',
  PRIMARY KEY (`tenderid`,`stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tenders`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tenders` (
  `tenderid` int(11) NOT NULL DEFAULT '0',
  `location` varchar(5) NOT NULL DEFAULT '',
  `address1` varchar(40) NOT NULL DEFAULT '',
  `address2` varchar(40) NOT NULL DEFAULT '',
  `address3` varchar(40) NOT NULL DEFAULT '',
  `address4` varchar(40) NOT NULL DEFAULT '',
  `address5` varchar(20) NOT NULL DEFAULT '',
  `address6` varchar(15) NOT NULL DEFAULT '',
  `telephone` varchar(25) NOT NULL DEFAULT '',
  `closed` int(2) NOT NULL DEFAULT '0',
  `requiredbydate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`tenderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tendersuppliers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tendersuppliers` (
  `tenderid` int(11) NOT NULL DEFAULT '0',
  `supplierid` varchar(10) NOT NULL DEFAULT '',
  `email` varchar(40) NOT NULL DEFAULT '',
  `responded` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tenderid`,`supplierid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `timesheets`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timesheets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo` int(11) NOT NULL COMMENT 'loose FK with workorders',
  `employeeid` int(11) NOT NULL,
  `weekending` date NOT NULL DEFAULT '1900-01-01',
  `workcentre` varchar(5) NOT NULL COMMENT 'loose FK with workcentres',
  `day1` double NOT NULL DEFAULT '0',
  `day2` double NOT NULL DEFAULT '0',
  `day3` double NOT NULL DEFAULT '0',
  `day4` double NOT NULL DEFAULT '0',
  `day5` double NOT NULL DEFAULT '0',
  `day6` double NOT NULL DEFAULT '0',
  `day7` double NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `workcentre` (`workcentre`),
  KEY `employees` (`employeeid`),
  KEY `wo` (`wo`),
  KEY `weekending` (`weekending`),
  CONSTRAINT `employees_ibfk_1` FOREIGN KEY (`employeeid`) REFERENCES `employees` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `unitsofmeasure`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `unitsofmeasure` (
  `unitid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `unitname` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`unitid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `woitems`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `woitems` (
  `wo` int(11) NOT NULL,
  `stockid` char(20) NOT NULL DEFAULT '',
  `qtyreqd` double NOT NULL DEFAULT '1',
  `qtyrecd` double NOT NULL DEFAULT '0',
  `stdcost` double NOT NULL,
  `nextlotsnref` varchar(20) DEFAULT '',
  `comments` longblob,
  PRIMARY KEY (`wo`,`stockid`),
  KEY `stockid` (`stockid`),
  CONSTRAINT `woitems_ibfk_1` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `woitems_ibfk_2` FOREIGN KEY (`wo`) REFERENCES `workorders` (`wo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `worequirements`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `worequirements` (
  `wo` int(11) NOT NULL,
  `parentstockid` varchar(20) NOT NULL,
  `stockid` varchar(20) NOT NULL,
  `qtypu` double NOT NULL DEFAULT '1',
  `stdcost` double NOT NULL DEFAULT '0',
  `autoissue` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`wo`,`parentstockid`,`stockid`),
  KEY `stockid` (`stockid`),
  KEY `worequirements_ibfk_3` (`parentstockid`),
  CONSTRAINT `worequirements_ibfk_1` FOREIGN KEY (`wo`) REFERENCES `workorders` (`wo`),
  CONSTRAINT `worequirements_ibfk_2` FOREIGN KEY (`stockid`) REFERENCES `stockmaster` (`stockid`),
  CONSTRAINT `worequirements_ibfk_3` FOREIGN KEY (`wo`, `parentstockid`) REFERENCES `woitems` (`wo`, `stockid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `workcentres`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `workcentres` (
  `code` char(5) NOT NULL DEFAULT '',
  `location` char(5) NOT NULL DEFAULT '',
  `description` char(20) NOT NULL DEFAULT '',
  `capacity` double NOT NULL DEFAULT '1',
  `overheadperhour` decimal(10,0) NOT NULL DEFAULT '0',
  `overheadrecoveryact` varchar(20) NOT NULL DEFAULT '0',
  `setuphrs` decimal(10,0) NOT NULL DEFAULT '0',
  PRIMARY KEY (`code`),
  KEY `Description` (`description`),
  KEY `Location` (`location`),
  CONSTRAINT `workcentres_ibfk_1` FOREIGN KEY (`location`) REFERENCES `locations` (`loccode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `workorders`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `workorders` (
  `wo` int(11) NOT NULL,
  `loccode` char(5) NOT NULL DEFAULT '',
  `requiredby` date NOT NULL DEFAULT '1000-01-01',
  `startdate` date NOT NULL DEFAULT '1000-01-01',
  `costissued` double NOT NULL DEFAULT '0',
  `closed` tinyint(4) NOT NULL DEFAULT '0',
  `closecomments` longblob,
  `reference` varchar(40) NOT NULL DEFAULT '',
  `remark` text,
  PRIMARY KEY (`wo`),
  KEY `LocCode` (`loccode`),
  KEY `StartDate` (`startdate`),
  KEY `RequiredBy` (`requiredby`),
  CONSTRAINT `worksorders_ibfk_1` FOREIGN KEY (`loccode`) REFERENCES `locations` (`loccode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `woserialnos`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `woserialnos` (
  `wo` int(11) NOT NULL,
  `stockid` varchar(20) NOT NULL,
  `serialno` varchar(30) NOT NULL,
  `quantity` double NOT NULL DEFAULT '1',
  `qualitytext` text NOT NULL,
  PRIMARY KEY (`wo`,`stockid`,`serialno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `www_users`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `www_users` (
  `userid` varchar(20) NOT NULL DEFAULT '',
  `password` text NOT NULL,
  `realname` varchar(35) NOT NULL DEFAULT '',
  `customerid` varchar(10) NOT NULL DEFAULT '',
  `supplierid` varchar(10) NOT NULL DEFAULT '',
  `salesman` char(3) NOT NULL,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(55) DEFAULT NULL,
  `defaultlocation` varchar(5) NOT NULL DEFAULT '',
  `fullaccess` int(11) NOT NULL DEFAULT '1',
  `cancreatetender` tinyint(1) NOT NULL DEFAULT '0',
  `lastvisitdate` datetime DEFAULT NULL,
  `branchcode` varchar(10) NOT NULL DEFAULT '',
  `pagesize` varchar(20) NOT NULL DEFAULT 'A4',
  `modulesallowed` varchar(25) NOT NULL,
  `showdashboard` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Display dashboard after login',
  `showpagehelp` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Turn off/on page help',
  `showfieldhelp` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Turn off/on field help',
  `blocked` tinyint(4) NOT NULL DEFAULT '0',
  `displayrecordsmax` int(11) NOT NULL DEFAULT '0',
  `theme` varchar(30) NOT NULL DEFAULT 'fresh',
  `language` varchar(10) NOT NULL DEFAULT 'en_GB.utf8',
  `pdflanguage` tinyint(1) NOT NULL DEFAULT '0',
  `department` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  KEY `CustomerID` (`customerid`),
  KEY `DefaultLocation` (`defaultlocation`),
  CONSTRAINT `www_users_ibfk_1` FOREIGN KEY (`defaultlocation`) REFERENCES `locations` (`loccode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2020-04-21 11:36:32
-- MySQL dump 10.16  Distrib 10.1.44-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: weberpdemo
-- ------------------------------------------------------
-- Server version	10.1.44-MariaDB-0ubuntu0.18.04.1
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `accountgroups`
--

INSERT INTO `accountgroups` VALUES ('Cost of Goods Sold',2,1,5000,'');
INSERT INTO `accountgroups` VALUES ('Current Assets',20,0,1000,'');
INSERT INTO `accountgroups` VALUES ('Financed',50,0,3000,'');
INSERT INTO `accountgroups` VALUES ('Fixed Assets',10,0,500,'');
INSERT INTO `accountgroups` VALUES ('Giveaways',5,1,6000,'Promotions');
INSERT INTO `accountgroups` VALUES ('Income Tax',5,1,9000,'');
INSERT INTO `accountgroups` VALUES ('Liabilities',30,0,2000,'');
INSERT INTO `accountgroups` VALUES ('Marketing Expenses',5,1,6000,'');
INSERT INTO `accountgroups` VALUES ('Operating Expenses',5,1,7000,'');
INSERT INTO `accountgroups` VALUES ('Other Revenue and Expenses',5,1,8000,'');
INSERT INTO `accountgroups` VALUES ('Outward Freight',2,1,5000,'Cost of Goods Sold');
INSERT INTO `accountgroups` VALUES ('Promotions',5,1,6000,'Marketing Expenses');
INSERT INTO `accountgroups` VALUES ('Revenue',1,1,4000,'');
INSERT INTO `accountgroups` VALUES ('Sales',1,1,10,'');

--
-- Dumping data for table `accountsection`
--

INSERT INTO `accountsection` VALUES (1,'Income');
INSERT INTO `accountsection` VALUES (2,'Cost Of Sales');
INSERT INTO `accountsection` VALUES (5,'Overheads');
INSERT INTO `accountsection` VALUES (10,'Fixed Assets');
INSERT INTO `accountsection` VALUES (15,'Inventory');
INSERT INTO `accountsection` VALUES (20,'Amounts Receivable');
INSERT INTO `accountsection` VALUES (25,'Cash');
INSERT INTO `accountsection` VALUES (30,'Amounts Payable');
INSERT INTO `accountsection` VALUES (50,'Financed By');

--
-- Dumping data for table `areas`
--

INSERT INTO `areas` VALUES ('123','Test area');
INSERT INTO `areas` VALUES ('DE','Default');
INSERT INTO `areas` VALUES ('FL','Florida');
INSERT INTO `areas` VALUES ('TR','Toronto');

--
-- Dumping data for table `assetmanager`
--


--
-- Dumping data for table `audittrail`
--


--
-- Dumping data for table `bankaccounts`
--

INSERT INTO `bankaccounts` VALUES ('1010','GBP',2,'123','GBP account','123','','');
INSERT INTO `bankaccounts` VALUES ('1030','AUD',2,'12445','Cheque Account','124455667789','123 Straight Street','');
INSERT INTO `bankaccounts` VALUES ('1040','AUD',0,'','Savings Account','','','');
INSERT INTO `bankaccounts` VALUES ('1060','USD',1,'','USD Bank Account','123','','GIFTS');

--
-- Dumping data for table `bankaccountusers`
--

INSERT INTO `bankaccountusers` VALUES ('1030','admin');
INSERT INTO `bankaccountusers` VALUES ('1010','admin');
INSERT INTO `bankaccountusers` VALUES ('1040','admin');
INSERT INTO `bankaccountusers` VALUES ('1060','admin');
INSERT INTO `bankaccountusers` VALUES ('1030','admin');
INSERT INTO `bankaccountusers` VALUES ('1010','admin');
INSERT INTO `bankaccountusers` VALUES ('1040','admin');
INSERT INTO `bankaccountusers` VALUES ('1060','admin');

--
-- Dumping data for table `banktrans`
--

INSERT INTO `banktrans` VALUES (1,12,5,'1030','',0,1,0.9953,'2013-05-10','Cash',50,'AUD','');
INSERT INTO `banktrans` VALUES (2,12,12,'1030','web shop receipt 7 3P178942ST690145V',0,1.0378,1.0378,'2013-06-08','PayPalPro web',0,'USD','');
INSERT INTO `banktrans` VALUES (3,12,13,'1030','web shop receipt 7 2E5509873Y0129234',0,1.0378,1.0378,'2013-06-08','PayPalPro web',0,'USD','');
INSERT INTO `banktrans` VALUES (4,12,14,'1040','web shop receipt 7 6CW03791GP8036526',0,1.0378,1.0378,'2013-06-08','PayPal web',0,'USD','');
INSERT INTO `banktrans` VALUES (6,12,17,'1030','web shop receipt 7 ',0,1.0378,1.0378,'2013-06-08','PayPalPro web',0,'USD','');
INSERT INTO `banktrans` VALUES (7,12,18,'1030','',0,0.959969,1.0417,'2013-06-16','Cash',85.9,'USD','');
INSERT INTO `banktrans` VALUES (8,12,19,'1030','web shop receipt 7 B254331D91384',0,1.0814,1.0814,'2013-06-23','SwipeHQ web',0,'USD','');
INSERT INTO `banktrans` VALUES (9,12,20,'1030','web shop receipt 7 B254348421937',0,1.0814,1.0814,'2013-06-23','SwipeHQ web',0,'USD','');
INSERT INTO `banktrans` VALUES (10,12,21,'1040','web shop receipt 7 ',0,1.0814,1.0814,'2013-06-23','PayPal web',0,'USD','');
INSERT INTO `banktrans` VALUES (11,12,1,'1040','web shop receipt 7 7XT5929577922053V',0,1.0814,1.0814,'2013-06-23','PayPal web',39.5722309059,'USD','');
INSERT INTO `banktrans` VALUES (12,12,1,'1030','web shop receipt 16 ',0,1.0814,1.0814,'2013-06-23','PayPalPro web',118.14262747245,'USD','');
INSERT INTO `banktrans` VALUES (13,12,2,'1030','web shop receipt 16 ',0,1.091,1.091,'2013-06-24','PayPalPro web',15.450740227125,'USD','');
INSERT INTO `banktrans` VALUES (14,12,3,'1030','web shop receipt 16 V78R4D18BB1E',0,1.091,1.091,'2013-06-24','PayFlow web',15.450740227125,'USD','');
INSERT INTO `banktrans` VALUES (15,12,4,'1030','web shop receipt 16 V18R4E55E804',0,1.091,1.091,'2013-06-24','PayFlow web',9.447024024585,'USD','');
INSERT INTO `banktrans` VALUES (16,22,9,'1030','',0,1,1.0884,'2013-11-20','Cash',-100,'AUD','');
INSERT INTO `banktrans` VALUES (17,22,10,'1030','',0,1,1,'2013-11-20','Cash',-100,'AUD','');
INSERT INTO `banktrans` VALUES (18,22,11,'1030','',0,1,1.0884,'2013-11-20','Cash',-100,'AUD','');
INSERT INTO `banktrans` VALUES (19,1,5,'1030','Test',0,0.91877986,1.0884,'2014-02-03','Cash',-105.5,'USD','');
INSERT INTO `banktrans` VALUES (20,1,6,'1060','ffd',0,1,1,'2014-02-03','Cash',-125,'USD','');
INSERT INTO `banktrans` VALUES (21,2,1,'1010','Act Transfer From 1060 - ',0,1.5199878400973,0.6579,'2014-07-05','Cash',10,'USD','');
INSERT INTO `banktrans` VALUES (22,1,7,'1060','',0,1,1,'2014-07-05','Cash',-10,'USD','');
INSERT INTO `banktrans` VALUES (23,12,5,'1030','Melbourne Counter Sale 1',0,1,1.3224,'2017-01-23','1',-17.429232,'USD','');

--
-- Dumping data for table `bom`
--

INSERT INTO `bom` VALUES ('BIGEARS12',0,'DVD-CASE','MEL','TOR','2010-08-14','2037-12-31',1,0,'',0);
INSERT INTO `bom` VALUES ('BirthdayCakeConstruc',0,'BREAD','MEL','TOR','2010-08-14','2037-12-31',1,0,'',0);
INSERT INTO `bom` VALUES ('BirthdayCakeConstruc',0,'DVD-CASE','MEL','TOR','2010-08-14','2037-12-31',1,0,'',0);
INSERT INTO `bom` VALUES ('BirthdayCakeConstruc',0,'FLOUR','MEL','TOR','2010-08-14','2037-12-31',1,0,'',0);
INSERT INTO `bom` VALUES ('BirthdayCakeConstruc',0,'SALT','MEL','TOR','2010-08-14','2037-12-31',1,0,'',0);
INSERT INTO `bom` VALUES ('BirthdayCakeConstruc',0,'YEAST','MEL','TOR','2010-08-14','2037-12-31',1,0,'',0);
INSERT INTO `bom` VALUES ('BREAD',0,'SALT','ASS','MEL','2007-06-19','2037-06-20',0.025,1,'',0);
INSERT INTO `bom` VALUES ('BREAD',0,'YEAST','ASS','MEL','2007-06-19','2037-06-20',0.1,0,'',0);
INSERT INTO `bom` VALUES ('DVD_ACTION',0,'DVD-CASE','ASS','MEL','2007-06-12','2037-06-13',4,0,'',0);
INSERT INTO `bom` VALUES ('DVD_ACTION',0,'DVD-DHWV','ASS','MEL','2007-06-12','2037-06-13',1,1,'',0);
INSERT INTO `bom` VALUES ('DVD_ACTION',0,'DVD-LTWP','ASS','MEL','2007-06-12','2037-06-13',1,1,'',0);
INSERT INTO `bom` VALUES ('DVD_ACTION',0,'DVD-UNSG','ASS','MEL','2007-06-12','2037-06-13',1,1,'',0);
INSERT INTO `bom` VALUES ('DVD_ACTION',0,'DVD-UNSG2','ASS','MEL','2007-06-12','2037-06-13',1,1,'',0);
INSERT INTO `bom` VALUES ('FUJI9901ASS',0,'FUJI990101','ASS','MEL','2005-06-04','2035-06-05',1,0,'',0);
INSERT INTO `bom` VALUES ('FUJI9901ASS',0,'FUJI990102','ASS','MEL','2005-02-12','2037-06-13',1,0,'',0);
INSERT INTO `bom` VALUES ('SELLTAPE',0,'TAPE1','ASS','AN','2013-02-08','2033-02-09',0.001,0,'',0);
INSERT INTO `bom` VALUES ('SLICE',0,'BREAD','ASS','MEL','2007-06-19','2037-06-20',0.1,1,'',0);
INSERT INTO `bom` VALUES ('TAPE2',0,'CUTTING','ASS','AN','2013-02-07','2033-02-08',0.5,0,'',0);
INSERT INTO `bom` VALUES ('TAPE2',0,'TAPE1','ASS','AN','2013-02-07','2033-02-08',0.25,1,'',0);
INSERT INTO `bom` VALUES ('Test123',0,'SALT','ASS','TOR','2013-06-21','2099-12-31',2,0,'',0);
INSERT INTO `bom` VALUES ('Test123',0,'TAPE1','ASS','TOR','2013-06-21','2099-12-31',3,0,'',0);
INSERT INTO `bom` VALUES ('Test123',0,'TAPE2','ASS','TOR','2013-06-21','2099-12-31',4,0,'',0);

--
-- Dumping data for table `chartdetails`
--

INSERT INTO `chartdetails` VALUES ('1',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',32,0,10,0,0);
INSERT INTO `chartdetails` VALUES ('1010',33,0,0,10,0);
INSERT INTO `chartdetails` VALUES ('1010',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1010',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1020',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',24,0,-283.75597206909,0,0);
INSERT INTO `chartdetails` VALUES ('1030',25,0,0,-283.75597206909,0);
INSERT INTO `chartdetails` VALUES ('1030',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',27,0,-105.50000003967,0,0);
INSERT INTO `chartdetails` VALUES ('1030',28,0,0,-105.50000003967,0);
INSERT INTO `chartdetails` VALUES ('1030',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1030',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1040',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1050',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',27,0,-125,0,0);
INSERT INTO `chartdetails` VALUES ('1060',28,0,0,-125,0);
INSERT INTO `chartdetails` VALUES ('1060',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',32,0,-10,0,0);
INSERT INTO `chartdetails` VALUES ('1060',33,0,0,-10,0);
INSERT INTO `chartdetails` VALUES ('1060',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1060',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1070',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1080',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1090',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1100',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1150',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1200',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1250',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1300',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',27,0,25,0,0);
INSERT INTO `chartdetails` VALUES ('1350',28,0,0,25,0);
INSERT INTO `chartdetails` VALUES ('1350',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1350',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1400',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1420',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1440',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',24,0,52.35,0,0);
INSERT INTO `chartdetails` VALUES ('1460',25,0,0,52.35,0);
INSERT INTO `chartdetails` VALUES ('1460',26,0,263.453,52.35,0);
INSERT INTO `chartdetails` VALUES ('1460',27,0,0,315.803,0);
INSERT INTO `chartdetails` VALUES ('1460',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1460',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1500',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1550',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1600',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1620',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1650',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1670',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1700',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1710',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1720',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1730',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1740',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1750',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1760',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1770',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1780',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1790',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1800',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1850',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('1900',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2010',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2020',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2050',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',24,0,226.17097206908997,0,0);
INSERT INTO `chartdetails` VALUES ('2100',25,0,0,226.17097206908997,0);
INSERT INTO `chartdetails` VALUES ('2100',26,0,-95.7,-57.585,0);
INSERT INTO `chartdetails` VALUES ('2100',27,0,0,-153.285,0);
INSERT INTO `chartdetails` VALUES ('2100',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2100',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',26,0,-217.91,0,0);
INSERT INTO `chartdetails` VALUES ('2150',27,0,0,-217.91,0);
INSERT INTO `chartdetails` VALUES ('2150',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',32,0,-150,0,0);
INSERT INTO `chartdetails` VALUES ('2150',33,0,0,-150,0);
INSERT INTO `chartdetails` VALUES ('2150',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2150',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2200',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2230',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2250',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2300',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',24,0,5.235,0,0);
INSERT INTO `chartdetails` VALUES ('2310',25,0,0,5.235,0);
INSERT INTO `chartdetails` VALUES ('2310',26,0,8.7,5.235,0);
INSERT INTO `chartdetails` VALUES ('2310',27,0,0,13.934999999999999,0);
INSERT INTO `chartdetails` VALUES ('2310',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2310',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2320',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2330',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2340',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2350',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2360',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2400',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2410',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2420',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2450',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2460',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2480',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2500',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2550',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2560',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2600',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2700',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2720',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2740',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2760',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2800',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('2900',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3100',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3200',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3300',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3400',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('3500',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4100',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4200',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4500',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4600',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4700',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4800',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('4900',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',26,0,4,0,0);
INSERT INTO `chartdetails` VALUES ('5000',27,0,0,4,0);
INSERT INTO `chartdetails` VALUES ('5000',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5000',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5100',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5200',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',32,0,150,0,0);
INSERT INTO `chartdetails` VALUES ('5500',33,0,0,150,0);
INSERT INTO `chartdetails` VALUES ('5500',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5500',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',27,0,100,0,0);
INSERT INTO `chartdetails` VALUES ('5600',28,0,0,100,0);
INSERT INTO `chartdetails` VALUES ('5600',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5600',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',26,0,37.457,0,0);
INSERT INTO `chartdetails` VALUES ('5700',27,0,0,37.457,0);
INSERT INTO `chartdetails` VALUES ('5700',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5700',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5800',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('5900',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6100',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6150',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6200',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6250',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6300',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6400',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6500',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6550',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6590',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',27,0,10.250000003856,0,0);
INSERT INTO `chartdetails` VALUES ('6600',28,0,0,10.250000003856,0);
INSERT INTO `chartdetails` VALUES ('6600',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6600',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6700',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6800',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('6900',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7020',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7030',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7040',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7050',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7060',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7070',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7080',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',27,0,95.250000035814,0,0);
INSERT INTO `chartdetails` VALUES ('7090',28,0,0,95.250000035814,0);
INSERT INTO `chartdetails` VALUES ('7090',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7090',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7100',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7150',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7200',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7210',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7220',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7230',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7240',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7260',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7280',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7300',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7350',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7390',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7400',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7450',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7500',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7550',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7600',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7610',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7620',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7630',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7640',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7650',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7660',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7700',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7750',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7800',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('7900',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8100',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8200',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8300',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8400',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8500',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8600',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('8900',84,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',14,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',15,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',16,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',17,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',18,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',19,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',20,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',21,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',22,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',23,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',24,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',25,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',26,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',27,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',28,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',29,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',30,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',31,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',32,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',33,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',34,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',35,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',36,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',37,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',38,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',39,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',40,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',41,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',42,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',43,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',44,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',45,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',46,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',47,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',48,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',49,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',50,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',51,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',52,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',53,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',54,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',55,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',56,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',57,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',58,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',59,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',60,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',61,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',62,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',63,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',64,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',65,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',66,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',67,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',68,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',69,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',70,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',71,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',72,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',73,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',74,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',75,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',76,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',77,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',78,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',79,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',80,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',81,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',82,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',83,0,0,0,0);
INSERT INTO `chartdetails` VALUES ('9100',84,0,0,0,0);

--
-- Dumping data for table `chartmaster`
--

INSERT INTO `chartmaster` VALUES ('1','Default Sales/Discounts','Sales',-1);
INSERT INTO `chartmaster` VALUES ('1010','Petty Cash','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1020','Cash on Hand','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1030','Cheque Accounts','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1040','Savings Accounts','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1050','Payroll Accounts','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1060','Special Accounts','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1070','Money Market Investments','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1080','Short-Term Investments (< 90 days)','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1090','Interest Receivable','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1100','Accounts Receivable','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1150','Allowance for Doubtful Accounts','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1200','Notes Receivable','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1250','Income Tax Receivable','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1300','Prepaid Expenses','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1350','Advances','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1400','Supplies Inventory','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1420','Raw Material Inventory','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1440','Work in Progress Inventory','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1460','Finished Goods Inventory','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('1500','Land','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1550','Bonds','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1600','Buildings','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1620','Accumulated Depreciation of Buildings','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1650','Equipment','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1670','Accumulated Depreciation of Equipment','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1700','Furniture & Fixtures','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1710','Accumulated Depreciation of Furniture & Fixtures','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1720','Office Equipment','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1730','Accumulated Depreciation of Office Equipment','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1740','Software','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1750','Accumulated Depreciation of Software','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1760','Vehicles','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1770','Accumulated Depreciation Vehicles','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1780','Other Depreciable Property','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1790','Accumulated Depreciation of Other Depreciable Prop','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1800','Patents','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1850','Goodwill','Fixed Assets',-1);
INSERT INTO `chartmaster` VALUES ('1900','Future Income Tax Receivable','Current Assets',-1);
INSERT INTO `chartmaster` VALUES ('2010','Bank Indedebtedness (overdraft)','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2020','Retainers or Advances on Work','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2050','Interest Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2100','Accounts Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2150','Goods Received Suspense','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2200','Short-Term Loan Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2230','Current Portion of Long-Term Debt Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2250','Income Tax Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2300','GST Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2310','GST Recoverable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2320','PST Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2330','PST Recoverable (commission)','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2340','Payroll Tax Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2350','Withholding Income Tax Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2360','Other Taxes Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2400','Employee Salaries Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2410','Management Salaries Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2420','Director / Partner Fees Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2450','Health Benefits Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2460','Pension Benefits Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2480','Employment Insurance Premiums Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2500','Land Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2550','Long-Term Bank Loan','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2560','Notes Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2600','Building & Equipment Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2700','Furnishing & Fixture Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2720','Office Equipment Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2740','Vehicle Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2760','Other Property Payable','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2800','Shareholder Loans','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('2900','Suspense','Liabilities',-1);
INSERT INTO `chartmaster` VALUES ('3100','Capital Stock','Financed',-1);
INSERT INTO `chartmaster` VALUES ('3200','Capital Surplus / Dividends','Financed',-1);
INSERT INTO `chartmaster` VALUES ('3300','Dividend Taxes Payable','Financed',-1);
INSERT INTO `chartmaster` VALUES ('3400','Dividend Taxes Refundable','Financed',-1);
INSERT INTO `chartmaster` VALUES ('3500','Retained Earnings','Financed',-1);
INSERT INTO `chartmaster` VALUES ('4100','Product / Service Sales','Revenue',-1);
INSERT INTO `chartmaster` VALUES ('4200','Sales Exchange Gains/Losses','Revenue',-1);
INSERT INTO `chartmaster` VALUES ('4500','Consulting Services','Revenue',-1);
INSERT INTO `chartmaster` VALUES ('4600','Rentals','Revenue',-1);
INSERT INTO `chartmaster` VALUES ('4700','Finance Charge Income','Revenue',-1);
INSERT INTO `chartmaster` VALUES ('4800','Sales Returns & Allowances','Revenue',-1);
INSERT INTO `chartmaster` VALUES ('4900','Sales Discounts','Revenue',-1);
INSERT INTO `chartmaster` VALUES ('5000','Cost of Sales','Cost of Goods Sold',-1);
INSERT INTO `chartmaster` VALUES ('5100','Production Expenses','Cost of Goods Sold',-1);
INSERT INTO `chartmaster` VALUES ('5200','Purchases Exchange Gains/Losses','Cost of Goods Sold',-1);
INSERT INTO `chartmaster` VALUES ('5500','Direct Labour Costs','Cost of Goods Sold',-1);
INSERT INTO `chartmaster` VALUES ('5600','Freight Charges','Outward Freight',-1);
INSERT INTO `chartmaster` VALUES ('5700','Inventory Adjustment','Cost of Goods Sold',-1);
INSERT INTO `chartmaster` VALUES ('5800','Purchase Returns & Allowances','Cost of Goods Sold',-1);
INSERT INTO `chartmaster` VALUES ('5900','Purchase Discounts','Cost of Goods Sold',-1);
INSERT INTO `chartmaster` VALUES ('6100','Advertising','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6150','Promotion','Promotions',-1);
INSERT INTO `chartmaster` VALUES ('6200','Communications','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6250','Meeting Expenses','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6300','Travelling Expenses','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6400','Delivery Expenses','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6500','Sales Salaries & Commission','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6550','Sales Salaries & Commission Deductions','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6590','Benefits','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6600','Other Selling Expenses','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6700','Permits, Licenses & License Fees','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6800','Research & Development','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('6900','Professional Services','Marketing Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7020','Support Salaries & Wages','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7030','Support Salary & Wage Deductions','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7040','Management Salaries','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7050','Management Salary deductions','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7060','Director / Partner Fees','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7070','Director / Partner Deductions','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7080','Payroll Tax','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7090','Benefits','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7100','Training & Education Expenses','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7150','Dues & Subscriptions','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7200','Accounting Fees','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7210','Audit Fees','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7220','Banking Fees','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7230','Credit Card Fees','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7240','Consulting Fees','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7260','Legal Fees','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7280','Other Professional Fees','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7300','Business Tax','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7350','Property Tax','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7390','Corporation Capital Tax','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7400','Office Rent','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7450','Equipment Rental','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7500','Office Supplies','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7550','Office Repair & Maintenance','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7600','Automotive Expenses','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7610','Communication Expenses','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7620','Insurance Expenses','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7630','Postage & Courier Expenses','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7640','Miscellaneous Expenses','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7650','Travel Expenses','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7660','Utilities','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7700','Ammortization Expenses','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7750','Depreciation Expenses','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7800','Interest Expense','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('7900','Bad Debt Expense','Operating Expenses',-1);
INSERT INTO `chartmaster` VALUES ('8100','Gain on Sale of Assets','Other Revenue and Expenses',-1);
INSERT INTO `chartmaster` VALUES ('8200','Interest Income','Other Revenue and Expenses',-1);
INSERT INTO `chartmaster` VALUES ('8300','Recovery on Bad Debt','Other Revenue and Expenses',-1);
INSERT INTO `chartmaster` VALUES ('8400','Other Revenue','Other Revenue and Expenses',-1);
INSERT INTO `chartmaster` VALUES ('8500','Loss on Sale of Assets','Other Revenue and Expenses',-1);
INSERT INTO `chartmaster` VALUES ('8600','Charitable Contributions','Other Revenue and Expenses',-1);
INSERT INTO `chartmaster` VALUES ('8900','Other Expenses','Other Revenue and Expenses',-1);
INSERT INTO `chartmaster` VALUES ('9100','Income Tax Provision','Income Tax',-1);

--
-- Dumping data for table `cogsglpostings`
--

INSERT INTO `cogsglpostings` VALUES (5,'AN','ANY','5000','AN');
INSERT INTO `cogsglpostings` VALUES (6,'123','ANY','6100','AN');

--
-- Dumping data for table `companies`
--

INSERT INTO `companies` VALUES (1,'weberpdemo','not entered yet','','123 Web Way','PO Box 123','Queen Street','Melbourne','Victoria 3043','Australia','+61 3 4567 8901','+61 3 4567 8902','weberp@weberpdemo.com','USD','1100','4900','2100','2400','2150','4200','5200','3500',1,1,1,'5600');

--
-- Dumping data for table `config`
--

INSERT INTO `config` VALUES ('AllowOrderLineItemNarrative','1');
INSERT INTO `config` VALUES ('AllowSalesOfZeroCostItems','0');
INSERT INTO `config` VALUES ('AutoAuthorisePO','1');
INSERT INTO `config` VALUES ('AutoCreateWOs','1');
INSERT INTO `config` VALUES ('AutoDebtorNo','0');
INSERT INTO `config` VALUES ('AutoIssue','1');
INSERT INTO `config` VALUES ('AutoSupplierNo','0');
INSERT INTO `config` VALUES ('CheckCreditLimits','1');
INSERT INTO `config` VALUES ('Check_Price_Charged_vs_Order_Price','1');
INSERT INTO `config` VALUES ('Check_Qty_Charged_vs_Del_Qty','1');
INSERT INTO `config` VALUES ('CountryOfOperation','US');
INSERT INTO `config` VALUES ('CreditingControlledItems_MustExist','0');
INSERT INTO `config` VALUES ('DB_Maintenance','0');
INSERT INTO `config` VALUES ('DB_Maintenance_LastRun','2015-08-14');
INSERT INTO `config` VALUES ('DefaultBlindPackNote','1');
INSERT INTO `config` VALUES ('DefaultCreditLimit','1000');
INSERT INTO `config` VALUES ('DefaultCustomerType','1');
INSERT INTO `config` VALUES ('DefaultDateFormat','d/m/Y');
INSERT INTO `config` VALUES ('DefaultDisplayRecordsMax','50');
INSERT INTO `config` VALUES ('DefaultFactoryLocation','MEL');
INSERT INTO `config` VALUES ('DefaultPriceList','DE');
INSERT INTO `config` VALUES ('DefaultSupplierType','1');
INSERT INTO `config` VALUES ('DefaultTaxCategory','1');
INSERT INTO `config` VALUES ('Default_Shipper','1');
INSERT INTO `config` VALUES ('DefineControlledOnWOEntry','1');
INSERT INTO `config` VALUES ('DispatchCutOffTime','14');
INSERT INTO `config` VALUES ('DoFreightCalc','0');
INSERT INTO `config` VALUES ('EDIHeaderMsgId','D:01B:UN:EAN010');
INSERT INTO `config` VALUES ('EDIReference','WEBERP');
INSERT INTO `config` VALUES ('EDI_Incoming_Orders','companies/weberpdemo/EDI_Incoming_Orders');
INSERT INTO `config` VALUES ('EDI_MsgPending','companies/weberpdemo/EDI_Pending');
INSERT INTO `config` VALUES ('EDI_MsgSent','companies/weberpdemo/EDI_Sent');
INSERT INTO `config` VALUES ('ExchangeRateFeed','Google');
INSERT INTO `config` VALUES ('Extended_CustomerInfo','1');
INSERT INTO `config` VALUES ('Extended_SupplierInfo','1');
INSERT INTO `config` VALUES ('FactoryManagerEmail','manager@company.com');
INSERT INTO `config` VALUES ('FreightChargeAppliesIfLessThan','1000');
INSERT INTO `config` VALUES ('FreightTaxCategory','1');
INSERT INTO `config` VALUES ('FrequentlyOrderedItems','0');
INSERT INTO `config` VALUES ('geocode_integration','0');
INSERT INTO `config` VALUES ('GoogleTranslatorAPIKey','');
INSERT INTO `config` VALUES ('HTTPS_Only','0');
INSERT INTO `config` VALUES ('InventoryManagerEmail','test@company.com');
INSERT INTO `config` VALUES ('InvoicePortraitFormat','0');
INSERT INTO `config` VALUES ('InvoiceQuantityDefault','1');
INSERT INTO `config` VALUES ('ItemDescriptionLanguages',',fr_FR.utf8,');
INSERT INTO `config` VALUES ('LastDayOfWeek','0');
INSERT INTO `config` VALUES ('LogPath','');
INSERT INTO `config` VALUES ('LogSeverity','0');
INSERT INTO `config` VALUES ('MaxImageSize','300');
INSERT INTO `config` VALUES ('MaxSerialItemsIssued','50');
INSERT INTO `config` VALUES ('MonthsAuditTrail','1');
INSERT INTO `config` VALUES ('NumberOfMonthMustBeShown','6');
INSERT INTO `config` VALUES ('NumberOfPeriodsOfStockUsage','12');
INSERT INTO `config` VALUES ('OverChargeProportion','30');
INSERT INTO `config` VALUES ('OverReceiveProportion','20');
INSERT INTO `config` VALUES ('PackNoteFormat','1');
INSERT INTO `config` VALUES ('PageLength','48');
INSERT INTO `config` VALUES ('part_pics_dir','companies/weberpdemo/part_pics');
INSERT INTO `config` VALUES ('PastDueDays1','30');
INSERT INTO `config` VALUES ('PastDueDays2','60');
INSERT INTO `config` VALUES ('PO_AllowSameItemMultipleTimes','1');
INSERT INTO `config` VALUES ('ProhibitJournalsToControlAccounts','1');
INSERT INTO `config` VALUES ('ProhibitNegativeStock','0');
INSERT INTO `config` VALUES ('ProhibitPostingsBefore','2013-12-31');
INSERT INTO `config` VALUES ('PurchasingManagerEmail','test@company.com');
INSERT INTO `config` VALUES ('QualityCOAText','');
INSERT INTO `config` VALUES ('QualityLogSamples','0');
INSERT INTO `config` VALUES ('QualityProdSpecText','');
INSERT INTO `config` VALUES ('QuickEntries','10');
INSERT INTO `config` VALUES ('RadioBeaconFileCounter','/home/RadioBeacon/FileCounter');
INSERT INTO `config` VALUES ('RadioBeaconFTP_user_name','RadioBeacon ftp server user name');
INSERT INTO `config` VALUES ('RadioBeaconHomeDir','/home/RadioBeacon');
INSERT INTO `config` VALUES ('RadioBeaconStockLocation','BL');
INSERT INTO `config` VALUES ('RadioBraconFTP_server','192.168.2.2');
INSERT INTO `config` VALUES ('RadioBreaconFilePrefix','ORDXX');
INSERT INTO `config` VALUES ('RadionBeaconFTP_user_pass','Radio Beacon remote ftp server password');
INSERT INTO `config` VALUES ('reports_dir','companies/weberpdemo/EDI_Incoming_Orders');
INSERT INTO `config` VALUES ('RequirePickingNote','0');
INSERT INTO `config` VALUES ('RomalpaClause','Ownership will not pass to the buyer until the goods have been paid for in full.');
INSERT INTO `config` VALUES ('ShopAboutUs','This web-shop software has been developed by Logic Works Ltd for webERP. For support contact Phil Daintree by rn<a href=\\\"mailto:support@logicworks.co.nz\\\">email</a>rn');
INSERT INTO `config` VALUES ('ShopAllowBankTransfer','1');
INSERT INTO `config` VALUES ('ShopAllowCreditCards','1');
INSERT INTO `config` VALUES ('ShopAllowPayPal','1');
INSERT INTO `config` VALUES ('ShopAllowSurcharges','1');
INSERT INTO `config` VALUES ('ShopBankTransferSurcharge','0.0');
INSERT INTO `config` VALUES ('ShopBranchCode','ANGRY');
INSERT INTO `config` VALUES ('ShopContactUs','For support contact Logic Works Ltd by rn<a href=\\\"mailto:support@logicworks.co.nz\\\">email</a>');
INSERT INTO `config` VALUES ('ShopCreditCardBankAccount','1030');
INSERT INTO `config` VALUES ('ShopCreditCardGateway','SwipeHQ');
INSERT INTO `config` VALUES ('ShopCreditCardSurcharge','2.95');
INSERT INTO `config` VALUES ('ShopDebtorNo','ANGRY');
INSERT INTO `config` VALUES ('ShopFreightMethod','NoFreight');
INSERT INTO `config` VALUES ('ShopFreightPolicy','Shipping information');
INSERT INTO `config` VALUES ('ShopManagerEmail','shopmanager@yourdomain.com');
INSERT INTO `config` VALUES ('ShopMode','test');
INSERT INTO `config` VALUES ('ShopName','webERP Demo Store');
INSERT INTO `config` VALUES ('ShopPayFlowMerchant','');
INSERT INTO `config` VALUES ('ShopPayFlowPassword','');
INSERT INTO `config` VALUES ('ShopPayFlowUser','');
INSERT INTO `config` VALUES ('ShopPayFlowVendor','');
INSERT INTO `config` VALUES ('ShopPayPalBankAccount','1040');
INSERT INTO `config` VALUES ('ShopPaypalCommissionAccount','1');
INSERT INTO `config` VALUES ('ShopPayPalPassword','');
INSERT INTO `config` VALUES ('ShopPayPalProPassword','');
INSERT INTO `config` VALUES ('ShopPayPalProSignature','');
INSERT INTO `config` VALUES ('ShopPayPalProUser','');
INSERT INTO `config` VALUES ('ShopPayPalSignature','');
INSERT INTO `config` VALUES ('ShopPayPalSurcharge','3.4');
INSERT INTO `config` VALUES ('ShopPayPalUser','');
INSERT INTO `config` VALUES ('ShopPrivacyStatement','<h2>We are committed to protecting your privacy.</h2><p>We recognise that your personal information is confidential and we understand that it is important for you to know how we treat your personal information. Please read on for more information about our Privacy Policy.</p><ul><li><h2>1. What information do we collect and how do we use it?</h2><br />We use the information it collects from you for the following purposes:<ul><li>To assist us in providing you with a quality service</li><li>To respond to, and process, your request</li><li>To notify competition winners or fulfil promotional obligations</li><li>To inform you of, and provide you with, new and existing products and services offered by us from time to time </li></ul><p>Any information we collect will not be used in ways that you have not consented to.</p><p>If you send us an email, we will store your email address and the contents of the email. This information will only be used for the purpose for which you have provided it. Electronic mail submitted to us is handled and saved according to the provisions of the the relevant statues.</p><p>When we offer contests and promotions, customers who choose to enter are asked to provide personal information. This information may then be used by us to notify winners, or to fulfil promotional obligations.</p><p>We may use the information we collect to occasionally notify you about important functionality changes to our website, new and special offers we think you will find valuable. If at any stage you no longer wish to receive these notifications you may opt out by sending us an email.</p><p>We do monitor this website in order to identify user trends and to improve the site if necessary. Any of this information, such as the type of site browser your computer has, will be used only in aggregate form and your individual details will not be identified.</p></li><li><h2>2. How do we store and protect your personal information and who has access to that information?</h2><p>As required by statute, we follow strict procedures when storing and using the information you have provided.</p><p>We do not sell, trade or rent your personal information to others. We may provide aggregate statistics about our customers and website trends. However, these statistics will not have any personal information which would identify you.</p><p>Only specific employees within our company are able to access your personal data.</p><p>This policy means that we may require proof of identity before we disclose any information to you.</p></li><li><h2>3. What should I do if I want to change my details or if I donÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢t want to be contacted any more?</h2><p>At any stage you have the right to access and amend or update your personal details. If you do not want to receive any communications from us you may opt out by contacting us see <a href=\\\"index.php?Page=ContactUs\\\">the Contact Us Page</a></p></li><li><h2>4. What happens if we decide to change this Privacy Policy?</h2><p>If we change any aspect of our Privacy Policy we will post these changes on this page so that you are always aware of how we are treating your personal information.</p></li><li><h2>5. How can you contact us if you have any questions, comments or concerns about our Privacy Policy?</h2><p>We welcome any questions or comments you may have please email us via the contact details provided on our <a href=\\\"index.php?Page=ContactUs\\\">Contact Us Page</a></p></li></ul><p>Please also refer to our <a href=\\\"index.php?Page=TermsAndConditions\\\">Terms and Conditions</a> for more information.</p>');
INSERT INTO `config` VALUES ('ShopShowOnlyAvailableItems','0');
INSERT INTO `config` VALUES ('ShopShowQOHColumn','1');
INSERT INTO `config` VALUES ('ShopStockLocations','MEL,TOR');
INSERT INTO `config` VALUES ('ShopSurchargeStockID','PAYTSURCHARGE');
INSERT INTO `config` VALUES ('ShopSwipeHQAPIKey','');
INSERT INTO `config` VALUES ('ShopSwipeHQMerchantID','');
INSERT INTO `config` VALUES ('ShopTermsConditions','<p>These terms cover the use of this website. Use includes visits to our sites, purchases on our sites, participation in our database and promotions. These terms of use apply to you when you use our websites. Please read these terms carefully - if you need to refer to them again they can be accessed from the link at the bottom of any page of our websites.</p><br /><ul><li><h2>1. Content</h2><p>While we endeavour to supply accurate information on this site, errors and omissions may occur. We do not accept any liability, direct or indirect, for any loss or damage which may directly or indirectly result from any advice, opinion, information, representation or omission whether negligent or otherwise, contained on this site. You are solely responsible for the actions you take in reliance on the content on, or accessed, through this site.</p><p>We reserve the right to make changes to the content on this site at any time and without notice.</p><p>To the extent permitted by law, we make no warranties in relation to the merchantability, fitness for purpose, freedom from computer virus, accuracy or availability of this web site or any other web site.</p></li><li><h2>2. Making a contract with us</h2><p>When you place an order with us, you are making an offer to buy goods. We will send you an e-mail to confirm that we have received and accepted your order, which indicates that a contract has been made between us. We will take payment from you when we accept your order. In the unlikely event that the goods are no longer available, we will refund your payment to the account it originated from, and advise that the goods are no longer available.</p><p>An order is placed on our website via adding a product to the shopping cart and proceeding through our checkout process. The checkout process includes giving us delivery and any other relevant details for your order, entering payment information and submitting your order. The final step consists of a confirmation page with full details of your order, which you are able to print as a receipt of your order. We will also email you with confirmation of your order.</p><p>We reserve the right to refuse or cancel any orders that we believe, solely by our own judgement, to be placed for commercial purposes, e.g. any kind of reseller. We also reserve the right to refuse or cancel any orders that we believe, solely by our own judgement, to have been placed fraudulently.</p><p>We reserve the right to limit the number of an item customers can purchase in a single transaction.</p></li><li><h2>3. Payment options</h2><p>We currently accept the following credit cards:</p><ul><li>Visa</li><li>MasterCard</li><li>American Express</li></ul>You can also pay using PayPal and internet bank transfer. Surcharges may apply for payment by PayPal or credit cards.</p></li><li><h2>4. Pricing</h2><p>All prices listed are inclusive of relevant taxes.  All prices are correct when published. Please note that we reserve the right to alter prices at any time for any reason. If this should happen after you have ordered a product, we will contact you prior to processing your order. Online and in store pricing may differ.</p></li><li><h2>5. Website and Credit Card Security</h2><p>We want you to have a safe and secure shopping experience online. All payments via our sites are processed using SSL (Secure Socket Layer) protocol, whereby sensitive information is encrypted to protect your privacy.</p><p>You can help to protect your details from unauthorised access by logging out each time you finish using the site, particularly if you are doing so from a public or shared computer.</p><p>For security purposes certain transactions may require proof of identification.</p></li><li><h2>6. Delivery and Delivery Charges</h2><p>We do not deliver to Post Office boxes.</p><p>Please note that a signature is required for all deliveries. The goods become the recipientÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢s property and responsibility once they have been signed for at the time of delivery. If goods are lost or damaged in transit, please contact us within 7 business days <a href=\\\"index.php?Page=ContactUs\\\">see Contact Us page for contact details</a>. We will use this delivery information to make a claim against our courier company. We will offer you the choice of a replacement or a full refund, once we have received confirmation from our courier company that delivery was not successful.</p></li><li><h2>7. Restricted Products</h2><p>Some products on our site carry an age restriction, if a product you have selected is R16 or R18 a message will appear in the cart asking you to confirm you are an appropriate age to purchase the item(s).  Confirming this means that you are of an eligible age to purchase the selected product(s).  You are also agreeing that you are not purchasing the item on behalf of a person who is not the appropriate age.</p></li><li><h2>8. Delivery Period</h2><p>Delivery lead time for products may vary. Deliveries to rural addresses may take longer.  You will receive an email that confirms that your order has been dispatched.</p><p>To ensure successful delivery, please provide a delivery address where someone will be present during business hours to sign for the receipt of your package. You can track your order by entering the tracking number emailed to you in the dispatch email at the Courier\\\'s web-site.</p></li><li><h2>9. Disclaimer</h2><p>Our websites are intended to provide information for people shopping our products and accessing our services, including making purchases via our website and registering on our database to receive e-mails from us.</p><p>While we endeavour to supply accurate information on this site, errors and omissions may occur. We do not accept any liability, direct or indirect, for any loss or damage which may directly or indirectly result from any advice, opinion, information, representation or omission whether negligent or otherwise, contained on this site. You are solely responsible for the actions you take in reliance on the content on, or accessed, through this site.</p><p>We reserve the right to make changes to the content on this site at any time and without notice.</p><p>To the extent permitted by law, we make no warranties in relation to the merchantability, fitness for purpose, freedom from computer virus, accuracy or availability of this web site or any other web site.</p></li><li><h2>10. Links</h2><p>Please note that although this site has some hyperlinks to other third party websites, these sites have not been prepared by us are not under our control. The links are only provided as a convenience, and do not imply that we endorse, check, or approve of the third party site. We are not responsible for the privacy principles or content of these third party sites. We are not responsible for the availability of any of these links.</p></li><li><h2>11. Jurisdiction</h2><p>This website is governed by, and is to be interpreted in accordance with, the laws of  ????.</p></li><li><h2>12. Changes to this Agreement</h2><p>We reserve the right to alter, modify or update these terms of use. These terms apply to your order. We may change our terms and conditions at any time, so please do not assume that the same terms will apply to future orders.</p></li></ul>');
INSERT INTO `config` VALUES ('ShopTitle','Shop Home');
INSERT INTO `config` VALUES ('ShortcutMenu','0');
INSERT INTO `config` VALUES ('ShowStockidOnImages','0');
INSERT INTO `config` VALUES ('ShowValueOnGRN','1');
INSERT INTO `config` VALUES ('Show_Settled_LastMonth','1');
INSERT INTO `config` VALUES ('SmtpSetting','0');
INSERT INTO `config` VALUES ('SO_AllowSameItemMultipleTimes','1');
INSERT INTO `config` VALUES ('StandardCostDecimalPlaces','2');
INSERT INTO `config` VALUES ('TaxAuthorityReferenceName','');
INSERT INTO `config` VALUES ('UpdateCurrencyRatesDaily','0');
INSERT INTO `config` VALUES ('VersionNumber','4.15.1');
INSERT INTO `config` VALUES ('WeightedAverageCosting','0');
INSERT INTO `config` VALUES ('WikiApp','DokuWiki');
INSERT INTO `config` VALUES ('WikiPath','wiki');
INSERT INTO `config` VALUES ('WorkingDaysWeek','5');
INSERT INTO `config` VALUES ('YearEnd','3');

--
-- Dumping data for table `contractbom`
--

INSERT INTO `contractbom` VALUES ('Test123','SALT','ASS',2);
INSERT INTO `contractbom` VALUES ('Test123','TAPE1','ASS',3);
INSERT INTO `contractbom` VALUES ('Test123','TAPE2','ASS',4);

--
-- Dumping data for table `contractcharges`
--


--
-- Dumping data for table `contractreqts`
--

INSERT INTO `contractreqts` VALUES (3,'Test123','Other stuff',2,5.95);
INSERT INTO `contractreqts` VALUES (4,'Test123','And that thing too',4,85);

--
-- Dumping data for table `contracts`
--

INSERT INTO `contracts` VALUES ('Test123','Testing manufact tape','14','14','TOR',2,'TAPE',40,'dsssa',50,32,'2013-07-21','',1);

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` VALUES ('Australian Dollars','AUD','Australia','cents',2,0,0);
INSERT INTO `currencies` VALUES ('Swiss Francs','CHF','Swizerland','centimes',2,0,0);
INSERT INTO `currencies` VALUES ('Euro','EUR','Euroland','cents',2,0,1);
INSERT INTO `currencies` VALUES ('Pounds','GBP','England','Pence',2,0,0);
INSERT INTO `currencies` VALUES ('Kenyian Shillings','KES','Kenya','none',0,0,0);
INSERT INTO `currencies` VALUES ('US Dollars','USD','United States','Cents',2,1,1);

--
-- Dumping data for table `custallocns`
--

INSERT INTO `custallocns` VALUES (1,109.2500,'2013-06-25',30,34);
INSERT INTO `custallocns` VALUES (2,13.1800,'2017-01-23',36,37);

--
-- Dumping data for table `custbranch`
--

INSERT INTO `custbranch` VALUES ('11','11','Angus Routledge &amp; Co','123 Alexander Road','Roundhay','Leeds','3200','','United Kingdom',0.00000000,0.00000000,1,'TR','ERI',0,'454422111','','Angus McDougall','angus@angry.com','TOR',2,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('12','12','Angus Routledge &amp; Co','123 Alexander Road','Roundhay','Leeds','3211','','United Kingdom',0.00000000,0.00000000,1,'TR','ERI',0,'212234566','','Angus McDougall','angus@angry.com','TOR',2,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('13','13','Angus Routledge &amp; Co','123 Alexander Road','Roundhay','Leeds','LE189','','United Kingdom',0.00000000,0.00000000,1,'TR','ERI',0,'0291882001','','Angus McDougall','angus@angry.com','TOR',2,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('14','14','Angus Routledge &amp; Co','123 Alexander Road','Roundhay','Leeds','2113','','United Kingdom',0.00000000,0.00000000,1,'TR','ERI',0,'12323434355566778899','','Angus McDougall','angus@angry.com','TOR',2,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('16','16','Logic Works Ltd','34 Marram Way','Peka Peka','RD1 Waiakane','Kapiti','5134','New Zealand',0.00000000,0.00000000,1,'TR','ERI',0,'64275567890','','Phil Daintree','phil@logicworks.co.nz','TOR',2,1,1,0,'34 Marram Way','Peka Peka','RD1 Waiakane','Kapiti','5134','New Zealand','','');
INSERT INTO `custbranch` VALUES ('8','8','Angus Routledge &amp; Co','123 Alexander Road','Roundhay','Leeds','43990','','United Kingdom',0.00000000,0.00000000,1,'TR','ERI',0,'124544665','','Angus McDougall','angus@angry.com','TOR',2,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('ANGRY','ANGRY','Angus Rouledge - Toronto','P O Box 671','Gowerbridge','Upperton','Toronto ','Canada','United States',0.00000000,0.00000000,3,'TR','ERI',0,'0422 2245 2213','0422 2245 2215','Granville Thomas','graville@angry.com','TOR',2,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('ANGRYFL','ANGRY','Angus Rouledge - Florida','1821 Sunnyside','Ft Lauderdale','Florida','42554','','United States',0.00000000,0.00000000,3,'FL','PHO',0,'2445 2232 524','2445 2232 522','Wendy Blowers','wendy@angry.com','TOR',1,1,1,0,'','','','','','','Watch out can bite!','');
INSERT INTO `custbranch` VALUES ('DUMBLE','DUMBLE','Dumbledoor McGonagal & Co','Hogwarts castle','Platform 9.75','','','','',0.00000000,0.00000000,1,'TR','ERI',0,'Owls only','Owls only','Minerva McGonagal','mmgonagal@hogwarts.edu.uk','TOR',3,10,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('JOLOMU','JOLOMU','Lorrima Productions Inc','3215 Great Western Highway','Blubberhouses','Yorkshire','England','','',0.00000000,0.00000000,20,'FL','PHO',0,'+44 812 211456','+44 812 211 554','Jo Lomu','jolomu@lorrima.co.uk','TOR',3,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('KES','KES','Ken Estoban','','','','','','',0.00000000,0.00000000,0,'DE','DE',0,'','','','','MEL',1,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('NEWTEST','NEWTEST','New Customer','','','','','','United States',0.00000000,0.00000000,0,'123','DE',0,'','','','','AN',1,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('QUARTER','QUARTER','Quarter Back to Back','1356 Union Drive','Holborn','England','','','',0.00000000,0.00000000,5,'FL','ERI',0,'123456','1234567','','','TOR',3,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('QUIC','QUICK','Quick Brown PLC','Fox Street','Jumped Over','The Lazy Dog','','','',0.00000000,0.00000000,1,'FL','ERI',0,'','','','','TOR',1,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('SLOW','QUICK','Slow Dog','Hunstman Road','Woofton','','','','',0.00000000,0.00000000,1,'TR','ERI',0,'','','Staffordshire Terrier','','TOR',2,1,1,0,'','','','','','','','');
INSERT INTO `custbranch` VALUES ('WEB0000017','WEB0000017','Phil Daintree','8 James Nairn Grove','','','Upper Hutt','5018','New Zealand',0.00000000,0.00000000,1,'TR','ERI',0,'+64(0)275567890','','Phil Daintree','phil@logicworks.co.nz','TOR',2,1,1,0,'8 James Nairn Grove','','','Upper Hutt','5018','New Zealand','','');
INSERT INTO `custbranch` VALUES ('WEB0000018','WEB0000018','Logic Works Ltd','34 Marram Way','Peka Peka, RD1 Waikanae','','Kapiti','5134','New Zealand',0.00000000,0.00000000,1,'TR','ERI',0,'04 528 9514','','Phil Daintree','phil@logicworks.co.nz','TOR',2,1,1,0,'34 Marram Way','Peka Peka, RD1 Waikanae','','Kapiti','5134','New Zealand','','');
INSERT INTO `custbranch` VALUES ('WEB0000019','WEB0000019','Logic Works Ltd','8 James Nairn Grove','James Nairn Grove','Riverstone Terraces','Upper Hutt','5018','New Zealand',0.00000000,0.00000000,1,'TR','ERI',0,'+6445289514','','Phil Daintree','phil@logicworks.co.nz','TOR',2,1,1,0,'8 James Nairn Grove','James Nairn Grove','Riverstone Terraces','Upper Hutt','5018','New Zealand','','');
INSERT INTO `custbranch` VALUES ('WEB0000020','WEB0000020','Logic Works Ltd','34 Marram Way','Extra Street address','Peka Peka','Waikanae','5134','New Zealand',0.00000000,0.00000000,1,'TR','ERI',0,'0275567890','','Phil Daintree','phil@logicworks.co.nz','TOR',2,1,1,0,'34 Marram Way','Extra Street address','Peka Peka','Waikanae','5134','New Zealand','','');
INSERT INTO `custbranch` VALUES ('WEB0000021','WEB0000021','Logic Works Ltd','34 Marram Way','34 Marram Way again','Peka Peka','Waikanae','5134','New Zealand',0.00000000,0.00000000,1,'TR','ERI',0,'1234564','','Phil Daintree','phil@logicworks.co.nz','TOR',2,1,1,0,'34 Marram Way','34 Marram Way again','Peka Peka','Waikanae','5134','New Zealand','','');

--
-- Dumping data for table `custcontacts`
--

INSERT INTO `custcontacts` VALUES (2,'ANGRY','Hamish McKay','CEO','12334302','Whisky drinker single malt only','',0);
INSERT INTO `custcontacts` VALUES (5,'ANGRY','Bob (Robert) Bruce','Chairman','10292811','','',0);
INSERT INTO `custcontacts` VALUES (6,'ANGRY','Billy Wallace','Mover and Shaker','12455778','English Hater','phil@logicworks.co.nz',1);
INSERT INTO `custcontacts` VALUES (7,'16','Phil Daintree','Chairman','45289514','','phil@logicworks.co.nz',1);
INSERT INTO `custcontacts` VALUES (8,'16','Philip','','45289514','','phildaintree@gmail.com',1);

--
-- Dumping data for table `custitem`
--


--
-- Dumping data for table `custnotes`
--


--
-- Dumping data for table `debtorsmaster`
--

INSERT INTO `debtorsmaster` VALUES ('11','Angus Routledge &amp; Co','123 Alexander Road','Roundhay','Leeds','3200','','United Kingdom','USD','DE','2013-06-16 00:00:00',1,'CA',0,0,0,NULL,1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('12','Angus Routledge &amp; Co','123 Alexander Road','Roundhay','Leeds','3211','','United Kingdom','USD','DE','2013-06-16 00:00:00',1,'CA',0,0,0,NULL,1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('13','Angus Routledge &amp; Co','123 Alexander Road','Roundhay','Leeds','LE189','','United Kingdom','USD','DE','2013-06-16 00:00:00',1,'CA',0,0,0,NULL,1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('14','Angus Routledge &amp; Co','123 Alexander Road','Roundhay','Leeds','2113','','United Kingdom','USD','DE','2013-06-16 00:00:00',1,'CA',0,0,0,NULL,1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('16','Logic Works Ltd','34 Marram Way','Peka Peka','RD1 Waiakane','Kapiti','5134','New Zealand','USD','DE','2013-06-23 00:00:00',1,'CA',0,0,8.659050435,'2013-06-24 00:00:00',1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('8','Angus Routledge &amp; Co','123 Alexander Road','Roundhay','Leeds','43990','','United Kingdom','USD','DE','2013-06-16 00:00:00',1,'CA',0,0,0,NULL,1000,0,'',0,0,'','email','','','','',0,1,'fr_FR.utf8');
INSERT INTO `debtorsmaster` VALUES ('ANGRY','Angus Rouledge Younger &amp; Son','P O Box 67','Gowerbridge','Upperton','Michigan','','United States','USD','DE','2005-04-30 00:00:00',1,'CA',0,0,50,'2013-06-16 00:00:00',2500,0,'',0,0,'','email','','','','1344-654-112',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('DUMBLE','Dumbledoor McGonagal & Co','Hogwarts castle','Platform 9.75','','','','','GBP','DE','2005-06-18 00:00:00',1,'30',0,0,10,'2012-12-16 00:00:00',1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('JOLOMU','Lorrima Productions Inc','3215 Great Western Highway','Blubberhouses','Yorkshire','England','','','GBP','DE','2005-06-15 00:00:00',1,'30',0,0,0,NULL,1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('KES','Ken Estoban','','','','','','','KES','DE','2012-10-25 00:00:00',1,'20',0,0,50094,'2012-11-18 00:00:00',1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('NEWTEST','New Customer','','','','','','United States','USD','DE','2013-06-29 00:00:00',1,'20',0,0,0,NULL,1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('QUARTER','Quarter Back to Back','1356 Union Drive','Holborn','England','','','','CHF','DE','2005-09-03 00:00:00',1,'20',0,0,0,NULL,1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('QUICK','Quick Brown PLC','Fox Street','Jumped Over','The Lazy Dog','','','','USD','DE','2007-01-30 00:00:00',1,'20',0,0,0,NULL,1000,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('WEB0000017','Phil Daintree','8 James Nairn Grove','','','Upper Hutt','5018','New Zealand','USD','DE','2013-10-06 09:09:46',1,'CA',0,0,0,NULL,2500,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('WEB0000018','Logic Works Ltd','34 Marram Way','Peka Peka, RD1 Waikanae','','Kapiti','5134','New Zealand','USD','DE','2014-08-31 12:32:16',1,'CA',0,0,0,NULL,2500,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('WEB0000019','Logic Works Ltd','8 James Nairn Grove','James Nairn Grove','Riverstone Terraces','Upper Hutt','5018','New Zealand','USD','DE','2015-01-31 11:40:36',1,'CA',0,0,0,NULL,2500,0,'',0,0,'','email','','','','',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('WEB0000020','Logic Works Ltd','34 Marram Way','Extra Street address','Peka Peka','Waikanae','5134','New Zealand','USD','DE','2017-10-25 17:40:29',1,'CA',0,0,0,NULL,2500,0,'',0,0,'','email','','','','51-534-233',0,1,'en_GB.utf8');
INSERT INTO `debtorsmaster` VALUES ('WEB0000021','Logic Works Ltd','34 Marram Way','34 Marram Way again','Peka Peka','Waikanae','5134','New Zealand','USD','DE','2017-10-25 17:55:52',1,'CA',0,0,0,NULL,2500,0,'',0,0,'','email','','','','tax no',0,1,'en_GB.utf8');

--
-- Dumping data for table `debtortrans`
--

INSERT INTO `debtortrans` VALUES (30,1,12,'16','16','2013-06-23','2013-06-23 19:51:00',19,1,'','',0,1,-109.25,0,0,0,0,-109.25,'web payment',0,0,'',1,'');
INSERT INTO `debtortrans` VALUES (31,2,12,'16','16','2013-06-24','2013-06-24 21:53:00',19,0,'','',0,1,-14.16,0,0,0,0,0,'web payment',0,0,'',1,'');
INSERT INTO `debtortrans` VALUES (32,3,12,'16','16','2013-06-24','2013-06-24 22:36:00',19,0,'V78R4D18BB1E','',4,1,-14.16,0,0,0,0,0,'web payment',0,0,'',1,'ERI');
INSERT INTO `debtortrans` VALUES (33,4,12,'16','16','2013-06-24','2013-06-24 22:38:00',19,0,'V18R4E55E804','',5,1,-8.66,0,0,0,0,0,'web payment',0,0,'',1,'ERI');
INSERT INTO `debtortrans` VALUES (34,1,10,'16','16','2013-06-26','2013-06-25 21:42:59',19,1,'','DE',1,1,97.24,12.01,0,0,0,109.25,'',1,0,'',1,'ERI');
INSERT INTO `debtortrans` VALUES (35,2,10,'12','12','2013-09-07','2013-09-06 21:29:53',22,0,'','DE',7,1,5,0.62,0,0,0,0,'',1,0,'',1,'ERI');
INSERT INTO `debtortrans` VALUES (36,1,11,'ANGRY','ANGRY','2017-01-23','2017-01-23 21:05:42',62,0,'','DE',0,1,-11.73,-1.448655,0,0,0,-13.178655,'',1,0,'',1,'DE');
INSERT INTO `debtortrans` VALUES (37,5,12,'ANGRY','','2017-01-23','2017-01-23 21:05:42',62,0,'1','',0,1,13.18,0,0,0,0,13.18,'Melbourne Counter Sale',0,0,'',1,'');

--
-- Dumping data for table `debtortranstaxes`
--

INSERT INTO `debtortranstaxes` VALUES (34,11,7.14717675);
INSERT INTO `debtortranstaxes` VALUES (34,12,4.862025);
INSERT INTO `debtortranstaxes` VALUES (35,11,0.3675);
INSERT INTO `debtortranstaxes` VALUES (35,12,0.25);
INSERT INTO `debtortranstaxes` VALUES (36,11,-0.862155);
INSERT INTO `debtortranstaxes` VALUES (36,12,-0.5865);

--
-- Dumping data for table `debtortype`
--

INSERT INTO `debtortype` VALUES (1,'Default');

--
-- Dumping data for table `debtortypenotes`
--


--
-- Dumping data for table `departments`
--

INSERT INTO `departments` VALUES (1,'Workshop','admin');
INSERT INTO `departments` VALUES (2,'Customer Services','admin');

--
-- Dumping data for table `discountmatrix`
--

INSERT INTO `discountmatrix` VALUES ('DE','DE',3,0.025);

--
-- Dumping data for table `edi_orders_seg_groups`
--

INSERT INTO `edi_orders_seg_groups` VALUES (0,1,0);
INSERT INTO `edi_orders_seg_groups` VALUES (1,9999,0);
INSERT INTO `edi_orders_seg_groups` VALUES (2,99,0);
INSERT INTO `edi_orders_seg_groups` VALUES (3,99,2);
INSERT INTO `edi_orders_seg_groups` VALUES (5,5,2);
INSERT INTO `edi_orders_seg_groups` VALUES (6,5,0);
INSERT INTO `edi_orders_seg_groups` VALUES (7,5,0);
INSERT INTO `edi_orders_seg_groups` VALUES (8,10,0);
INSERT INTO `edi_orders_seg_groups` VALUES (9,9999,8);
INSERT INTO `edi_orders_seg_groups` VALUES (10,10,0);
INSERT INTO `edi_orders_seg_groups` VALUES (11,10,10);
INSERT INTO `edi_orders_seg_groups` VALUES (12,5,0);
INSERT INTO `edi_orders_seg_groups` VALUES (13,99,0);
INSERT INTO `edi_orders_seg_groups` VALUES (14,5,13);
INSERT INTO `edi_orders_seg_groups` VALUES (15,10,0);
INSERT INTO `edi_orders_seg_groups` VALUES (19,99,0);
INSERT INTO `edi_orders_seg_groups` VALUES (20,1,19);
INSERT INTO `edi_orders_seg_groups` VALUES (21,1,19);
INSERT INTO `edi_orders_seg_groups` VALUES (22,2,19);
INSERT INTO `edi_orders_seg_groups` VALUES (23,1,19);
INSERT INTO `edi_orders_seg_groups` VALUES (24,5,19);
INSERT INTO `edi_orders_seg_groups` VALUES (28,200000,0);
INSERT INTO `edi_orders_seg_groups` VALUES (32,25,28);
INSERT INTO `edi_orders_seg_groups` VALUES (33,9999,28);
INSERT INTO `edi_orders_seg_groups` VALUES (34,99,28);
INSERT INTO `edi_orders_seg_groups` VALUES (36,5,34);
INSERT INTO `edi_orders_seg_groups` VALUES (37,9999,28);
INSERT INTO `edi_orders_seg_groups` VALUES (38,10,28);
INSERT INTO `edi_orders_seg_groups` VALUES (39,999,28);
INSERT INTO `edi_orders_seg_groups` VALUES (42,5,39);
INSERT INTO `edi_orders_seg_groups` VALUES (43,99,28);
INSERT INTO `edi_orders_seg_groups` VALUES (44,1,43);
INSERT INTO `edi_orders_seg_groups` VALUES (45,1,43);
INSERT INTO `edi_orders_seg_groups` VALUES (46,2,43);
INSERT INTO `edi_orders_seg_groups` VALUES (47,1,43);
INSERT INTO `edi_orders_seg_groups` VALUES (48,5,43);
INSERT INTO `edi_orders_seg_groups` VALUES (49,10,28);
INSERT INTO `edi_orders_seg_groups` VALUES (50,1,0);

--
-- Dumping data for table `edi_orders_segs`
--

INSERT INTO `edi_orders_segs` VALUES (1,'UNB',0,1);
INSERT INTO `edi_orders_segs` VALUES (2,'UNH',0,1);
INSERT INTO `edi_orders_segs` VALUES (3,'BGM',0,1);
INSERT INTO `edi_orders_segs` VALUES (4,'DTM',0,35);
INSERT INTO `edi_orders_segs` VALUES (5,'PAI',0,1);
INSERT INTO `edi_orders_segs` VALUES (6,'ALI',0,5);
INSERT INTO `edi_orders_segs` VALUES (7,'FTX',0,99);
INSERT INTO `edi_orders_segs` VALUES (8,'RFF',1,1);
INSERT INTO `edi_orders_segs` VALUES (9,'DTM',1,5);
INSERT INTO `edi_orders_segs` VALUES (10,'NAD',2,1);
INSERT INTO `edi_orders_segs` VALUES (11,'LOC',2,99);
INSERT INTO `edi_orders_segs` VALUES (12,'FII',2,5);
INSERT INTO `edi_orders_segs` VALUES (13,'RFF',3,1);
INSERT INTO `edi_orders_segs` VALUES (14,'CTA',5,1);
INSERT INTO `edi_orders_segs` VALUES (15,'COM',5,5);
INSERT INTO `edi_orders_segs` VALUES (16,'TAX',6,1);
INSERT INTO `edi_orders_segs` VALUES (17,'MOA',6,1);
INSERT INTO `edi_orders_segs` VALUES (18,'CUX',7,1);
INSERT INTO `edi_orders_segs` VALUES (19,'DTM',7,5);
INSERT INTO `edi_orders_segs` VALUES (20,'PAT',8,1);
INSERT INTO `edi_orders_segs` VALUES (21,'DTM',8,5);
INSERT INTO `edi_orders_segs` VALUES (22,'PCD',8,1);
INSERT INTO `edi_orders_segs` VALUES (23,'MOA',9,1);
INSERT INTO `edi_orders_segs` VALUES (24,'TDT',10,1);
INSERT INTO `edi_orders_segs` VALUES (25,'LOC',11,1);
INSERT INTO `edi_orders_segs` VALUES (26,'DTM',11,5);
INSERT INTO `edi_orders_segs` VALUES (27,'TOD',12,1);
INSERT INTO `edi_orders_segs` VALUES (28,'LOC',12,2);
INSERT INTO `edi_orders_segs` VALUES (29,'PAC',13,1);
INSERT INTO `edi_orders_segs` VALUES (30,'PCI',14,1);
INSERT INTO `edi_orders_segs` VALUES (31,'RFF',14,1);
INSERT INTO `edi_orders_segs` VALUES (32,'DTM',14,5);
INSERT INTO `edi_orders_segs` VALUES (33,'GIN',14,10);
INSERT INTO `edi_orders_segs` VALUES (34,'EQD',15,1);
INSERT INTO `edi_orders_segs` VALUES (35,'ALC',19,1);
INSERT INTO `edi_orders_segs` VALUES (36,'ALI',19,5);
INSERT INTO `edi_orders_segs` VALUES (37,'DTM',19,5);
INSERT INTO `edi_orders_segs` VALUES (38,'QTY',20,1);
INSERT INTO `edi_orders_segs` VALUES (39,'RNG',20,1);
INSERT INTO `edi_orders_segs` VALUES (40,'PCD',21,1);
INSERT INTO `edi_orders_segs` VALUES (41,'RNG',21,1);
INSERT INTO `edi_orders_segs` VALUES (42,'MOA',22,1);
INSERT INTO `edi_orders_segs` VALUES (43,'RNG',22,1);
INSERT INTO `edi_orders_segs` VALUES (44,'RTE',23,1);
INSERT INTO `edi_orders_segs` VALUES (45,'RNG',23,1);
INSERT INTO `edi_orders_segs` VALUES (46,'TAX',24,1);
INSERT INTO `edi_orders_segs` VALUES (47,'MOA',24,1);
INSERT INTO `edi_orders_segs` VALUES (48,'LIN',28,1);
INSERT INTO `edi_orders_segs` VALUES (49,'PIA',28,25);
INSERT INTO `edi_orders_segs` VALUES (50,'IMD',28,99);
INSERT INTO `edi_orders_segs` VALUES (51,'MEA',28,99);
INSERT INTO `edi_orders_segs` VALUES (52,'QTY',28,99);
INSERT INTO `edi_orders_segs` VALUES (53,'ALI',28,5);
INSERT INTO `edi_orders_segs` VALUES (54,'DTM',28,35);
INSERT INTO `edi_orders_segs` VALUES (55,'MOA',28,10);
INSERT INTO `edi_orders_segs` VALUES (56,'GIN',28,127);
INSERT INTO `edi_orders_segs` VALUES (57,'QVR',28,1);
INSERT INTO `edi_orders_segs` VALUES (58,'FTX',28,99);
INSERT INTO `edi_orders_segs` VALUES (59,'PRI',32,1);
INSERT INTO `edi_orders_segs` VALUES (60,'CUX',32,1);
INSERT INTO `edi_orders_segs` VALUES (61,'DTM',32,5);
INSERT INTO `edi_orders_segs` VALUES (62,'RFF',33,1);
INSERT INTO `edi_orders_segs` VALUES (63,'DTM',33,5);
INSERT INTO `edi_orders_segs` VALUES (64,'PAC',34,1);
INSERT INTO `edi_orders_segs` VALUES (65,'QTY',34,5);
INSERT INTO `edi_orders_segs` VALUES (66,'PCI',36,1);
INSERT INTO `edi_orders_segs` VALUES (67,'RFF',36,1);
INSERT INTO `edi_orders_segs` VALUES (68,'DTM',36,5);
INSERT INTO `edi_orders_segs` VALUES (69,'GIN',36,10);
INSERT INTO `edi_orders_segs` VALUES (70,'LOC',37,1);
INSERT INTO `edi_orders_segs` VALUES (71,'QTY',37,1);
INSERT INTO `edi_orders_segs` VALUES (72,'DTM',37,5);
INSERT INTO `edi_orders_segs` VALUES (73,'TAX',38,1);
INSERT INTO `edi_orders_segs` VALUES (74,'MOA',38,1);
INSERT INTO `edi_orders_segs` VALUES (75,'NAD',39,1);
INSERT INTO `edi_orders_segs` VALUES (76,'CTA',42,1);
INSERT INTO `edi_orders_segs` VALUES (77,'COM',42,5);
INSERT INTO `edi_orders_segs` VALUES (78,'ALC',43,1);
INSERT INTO `edi_orders_segs` VALUES (79,'ALI',43,5);
INSERT INTO `edi_orders_segs` VALUES (80,'DTM',43,5);
INSERT INTO `edi_orders_segs` VALUES (81,'QTY',44,1);
INSERT INTO `edi_orders_segs` VALUES (82,'RNG',44,1);
INSERT INTO `edi_orders_segs` VALUES (83,'PCD',45,1);
INSERT INTO `edi_orders_segs` VALUES (84,'RNG',45,1);
INSERT INTO `edi_orders_segs` VALUES (85,'MOA',46,1);
INSERT INTO `edi_orders_segs` VALUES (86,'RNG',46,1);
INSERT INTO `edi_orders_segs` VALUES (87,'RTE',47,1);
INSERT INTO `edi_orders_segs` VALUES (88,'RNG',47,1);
INSERT INTO `edi_orders_segs` VALUES (89,'TAX',48,1);
INSERT INTO `edi_orders_segs` VALUES (90,'MOA',48,1);
INSERT INTO `edi_orders_segs` VALUES (91,'TDT',49,1);
INSERT INTO `edi_orders_segs` VALUES (92,'UNS',50,1);
INSERT INTO `edi_orders_segs` VALUES (93,'MOA',50,1);
INSERT INTO `edi_orders_segs` VALUES (94,'CNT',50,1);
INSERT INTO `edi_orders_segs` VALUES (95,'UNT',50,1);

--
-- Dumping data for table `ediitemmapping`
--


--
-- Dumping data for table `edimessageformat`
--


--
-- Dumping data for table `emailsettings`
--


--
-- Dumping data for table `employees`
--

INSERT INTO `employees` VALUES (1,'Flintstone','Fred','LABOUR',0,95,'admin','fred@weberpdemo.org');
INSERT INTO `employees` VALUES (3,'Alot','Lance','LABOUR',1,40,'','lance@weberpdemo.org');

--
-- Dumping data for table `factorcompanies`
--


--
-- Dumping data for table `favourites`
--


--
-- Dumping data for table `fixedassetcategories`
--

INSERT INTO `fixedassetcategories` VALUES ('PLANT','Plant and Equipment','1650','7750','8100','1670',0.2,1);

--
-- Dumping data for table `fixedassetlocations`
--

INSERT INTO `fixedassetlocations` VALUES ('HEADOF','Head Office','');
INSERT INTO `fixedassetlocations` VALUES ('TORONT','Toronto Warehouse','');

--
-- Dumping data for table `fixedassets`
--

INSERT INTO `fixedassets` VALUES (1,'','','HEADOF',0,0,'0000-00-00',0,'PLANT','test 1','Test 1',0,5,'0000-00-00');

--
-- Dumping data for table `fixedassettasks`
--


--
-- Dumping data for table `fixedassettrans`
--


--
-- Dumping data for table `freightcosts`
--


--
-- Dumping data for table `geocode_param`
--


--
-- Dumping data for table `glaccountusers`
--

INSERT INTO `glaccountusers` VALUES ('1','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1010','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1020','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1030','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1040','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1050','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1060','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1070','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1080','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1090','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1100','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1150','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1200','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1250','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1300','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1350','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1400','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1420','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1440','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1460','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1500','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1550','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1600','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1620','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1650','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1670','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1700','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1710','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1720','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1730','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1740','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1750','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1760','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1770','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1780','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1790','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1800','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1850','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('1900','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2010','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2020','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2050','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2100','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2150','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2200','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2230','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2250','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2300','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2310','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2320','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2330','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2340','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2350','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2360','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2400','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2410','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2420','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2450','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2460','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2480','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2500','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2550','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2560','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2600','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2700','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2720','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2740','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2760','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2800','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('2900','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('3100','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('3200','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('3300','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('3400','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('3500','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('4100','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('4200','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('4500','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('4600','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('4700','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('4800','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('4900','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('5000','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('5100','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('5200','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('5500','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('5600','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('5700','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('5800','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('5900','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6100','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6150','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6200','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6250','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6300','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6400','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6500','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6550','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6590','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6600','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6700','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6800','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('6900','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7020','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7030','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7040','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7050','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7060','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7070','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7080','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7090','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7100','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7150','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7200','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7210','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7220','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7230','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7240','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7260','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7280','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7300','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7350','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7390','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7400','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7450','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7500','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7550','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7600','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7610','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7620','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7630','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7640','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7650','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7660','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7700','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7750','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7800','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('7900','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('8100','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('8200','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('8300','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('8400','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('8500','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('8600','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('8900','admin',1,1);
INSERT INTO `glaccountusers` VALUES ('9100','admin',1,1);

--
-- Dumping data for table `gltrans`
--

INSERT INTO `gltrans` VALUES (1,0,7,0,'2013-02-08',15,'5500','CUTTING Change stock category',0,1,'',0);
INSERT INTO `gltrans` VALUES (2,0,7,0,'2013-02-08',15,'1460','CUTTING Change stock category',0,1,'',0);
INSERT INTO `gltrans` VALUES (3,20,37,0,'2013-02-08',15,'4600','CRUISE open item',150.61669829222,1,'',0);
INSERT INTO `gltrans` VALUES (4,20,37,0,'2013-02-08',15,'2100','CRUISE - Inv opninvoice GBP95.25 @ a rate of 0.6324',-150.61669829222,1,'',0);
INSERT INTO `gltrans` VALUES (5,10,4,0,'2013-02-11',15,'5000','ANGRY - TAPE2 x 1 @ 2.5000',2.5,1,'',0);
INSERT INTO `gltrans` VALUES (6,10,4,0,'2013-02-11',15,'1460','ANGRY - TAPE2 x 1 @ 2.5000',-2.5,1,'',0);
INSERT INTO `gltrans` VALUES (7,10,4,0,'2013-02-11',15,'4100','ANGRY - TAPE2 x 1 @ 15',-15,1,'',0);
INSERT INTO `gltrans` VALUES (8,10,4,0,'2013-02-11',15,'1100','ANGRY',16.5,1,'',0);
INSERT INTO `gltrans` VALUES (9,10,4,0,'2013-02-11',15,'2300','ANGRY',-1.5,1,'',0);
INSERT INTO `gltrans` VALUES (12,25,50,0,'2013-01-06',14,'1460','PO: 23 BINGO - DVD_ACTION - Action Series Bundle x 1 @ 16.22',16.22,1,'',0);
INSERT INTO `gltrans` VALUES (13,25,50,0,'2013-01-06',14,'2150','PO1360356432: 23 BINGO - DVD_ACTION - Action Series Bundle x 1 @ 16.22',-16.22,1,'',0);
INSERT INTO `gltrans` VALUES (14,25,51,0,'2013-02-09',15,'1460','PO: 25 CRUISE - TAPE1 - DFR-12  DFR Tape per Keystone spec x 100 @ 10.00',1000,1,'',0);
INSERT INTO `gltrans` VALUES (15,25,51,0,'2013-02-09',15,'2150','PO1360356915: 25 CRUISE - TAPE1 - DFR-12  DFR Tape per Keystone spec x 100 @ 10.00',-1000,1,'',0);
INSERT INTO `gltrans` VALUES (16,25,52,0,'2013-02-09',15,'1460','PO: 27 CRUISE - TAPE1 - DFR-12 - DFR Tape per Keystone spec x 10 @ 10.00',100,1,'',0);
INSERT INTO `gltrans` VALUES (17,25,52,0,'2013-02-09',15,'2150','PO1360357179: 27 CRUISE - TAPE1 - DFR-12 - DFR Tape per Keystone spec x 10 @ 10.00',-100,1,'',0);
INSERT INTO `gltrans` VALUES (18,35,19,0,'2013-02-09',15,'5700','TAPE2 cost was 2.5000 changed to 2.5 x Quantity on hand of -1',0,1,'',0);
INSERT INTO `gltrans` VALUES (19,35,19,0,'2013-02-09',15,'1460','TAPE2 cost was 2.5000 changed to 2.5 x Quantity on hand of -1',0,1,'',0);
INSERT INTO `gltrans` VALUES (20,10,5,0,'2013-02-11',15,'5000','ANGRY - SELLTAPE x 100 @ 0.01',1.0000000000000004,1,'',0);
INSERT INTO `gltrans` VALUES (21,10,5,0,'2013-02-11',15,'1460','ANGRY - SELLTAPE x 100 @ 0.01',-1,1,'',0);
INSERT INTO `gltrans` VALUES (22,10,5,0,'2013-02-11',15,'4100','ANGRY - SELLTAPE x 100 @ 0.5',-50,1,'',0);
INSERT INTO `gltrans` VALUES (23,10,5,0,'2013-02-11',15,'1100','ANGRY',56.18,1,'',0);
INSERT INTO `gltrans` VALUES (24,10,5,0,'2013-02-11',15,'2300','ANGRY',-2.5,1,'',0);
INSERT INTO `gltrans` VALUES (25,10,5,0,'2013-02-11',15,'2300','ANGRY',-3.68,1,'',0);
INSERT INTO `gltrans` VALUES (26,28,13,0,'2013-02-09',15,'1440','31 CUTTING x 2 @ 0.00',0,1,'',0);
INSERT INTO `gltrans` VALUES (27,28,13,0,'2013-02-09',15,'5500','31 CUTTING x 2 @ 0.00',0,1,'',0);
INSERT INTO `gltrans` VALUES (28,28,14,0,'2013-02-09',15,'1440','31 - TAPE2 Component: TAPE1 - 90 x 0.25 @ 10.00',225,1,'',0);
INSERT INTO `gltrans` VALUES (29,28,14,0,'2013-02-09',15,'1460','31 - TAPE2 -> TAPE1 - 90 x 0.25 @ 10.00',-225,1,'',0);
INSERT INTO `gltrans` VALUES (30,26,8,0,'2013-02-09',15,'1460','31 TAPE2 - Tape 2 x 90 @ 2.50',225,1,'',0);
INSERT INTO `gltrans` VALUES (31,26,8,0,'2013-02-09',15,'1440','31 TAPE2 - Tape 2 x 90 @ 2.50',-225,1,'',0);
INSERT INTO `gltrans` VALUES (32,35,20,0,'2013-04-25',17,'5700','BREAD cost was 0.4118 changed to 0.5625 x Quantity on hand of -6',0.9042,1,'',0);
INSERT INTO `gltrans` VALUES (33,35,20,0,'2013-04-25',17,'1460','BREAD cost was 0.4118 changed to 0.5625 x Quantity on hand of -6',-0.9042,1,'',0);
INSERT INTO `gltrans` VALUES (34,35,21,0,'2013-04-25',17,'5700','BREAD cost was 0.5625 changed to 0.5625 x Quantity on hand of -6',0,1,'',0);
INSERT INTO `gltrans` VALUES (35,35,21,0,'2013-04-25',17,'1460','BREAD cost was 0.5625 changed to 0.5625 x Quantity on hand of -6',0,1,'',0);
INSERT INTO `gltrans` VALUES (36,35,22,0,'2013-04-25',17,'5700','BREAD cost was 0.5625 changed to 0.5625 x Quantity on hand of -6',0,1,'',0);
INSERT INTO `gltrans` VALUES (37,35,22,0,'2013-04-25',17,'1460','BREAD cost was 0.5625 changed to 0.5625 x Quantity on hand of -6',0,1,'',0);
INSERT INTO `gltrans` VALUES (38,35,23,0,'2013-04-25',17,'5700','BREAD cost was 0.5625 changed to 0.5625 x Quantity on hand of -6',0,1,'',0);
INSERT INTO `gltrans` VALUES (39,35,23,0,'2013-04-25',17,'1460','BREAD cost was 0.5625 changed to 0.5625 x Quantity on hand of -6',0,1,'',0);
INSERT INTO `gltrans` VALUES (40,35,24,0,'2013-04-25',17,'5700','BREAD cost was 0.5625 changed to 0.5625 x Quantity on hand of -6',0,1,'',0);
INSERT INTO `gltrans` VALUES (41,35,24,0,'2013-04-25',17,'1460','BREAD cost was 0.5625 changed to 0.5625 x Quantity on hand of -6',0,1,'',0);
INSERT INTO `gltrans` VALUES (42,10,6,0,'2013-04-29',17,'5000','DUMBLE - BREAD x 3 @ 0.5625',1.69,1,'',0);
INSERT INTO `gltrans` VALUES (43,10,6,0,'2013-04-29',17,'1460','DUMBLE - BREAD x 3 @ 0.5625',-1.69,1,'',0);
INSERT INTO `gltrans` VALUES (44,10,6,0,'2013-04-29',17,'4100','DUMBLE - BREAD x 3 @ 1001.25',-4651.93,1,'',0);
INSERT INTO `gltrans` VALUES (45,10,6,0,'2013-04-29',17,'1100','DUMBLE',4651.93,1,'',0);
INSERT INTO `gltrans` VALUES (46,10,7,0,'2013-04-29',17,'5000','DUMBLE - BREAD x 1 @ 0.5625',0.56,1,'',0);
INSERT INTO `gltrans` VALUES (47,10,7,0,'2013-04-29',17,'1460','DUMBLE - BREAD x 1 @ 0.5625',-0.56,1,'',0);
INSERT INTO `gltrans` VALUES (48,10,7,0,'2013-04-29',17,'4100','DUMBLE - BREAD x 1 @ 5.9',-9.14,1,'',0);
INSERT INTO `gltrans` VALUES (49,10,7,0,'2013-04-29',17,'4900','DUMBLE - BREAD @ 2.5%',0.23,1,'',0);
INSERT INTO `gltrans` VALUES (50,10,7,0,'2013-04-29',17,'1100','DUMBLE',8.91,1,'',0);
INSERT INTO `gltrans` VALUES (51,11,1,0,'2013-05-02',18,'5000','ANGRY - TAPE2 x 1 @ 2.5000',-2.5000000000000013,1,'',0);
INSERT INTO `gltrans` VALUES (52,11,1,0,'2013-05-02',18,'1460','ANGRY - TAPE2 x 1 @ 2.5000',2.5,1,'',0);
INSERT INTO `gltrans` VALUES (53,11,1,0,'2013-05-02',18,'4100','ANGRY - TAPE2 x 1 @ 15.00',15,1,'',0);
INSERT INTO `gltrans` VALUES (54,11,1,0,'2013-05-02',18,'1100','ANGRY',-16.5,1,'',0);
INSERT INTO `gltrans` VALUES (55,11,1,0,'2013-05-02',18,'2300','ANGRY',1.5,1,'',0);
INSERT INTO `gltrans` VALUES (56,11,2,0,'2013-05-02',18,'5000','ANGRY - SELLTAPE x 100 @ 10',-999.995,1,'',0);
INSERT INTO `gltrans` VALUES (57,11,2,0,'2013-05-02',18,'1460','ANGRY - SELLTAPE x 100 @ 10',1000,1,'',0);
INSERT INTO `gltrans` VALUES (58,11,2,0,'2013-05-02',18,'4100','ANGRY - SELLTAPE x 100 @ 0.50',50,1,'',0);
INSERT INTO `gltrans` VALUES (59,11,2,0,'2013-05-02',18,'1100','ANGRY',-56.18,1,'',0);
INSERT INTO `gltrans` VALUES (60,11,2,0,'2013-05-02',18,'2300','ANGRY',2.5,1,'',0);
INSERT INTO `gltrans` VALUES (61,11,2,0,'2013-05-02',18,'2300','ANGRY',3.675,1,'',0);
INSERT INTO `gltrans` VALUES (62,11,3,0,'2013-05-02',18,'5000','ANGRY - BREAD x 2 @ 0.5625',-1.1249999999999996,1,'',0);
INSERT INTO `gltrans` VALUES (63,11,3,0,'2013-05-02',18,'1460','ANGRY - BREAD x 2 @ 0.5625',1.13,1,'',0);
INSERT INTO `gltrans` VALUES (64,11,3,0,'2013-05-02',18,'4100','ANGRY - BREAD x 2 @ 5.00',10,1,'',0);
INSERT INTO `gltrans` VALUES (65,11,3,0,'2013-05-02',18,'1100','ANGRY',-11.24,1,'',0);
INSERT INTO `gltrans` VALUES (66,11,3,0,'2013-05-02',18,'2300','ANGRY',0.5,1,'',0);
INSERT INTO `gltrans` VALUES (67,11,3,0,'2013-05-02',18,'2300','ANGRY',0.735,1,'',0);
INSERT INTO `gltrans` VALUES (68,11,4,0,'2013-05-02',18,'5000','ANGRY - SELLTAPE x 100 @ 10',-999.995,1,'',0);
INSERT INTO `gltrans` VALUES (69,11,4,0,'2013-05-02',18,'1460','ANGRY - SELLTAPE x 100 @ 10',1000,1,'',0);
INSERT INTO `gltrans` VALUES (70,11,4,0,'2013-05-02',18,'4100','ANGRY - SELLTAPE x 100 @ 0.5000',50,1,'',0);
INSERT INTO `gltrans` VALUES (71,11,4,0,'2013-05-02',18,'1100','ANGRY',-56.18,1,'',0);
INSERT INTO `gltrans` VALUES (72,11,4,0,'2013-05-02',18,'2300','ANGRY',2.5,1,'',0);
INSERT INTO `gltrans` VALUES (73,11,4,0,'2013-05-02',18,'2300','ANGRY',3.675,1,'',0);
INSERT INTO `gltrans` VALUES (74,12,5,0,'2013-05-10',18,'1090','',-50.236109715664,1,'',0);
INSERT INTO `gltrans` VALUES (75,12,5,0,'2013-05-10',18,'1030','',50.236109715664,1,'',0);
INSERT INTO `gltrans` VALUES (76,12,12,0,'2013-06-08',19,'1030','7 payment for order34',8.659050435,1,'',0);
INSERT INTO `gltrans` VALUES (77,12,12,0,'2013-06-08',19,'1100','7 payment for order34',-8.659050435,1,'',0);
INSERT INTO `gltrans` VALUES (78,12,13,0,'2013-06-08',19,'1030','7 payment for order 35',14.161998375,1,'',0);
INSERT INTO `gltrans` VALUES (79,12,13,0,'2013-06-08',19,'1100','7 payment for order 35',-14.161998375,1,'',0);
INSERT INTO `gltrans` VALUES (80,12,14,0,'2013-06-08',19,'1040','7 payment for order 36',14.23081275,1,'',0);
INSERT INTO `gltrans` VALUES (81,12,14,0,'2013-06-08',19,'1100','7 payment for order 36',-14.23081275,1,'',0);
INSERT INTO `gltrans` VALUES (83,12,16,0,'2013-06-08',19,'1100','7 payment for order ',-14.161998375,1,'',0);
INSERT INTO `gltrans` VALUES (84,12,17,0,'2013-06-08',19,'1030','7 payment for order ',14.161998375,1,'',0);
INSERT INTO `gltrans` VALUES (85,12,17,0,'2013-06-08',19,'1100','7 payment for order ',-14.161998375,1,'',0);
INSERT INTO `gltrans` VALUES (86,17,28,0,'2013-06-13',19,'5700','HIT3043-5 x 6 @ 1235 ',-7410,1,'',0);
INSERT INTO `gltrans` VALUES (87,17,28,0,'2013-06-13',19,'1460','HIT3043-5 x 6 @ 1235 ',7410,1,'',0);
INSERT INTO `gltrans` VALUES (88,12,18,0,'2013-06-16',19,'1030','',85.900025142937,1,'',0);
INSERT INTO `gltrans` VALUES (89,12,18,0,'2013-06-16',19,'1100','',-85.900025142937,1,'',0);
INSERT INTO `gltrans` VALUES (90,12,18,0,'2013-06-16',19,'4200','',-0.0000060910887835774,1,'',0);
INSERT INTO `gltrans` VALUES (91,12,18,0,'2013-06-16',19,'1100','',0.0000060910887835774,1,'',0);
INSERT INTO `gltrans` VALUES (92,28,15,0,'2013-06-21',19,'1440','32 TAPE1 x 2 @ 10.00',20,1,'',0);
INSERT INTO `gltrans` VALUES (93,28,15,0,'2013-06-21',19,'1460','32 TAPE1 x 2 @ 10.00',-20,1,'',0);
INSERT INTO `gltrans` VALUES (94,28,16,0,'2013-06-21',19,'1440','32 SALT x 1.5 @ 2.50',3.75,1,'',0);
INSERT INTO `gltrans` VALUES (95,28,16,0,'2013-06-21',19,'1460','32 SALT x 1.5 @ 2.50',-3.75,1,'',0);
INSERT INTO `gltrans` VALUES (96,28,17,0,'2013-06-21',19,'1440','32 TAPE2 x 3.5 @ 2.50',8.75,1,'',0);
INSERT INTO `gltrans` VALUES (97,28,17,0,'2013-06-21',19,'1460','32 TAPE2 x 3.5 @ 2.50',-8.75,1,'',0);
INSERT INTO `gltrans` VALUES (98,12,19,0,'2013-06-23',19,'1030','7 payment for order 41 Transaction ID: B254331D91384',43.295252175,1,'',0);
INSERT INTO `gltrans` VALUES (99,12,19,0,'2013-06-23',19,'1100','7 payment for order 41 Transaction ID: B254331D91384',-43.295252175,1,'',0);
INSERT INTO `gltrans` VALUES (100,12,20,0,'2013-06-23',19,'1030','7 payment for order 42 Transaction ID: B254348421937',5317.9749,1,'',0);
INSERT INTO `gltrans` VALUES (101,12,20,0,'2013-06-23',19,'1100','7 payment for order 42 Transaction ID: B254348421937',-5317.9749,1,'',0);
INSERT INTO `gltrans` VALUES (102,12,21,0,'2013-06-23',19,'1040','7 payment for order  Transaction ID: ',8.70112551,1,'',0);
INSERT INTO `gltrans` VALUES (103,12,21,0,'2013-06-23',19,'1100','7 payment for order  Transaction ID: ',-8.70112551,1,'',0);
INSERT INTO `gltrans` VALUES (104,0,8,0,'2013-06-23',19,'1010','PAYTSURCHARGE Change stock category',0,1,'',0);
INSERT INTO `gltrans` VALUES (105,0,8,0,'2013-06-23',19,'1460','PAYTSURCHARGE Change stock category',0,1,'',0);
INSERT INTO `gltrans` VALUES (106,12,1,0,'2013-06-23',19,'1040','7 payment for order 1 Transaction ID: 7XT5929577922053V',36.5935185,1,'',0);
INSERT INTO `gltrans` VALUES (107,12,1,0,'2013-06-23',19,'1100','7 payment for order 1 Transaction ID: 7XT5929577922053V',-36.5935185,1,'',0);
INSERT INTO `gltrans` VALUES (108,12,1,0,'2013-06-23',19,'1030','16 payment for order  Transaction ID: ',109.24970175,1,'',0);
INSERT INTO `gltrans` VALUES (109,12,1,0,'2013-06-23',19,'1100','16 payment for order  Transaction ID: ',-109.24970175,1,'',0);
INSERT INTO `gltrans` VALUES (110,12,2,0,'2013-06-24',19,'1030','16 payment for order  Transaction ID: ',14.161998375,1,'',0);
INSERT INTO `gltrans` VALUES (111,12,2,0,'2013-06-24',19,'1100','16 payment for order  Transaction ID: ',-14.161998375,1,'',0);
INSERT INTO `gltrans` VALUES (112,12,3,0,'2013-06-24',19,'1030','16 payment for order 4 Transaction ID: V78R4D18BB1E',14.161998375,1,'',0);
INSERT INTO `gltrans` VALUES (113,12,3,0,'2013-06-24',19,'1100','16 payment for order 4 Transaction ID: V78R4D18BB1E',-14.161998375,1,'',0);
INSERT INTO `gltrans` VALUES (114,12,4,0,'2013-06-24',19,'1030','16 payment for order 5 Transaction ID: V18R4E55E804',8.659050435,1,'',0);
INSERT INTO `gltrans` VALUES (115,12,4,0,'2013-06-24',19,'1100','16 payment for order 5 Transaction ID: V18R4E55E804',-8.659050435,1,'',0);
INSERT INTO `gltrans` VALUES (116,10,1,0,'2013-06-26',19,'5000','16 - DVD-DHWV x 9 @ 2.3200',20.879999999999995,1,'',0);
INSERT INTO `gltrans` VALUES (117,10,1,0,'2013-06-26',19,'1460','16 - DVD-DHWV x 9 @ 2.3200',-20.88,1,'',0);
INSERT INTO `gltrans` VALUES (118,10,1,0,'2013-06-26',19,'4100','16 - DVD-DHWV x 9 @ 10.5',-94.5,1,'',0);
INSERT INTO `gltrans` VALUES (119,10,1,0,'2013-06-26',19,'7230','16 - PAYTSURCHARGE x 1 @ 2.7405',-2.74,1,'',0);
INSERT INTO `gltrans` VALUES (120,10,1,0,'2013-06-26',19,'1100','16',109.25,1,'',0);
INSERT INTO `gltrans` VALUES (121,10,1,0,'2013-06-26',19,'2300','16',-4.86,1,'',0);
INSERT INTO `gltrans` VALUES (122,10,1,0,'2013-06-26',19,'2300','16',-7.15,1,'',0);
INSERT INTO `gltrans` VALUES (123,10,2,0,'2013-09-07',22,'5000','12 - BREAD x 2 @ 0.5625',1.13,1,'',0);
INSERT INTO `gltrans` VALUES (124,10,2,0,'2013-09-07',22,'1460','12 - BREAD x 2 @ 0.5625',-1.13,1,'',0);
INSERT INTO `gltrans` VALUES (125,10,2,0,'2013-09-07',22,'4100','12 - BREAD x 2 @ 2.5',-5,1,'',0);
INSERT INTO `gltrans` VALUES (126,10,2,0,'2013-09-07',22,'1100','12',5.62,1,'',0);
INSERT INTO `gltrans` VALUES (127,10,2,0,'2013-09-07',22,'2300','12',-0.25,1,'',0);
INSERT INTO `gltrans` VALUES (128,10,2,0,'2013-09-07',22,'2300','12',-0.37,1,'',0);
INSERT INTO `gltrans` VALUES (129,25,53,0,'2013-10-05',23,'1','PO: 29 OTHER -  - Some item x 1 @ 45.94',45.938993017273,1,'',0);
INSERT INTO `gltrans` VALUES (130,25,53,0,'2013-10-05',23,'2150','PO1380921154: 29 OTHER -  - Some item x 1 @ 45.94',-45.938993017273,1,'',0);
INSERT INTO `gltrans` VALUES (131,20,38,0,'2013-10-05',23,'2150','OTHER - GRN 4 -  x 1 @  std cost of 45.938993017273',45.938993017273106,1,'',0);
INSERT INTO `gltrans` VALUES (132,20,38,0,'2013-10-05',23,'1','OTHER - GRN 4 - Some item x 1 x  price var 4.59',4.5938993017274,1,'',0);
INSERT INTO `gltrans` VALUES (133,20,38,0,'2013-10-05',23,'2310','OTHER - Inv 145 Ontario PST 5.00% AUD2.75 @ exch rate 1.08840000',2.52664461595,1,'',0);
INSERT INTO `gltrans` VALUES (134,20,38,0,'2013-10-05',23,'2310','OTHER - Inv 145 Canadian GST 7.00% AUD4.0425 @ exch rate 1.08840000',3.7141675854465,1,'',0);
INSERT INTO `gltrans` VALUES (135,20,38,0,'2013-10-05',23,'2100','OTHER - Inv 145 AUD61.79 @ a rate of 1.08840000',-56.773704520397,1,'',0);
INSERT INTO `gltrans` VALUES (136,22,9,0,'2013-11-20',24,'2100','OTHER-',91.877986034546,1,'',0);
INSERT INTO `gltrans` VALUES (137,22,9,0,'2013-11-20',24,'1030','OTHER-',-91.877986034546,1,'',0);
INSERT INTO `gltrans` VALUES (138,22,10,0,'2013-11-20',24,'2100','OTHER-',100,1,'',0);
INSERT INTO `gltrans` VALUES (139,22,10,0,'2013-11-20',24,'1030','OTHER-',-100,1,'',0);
INSERT INTO `gltrans` VALUES (140,22,11,0,'2013-11-20',24,'2100','OTHER-',91.877986034546,1,'',0);
INSERT INTO `gltrans` VALUES (141,22,11,0,'2013-11-20',24,'1030','OTHER-',-91.877986034546,1,'',0);
INSERT INTO `gltrans` VALUES (142,20,39,0,'2013-11-30',24,'1460','BINGO - Average Cost Adj - DVD_ACTION x 1 x 52.35',52.35,1,'',0);
INSERT INTO `gltrans` VALUES (143,20,39,0,'2013-11-30',24,'2310','BINGO - Inv aA112 Australian GST 10.00% USD5.235 @ exch rate 1.00000000',5.235,1,'',0);
INSERT INTO `gltrans` VALUES (144,20,39,0,'2013-11-30',24,'2100','BINGO - Inv aA112 USD57.59 @ a rate of 1.00000000',-57.585,1,'',0);
INSERT INTO `gltrans` VALUES (145,25,54,0,'2014-01-13',26,'1460','PO: 30 BINGO - DVD-CASE - webERP Demo DVD Case x 100 @ 0.30',30,1,'',0);
INSERT INTO `gltrans` VALUES (146,25,54,0,'2014-01-13',26,'2150','PO1389596068: 30 BINGO - DVD-CASE - webERP Demo DVD Case x 100 @ 0.30',-30,1,'',0);
INSERT INTO `gltrans` VALUES (147,20,40,0,'2014-01-13',26,'1460','BINGO - Average Cost Adj - DVD-CASE x 100 x 0.5',50,1,'',0);
INSERT INTO `gltrans` VALUES (148,20,40,0,'2014-01-13',26,'2310','BINGO - Inv 2100 Australian GST 10.00% USD5 @ exch rate 1.00000000',5,1,'',0);
INSERT INTO `gltrans` VALUES (149,20,40,0,'2014-01-13',26,'2100','BINGO - Inv 2100 USD55.00 @ a rate of 1.00000000',-55,1,'',0);
INSERT INTO `gltrans` VALUES (150,25,55,0,'2014-01-13',26,'1460','PO: 31 BINGO - DVD-CASE - webERP Demo DVD Case x 10 @ 0.80',8,1,'',0);
INSERT INTO `gltrans` VALUES (151,25,55,0,'2014-01-13',26,'2150','PO1389596314: 31 BINGO - DVD-CASE - webERP Demo DVD Case x 10 @ 0.80',-8,1,'',0);
INSERT INTO `gltrans` VALUES (152,20,41,0,'2014-01-13',26,'1460','BINGO - Average Cost Adj - DVD-CASE x 110 x 0.1',1,1,'',0);
INSERT INTO `gltrans` VALUES (153,20,41,0,'2014-01-13',26,'2310','BINGO - Inv 1223 Australian GST 10.00% USD0.1 @ exch rate 1.00000000',0.1,1,'',0);
INSERT INTO `gltrans` VALUES (154,20,41,0,'2014-01-13',26,'2100','BINGO - Inv 1223 USD1.10 @ a rate of 1.00000000',-1.1,1,'',0);
INSERT INTO `gltrans` VALUES (155,25,56,0,'2014-01-13',26,'1460','PO: 32 BINGO - DVD-CASE - webERP Demo DVD Case x 100 @ 0.81',80.91,1,'',0);
INSERT INTO `gltrans` VALUES (156,25,56,0,'2014-01-13',26,'2150','PO1389596457: 32 BINGO - DVD-CASE - webERP Demo DVD Case x 100 @ 0.81',-80.91,1,'',0);
INSERT INTO `gltrans` VALUES (157,20,42,0,'2014-01-13',26,'1460','BINGO - Average Cost Adj - DVD-CASE x 210 x 0.31',31,1,'',0);
INSERT INTO `gltrans` VALUES (158,20,42,0,'2014-01-13',26,'2310','BINGO - Inv 23001 Australian GST 10.00% USD3.1 @ exch rate 1.00000000',3.1,1,'',0);
INSERT INTO `gltrans` VALUES (159,20,42,0,'2014-01-13',26,'2100','BINGO - Inv 23001 USD34.10 @ a rate of 1.00000000',-34.1,1,'',0);
INSERT INTO `gltrans` VALUES (160,35,25,0,'2014-01-14',26,'5700','DVD-CASE cost was 0.9567 changed to 1 x Quantity on hand of 210',-9.093,1,'',0);
INSERT INTO `gltrans` VALUES (161,35,25,0,'2014-01-14',26,'1460','DVD-CASE cost was 0.9567 changed to 1 x Quantity on hand of 210',9.093,1,'',0);
INSERT INTO `gltrans` VALUES (162,35,26,0,'2014-01-14',26,'5700','DVD_ACTION cost was 68.5700 changed to 22.02 x Quantity on hand of 1',46.55,1,'',0);
INSERT INTO `gltrans` VALUES (163,35,26,0,'2014-01-14',26,'1460','DVD_ACTION cost was 68.5700 changed to 22.02 x Quantity on hand of 1',-46.55,1,'',0);
INSERT INTO `gltrans` VALUES (164,25,57,0,'2014-01-14',26,'1460','PO: 33 BINGO - DVD-CASE - webERP Demo DVD Case x 100 @ 1.00',100,1,'',0);
INSERT INTO `gltrans` VALUES (165,25,57,0,'2014-01-14',26,'2150','PO1389681160: 33 BINGO - DVD-CASE - webERP Demo DVD Case x 100 @ 1.00',-100,1,'',0);
INSERT INTO `gltrans` VALUES (166,20,43,0,'2014-01-14',26,'5000','BINGO - GRN 8 - DVD-CASE x 1 x  price var of 1.5',1.5,1,'',0);
INSERT INTO `gltrans` VALUES (167,20,43,0,'2014-01-14',26,'2310','BINGO - Inv tedt555 Australian GST 10.00% USD0.15 @ exch rate 1.00000000',0.15,1,'',0);
INSERT INTO `gltrans` VALUES (168,20,43,0,'2014-01-14',26,'2100','BINGO - Inv tedt555 USD1.65 @ a rate of 1.00000000',-1.65,1,'',0);
INSERT INTO `gltrans` VALUES (169,20,44,0,'2014-01-13',26,'5000','BINGO - GRN 8 - DVD-CASE x 1 x  price var of 1.5',1.5,1,'',0);
INSERT INTO `gltrans` VALUES (170,20,44,0,'2014-01-13',26,'2310','BINGO - Inv 2133 Australian GST 10.00% USD0.15 @ exch rate 1.00000000',0.15,1,'',0);
INSERT INTO `gltrans` VALUES (171,20,44,0,'2014-01-13',26,'2100','BINGO - Inv 2133 USD1.65 @ a rate of 1.00000000',-1.65,1,'',0);
INSERT INTO `gltrans` VALUES (172,20,45,0,'2014-01-13',26,'2150','BINGO - GRN 8 - DVD-CASE x 1 @  std cost of 1',1,1,'',0);
INSERT INTO `gltrans` VALUES (173,20,45,0,'2014-01-13',26,'5000','BINGO - GRN 8 - DVD-CASE x 1 x  price var of 1',1,1,'',0);
INSERT INTO `gltrans` VALUES (174,20,45,0,'2014-01-13',26,'2310','BINGO - Inv 211 Australian GST 10.00% USD0.2 @ exch rate 1.00000000',0.2,1,'',0);
INSERT INTO `gltrans` VALUES (175,20,45,0,'2014-01-13',26,'2100','BINGO - Inv 211 USD2.20 @ a rate of 1.00000000',-2.2,1,'',0);
INSERT INTO `gltrans` VALUES (176,1,5,0,'2014-02-03',27,'6600','Some other selling cost',10.250000003856004,1,'',0);
INSERT INTO `gltrans` VALUES (177,1,5,0,'2014-02-03',27,'7090','some benefit',95.250000035814,1,'',0);
INSERT INTO `gltrans` VALUES (178,1,5,0,'2014-02-03',27,'1030','Test narrative',-105.50000003967,1,'',0);
INSERT INTO `gltrans` VALUES (179,1,6,0,'2014-02-03',27,'5600','fregt',100,1,'',0);
INSERT INTO `gltrans` VALUES (180,1,6,0,'2014-02-03',27,'1350','advanv',25,1,'',0);
INSERT INTO `gltrans` VALUES (181,1,6,0,'2014-02-03',27,'1060','213 2221',-125,1,'',0);
INSERT INTO `gltrans` VALUES (182,1,7,0,'2014-07-05',32,'1010','',10,1,'',0);
INSERT INTO `gltrans` VALUES (183,1,7,0,'2014-07-05',32,'1060','',-10,1,'',0);
INSERT INTO `gltrans` VALUES (184,25,58,0,'2014-07-26',32,'5500','PO: 34 WHYNOT - LABOUR - Labour item - Freddie x 2 @ 75.00',150,1,'',0);
INSERT INTO `gltrans` VALUES (185,25,58,0,'2014-07-26',32,'2150','PO1406335331: 34 WHYNOT - LABOUR - Labour item - Freddie x 2 @ 75.00',-150,1,'',0);
INSERT INTO `gltrans` VALUES (186,25,59,0,'2015-12-20',49,'1460','PO: 35 CRUISE - DVD-CASE - 2000 x DVD covers to something else x 2000 @ 1.00',2000,1,'',0);
INSERT INTO `gltrans` VALUES (187,25,59,0,'2015-12-20',49,'2150','PO1450567661: 35 CRUISE - DVD-CASE - 2000 x DVD covers to something else x 2000 @ 1.00',-2000,1,'',0);
INSERT INTO `gltrans` VALUES (188,25,10,0,'2015-12-20',49,'1460','GRN Reversal for PO: 35 CRUISE - DVD-CASE-2000 x DVD covers to something else x 2000 @ 1.00',-2000,1,'',0);
INSERT INTO `gltrans` VALUES (189,25,10,0,'2015-12-20',49,'2150','GRN Reversal PO: 35 CRUISE - DVD-CASE-2000 x DVD covers to something else x 2000 @ 1.00',2000,1,'',0);
INSERT INTO `gltrans` VALUES (190,11,1,0,'2017-01-23',62,'5000','ANGRY - BREAD x -3 @ 0.5625',-1.6875,1,'',0);
INSERT INTO `gltrans` VALUES (191,11,1,0,'2017-01-23',62,'1460','ANGRY - BREAD x -3 @ 0.5625',1.6875,1,'',0);
INSERT INTO `gltrans` VALUES (192,11,1,0,'2017-01-23',62,'4100','ANGRY - BREAD x -3 @ 3.91',11.73,1,'',0);
INSERT INTO `gltrans` VALUES (193,11,1,0,'2017-01-23',62,'1100','ANGRY',-13.178655,1,'',0);
INSERT INTO `gltrans` VALUES (194,11,1,0,'2017-01-23',62,'2300','ANGRY',0.5865,1,'',0);
INSERT INTO `gltrans` VALUES (195,11,1,0,'2017-01-23',62,'2300','ANGRY',0.862155,1,'',0);
INSERT INTO `gltrans` VALUES (196,12,5,0,'2017-01-23',62,'1030','Melbourne Counter Return 1',-13.18,1,'',0);
INSERT INTO `gltrans` VALUES (197,12,5,0,'2017-01-23',62,'1100','Melbourne Counter Return 1',13.18,1,'',0);

--
-- Dumping data for table `grns`
--

INSERT INTO `grns` VALUES (50,1,1,'DVD_ACTION','2013-01-06','Action Series Bundle',1,1,'BINGO',16.22,'');
INSERT INTO `grns` VALUES (51,2,3,'TAPE1','2013-02-09','DFR-12  DFR Tape per Keystone spec',100,0,'CRUISE',10,'');
INSERT INTO `grns` VALUES (52,3,5,'TAPE1','2013-02-09','DFR-12 - DFR Tape per Keystone spec',10,0,'CRUISE',10,'');
INSERT INTO `grns` VALUES (53,4,8,'','2013-10-05','Some item',1,1,'OTHER',45.938993017273,'');
INSERT INTO `grns` VALUES (54,5,9,'DVD-CASE','2014-01-13','webERP Demo DVD Case',100,100,'BINGO',0.3,'');
INSERT INTO `grns` VALUES (55,6,10,'DVD-CASE','2014-01-13','webERP Demo DVD Case',10,10,'BINGO',0.8,'');
INSERT INTO `grns` VALUES (56,7,11,'DVD-CASE','2014-01-13','webERP Demo DVD Case',100,100,'BINGO',0.8091,'');
INSERT INTO `grns` VALUES (57,8,12,'DVD-CASE','2014-01-14','webERP Demo DVD Case',100,3,'BINGO',1,'');
INSERT INTO `grns` VALUES (58,9,13,'LABOUR','2014-07-26','Labour item - Freddie',2,0,'WHYNOT',75,'');

--
-- Dumping data for table `holdreasons`
--

INSERT INTO `holdreasons` VALUES (1,'Good History',0);
INSERT INTO `holdreasons` VALUES (20,'Watch',2);
INSERT INTO `holdreasons` VALUES (51,'In liquidation',1);

--
-- Dumping data for table `internalstockcatrole`
--

INSERT INTO `internalstockcatrole` VALUES ('AIRCON',8);
INSERT INTO `internalstockcatrole` VALUES ('BAKE',8);
INSERT INTO `internalstockcatrole` VALUES ('FOOD',8);

--
-- Dumping data for table `jnltmpldetails`
--


--
-- Dumping data for table `jnltmplheader`
--


--
-- Dumping data for table `labelfields`
--

INSERT INTO `labelfields` VALUES (1,1,'itemcode',10,10,10,1);
INSERT INTO `labelfields` VALUES (2,1,'itemcode',20,10,10,0);
INSERT INTO `labelfields` VALUES (3,1,'itemdescription',35,10,8,0);

--
-- Dumping data for table `labels`
--

INSERT INTO `labels` VALUES (1,'Test',210,297,0,0,5,10,0,0);

--
-- Dumping data for table `lastcostrollup`
--


--
-- Dumping data for table `locations`
--

INSERT INTO `locations` VALUES ('AN','Anaheim',' ','','','','','United States','','','','Brett',1,'',0,'',0,1,'',1);
INSERT INTO `locations` VALUES ('MEL','Melbourne','1234 Collins Street','Melbourne','Victoria 2345','','2345','Australia','+(61) (3) 5678901','+61 3 56789013','jacko@webdemo.com','Jack Roberts',1,'ANGRY',0,'ANGRY',1,1,'',1);
INSERT INTO `locations` VALUES ('TOR','Toronto','Level 100 ','CN Tower','Toronto','','','','','','','Clive Contrary',1,'',1,'',1,1,'',1);

--
-- Dumping data for table `locationusers`
--

INSERT INTO `locationusers` VALUES ('AN','admin',1,1);
INSERT INTO `locationusers` VALUES ('MEL','admin',1,1);
INSERT INTO `locationusers` VALUES ('MEL','WEB0000017',1,1);
INSERT INTO `locationusers` VALUES ('TOR','admin',1,1);
INSERT INTO `locationusers` VALUES ('TOR','WEB0000017',1,1);

--
-- Dumping data for table `locstock`
--

INSERT INTO `locstock` VALUES ('AN','BIGEARS12',0,0,'');
INSERT INTO `locstock` VALUES ('AN','BirthdayCakeConstruc',0,0,'');
INSERT INTO `locstock` VALUES ('AN','BREAD',2,0,'');
INSERT INTO `locstock` VALUES ('AN','CUTTING',0,0,'');
INSERT INTO `locstock` VALUES ('AN','DR_TUMMY',0,0,'');
INSERT INTO `locstock` VALUES ('AN','DVD-CASE',0,0,'');
INSERT INTO `locstock` VALUES ('AN','DVD-DHWV',0,0,'');
INSERT INTO `locstock` VALUES ('AN','DVD-LTWP',0,0,'');
INSERT INTO `locstock` VALUES ('AN','DVD-TOPGUN',0,0,'');
INSERT INTO `locstock` VALUES ('AN','DVD-UNSG',0,0,'');
INSERT INTO `locstock` VALUES ('AN','DVD-UNSG2',0,0,'');
INSERT INTO `locstock` VALUES ('AN','DVD_ACTION',0,0,'');
INSERT INTO `locstock` VALUES ('AN','FLOUR',0,0,'');
INSERT INTO `locstock` VALUES ('AN','FREIGHT',0,0,'');
INSERT INTO `locstock` VALUES ('AN','FROAYLANDO',0,0,'');
INSERT INTO `locstock` VALUES ('AN','FUJI990101',0,0,'');
INSERT INTO `locstock` VALUES ('AN','FUJI990102',0,0,'');
INSERT INTO `locstock` VALUES ('AN','FUJI9901ASS',0,0,'');
INSERT INTO `locstock` VALUES ('AN','HIT3042-4',0,0,'');
INSERT INTO `locstock` VALUES ('AN','HIT3043-5',0,0,'');
INSERT INTO `locstock` VALUES ('AN','LABOUR',0,0,'');
INSERT INTO `locstock` VALUES ('AN','PAYTSURCHARGE',0,0,'');
INSERT INTO `locstock` VALUES ('AN','SALT',-1.5,0,'');
INSERT INTO `locstock` VALUES ('AN','SELLTAPE',0,0,'');
INSERT INTO `locstock` VALUES ('AN','SLICE',0,0,'');
INSERT INTO `locstock` VALUES ('AN','STROD34',0,0,'');
INSERT INTO `locstock` VALUES ('AN','TAPE1',-24.4,0,'');
INSERT INTO `locstock` VALUES ('AN','TAPE2',86.5,0,'');
INSERT INTO `locstock` VALUES ('AN','Test123',0,0,'');
INSERT INTO `locstock` VALUES ('AN','TESTSERIALITEM',0,0,'');
INSERT INTO `locstock` VALUES ('AN','YEAST',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','BIGEARS12',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','BirthdayCakeConstruc',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','BREAD',3,0,'Y63');
INSERT INTO `locstock` VALUES ('MEL','CUTTING',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','DR_TUMMY',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','DVD-CASE',310,0,'4T2');
INSERT INTO `locstock` VALUES ('MEL','DVD-DHWV',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','DVD-LTWP',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','DVD-TOPGUN',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','DVD-UNSG',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','DVD-UNSG2',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','DVD_ACTION',1,0,'');
INSERT INTO `locstock` VALUES ('MEL','FLOUR',0,0,'4D2');
INSERT INTO `locstock` VALUES ('MEL','FREIGHT',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','FROAYLANDO',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','FUJI990101',0,0,'3D2');
INSERT INTO `locstock` VALUES ('MEL','FUJI990102',0,0,'2D2');
INSERT INTO `locstock` VALUES ('MEL','FUJI9901ASS',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','HIT3042-4',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','HIT3043-5',6,0,'');
INSERT INTO `locstock` VALUES ('MEL','LABOUR',2,0,'');
INSERT INTO `locstock` VALUES ('MEL','PAYTSURCHARGE',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','SALT',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','SELLTAPE',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','SLICE',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','STROD34',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','TAPE1',110,0,'');
INSERT INTO `locstock` VALUES ('MEL','TAPE2',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','Test123',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','TESTSERIALITEM',0,0,'');
INSERT INTO `locstock` VALUES ('MEL','YEAST',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','BIGEARS12',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','BirthdayCakeConstruc',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','BREAD',-12,0,'Z41');
INSERT INTO `locstock` VALUES ('TOR','CUTTING',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','DR_TUMMY',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','DVD-CASE',0,0,'3G6');
INSERT INTO `locstock` VALUES ('TOR','DVD-DHWV',-9,0,'');
INSERT INTO `locstock` VALUES ('TOR','DVD-LTWP',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','DVD-TOPGUN',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','DVD-UNSG',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','DVD-UNSG2',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','DVD_ACTION',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','FLOUR',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','FREIGHT',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','FROAYLANDO',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','FUJI990101',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','FUJI990102',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','FUJI9901ASS',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','HIT3042-4',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','HIT3043-5',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','LABOUR',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','PAYTSURCHARGE',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','SALT',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','SELLTAPE',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','SLICE',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','STROD34',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','TAPE1',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','TAPE2',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','Test123',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','TESTSERIALITEM',0,0,'');
INSERT INTO `locstock` VALUES ('TOR','YEAST',0,0,'');

--
-- Dumping data for table `loctransfercancellations`
--


--
-- Dumping data for table `loctransfers`
--


--
-- Dumping data for table `mailgroupdetails`
--


--
-- Dumping data for table `mailgroups`
--

INSERT INTO `mailgroups` VALUES (1,'ChkListingRecipients');
INSERT INTO `mailgroups` VALUES (4,'InventoryValuationRecipients');
INSERT INTO `mailgroups` VALUES (3,'OffersReceivedResultRecipients');
INSERT INTO `mailgroups` VALUES (2,'SalesAnalysisReportRecipients');

--
-- Dumping data for table `manufacturers`
--

INSERT INTO `manufacturers` VALUES (1,'Sony Entertainment','http://www.sony.com','companies/weberpdemo/part_pics/BRAND-3.jpg');
INSERT INTO `manufacturers` VALUES (2,'20th Century Fox','http://www.foxmovies.com/','companies/weberpdemo/part_pics/BRAND-3.jpg');
INSERT INTO `manufacturers` VALUES (3,'Fujitsu','http://www.fujitsu.com','companies/weberpdemo/part_pics/BRAND-3.jpg');
INSERT INTO `manufacturers` VALUES (4,'Hitachi','http://www.hitachi.com','');

--
-- Dumping data for table `mrpcalendar`
--


--
-- Dumping data for table `mrpdemands`
--


--
-- Dumping data for table `mrpdemandtypes`
--

INSERT INTO `mrpdemandtypes` VALUES ('FOR','Forecast');

--
-- Dumping data for table `mrpplannedorders`
--

INSERT INTO `mrpplannedorders` VALUES (1,'CUTTING','2013-02-09',5,'WO',31,'2013-02-09',0);
INSERT INTO `mrpplannedorders` VALUES (2,'CUTTING','2013-02-27',25,'WO',30,'2013-02-27',0);
INSERT INTO `mrpplannedorders` VALUES (3,'CUTTING','2014-08-02',2,'SO',8,'2014-08-02',0);
INSERT INTO `mrpplannedorders` VALUES (4,'DVD-DHWV','2013-06-20',1,'SO',2,'2013-06-20',0);
INSERT INTO `mrpplannedorders` VALUES (5,'DVD-DHWV','2014-09-05',9,'REORD',1,'2014-09-05',0);
INSERT INTO `mrpplannedorders` VALUES (6,'DVD-LTWP','2013-06-24',1,'SO',5,'2013-06-24',0);
INSERT INTO `mrpplannedorders` VALUES (7,'SALT','2012-12-16',0.05,'WO',28,'2012-12-16',0);
INSERT INTO `mrpplannedorders` VALUES (8,'SALT','2013-02-06',0.25,'WO',29,'2013-02-06',0);
INSERT INTO `mrpplannedorders` VALUES (9,'SALT','2013-07-21',2,'WO',32,'2013-07-21',0);
INSERT INTO `mrpplannedorders` VALUES (10,'SALT','2014-09-08',1.5,'REORD',1,'2014-09-08',0);
INSERT INTO `mrpplannedorders` VALUES (11,'YEAST','2012-12-16',0.2,'WO',28,'2012-12-16',0);
INSERT INTO `mrpplannedorders` VALUES (12,'YEAST','2013-02-06',1,'WO',29,'2013-02-06',0);
INSERT INTO `mrpplannedorders` VALUES (13,'DVD-TOPGUN','2013-06-24',1,'SO',3,'2013-06-24',0);
INSERT INTO `mrpplannedorders` VALUES (14,'DVD-TOPGUN','2013-06-24',1,'SO',4,'2013-06-24',0);
INSERT INTO `mrpplannedorders` VALUES (15,'PAYTSURCHARGE','2013-06-24',1,'SO',3,'2013-06-24',0);
INSERT INTO `mrpplannedorders` VALUES (16,'PAYTSURCHARGE','2013-06-24',1,'SO',4,'2013-06-24',0);
INSERT INTO `mrpplannedorders` VALUES (17,'PAYTSURCHARGE','2013-06-24',1,'SO',5,'2013-06-24',0);

--
-- Dumping data for table `offers`
--

INSERT INTO `offers` VALUES (1,0,'BINGO','BREAD',5,'each',0.95,'2011-10-24','USD');

--
-- Dumping data for table `orderdeliverydifferenceslog`
--


--
-- Dumping data for table `paymentmethods`
--

INSERT INTO `paymentmethods` VALUES (1,'Cheque',1,1,1,0,0);
INSERT INTO `paymentmethods` VALUES (2,'Cash',1,1,0,0,0.25);
INSERT INTO `paymentmethods` VALUES (3,'Direct Credit',1,1,0,0,0);

--
-- Dumping data for table `paymentterms`
--

INSERT INTO `paymentterms` VALUES ('20','Due 20th Of the Following Month',0,22);
INSERT INTO `paymentterms` VALUES ('30','Due By End Of The Following Month',0,30);
INSERT INTO `paymentterms` VALUES ('7','Payment due within 7 days',7,0);
INSERT INTO `paymentterms` VALUES ('CA','Cash Only',1,0);

--
-- Dumping data for table `pcashdetails`
--


--
-- Dumping data for table `pcashdetailtaxes`
--


--
-- Dumping data for table `pcexpenses`
--


--
-- Dumping data for table `pcreceipts`
--


--
-- Dumping data for table `pctabexpenses`
--


--
-- Dumping data for table `pctabs`
--

INSERT INTO `pctabs` VALUES ('test','admin','Default','AUD',85,'admin','admin','admin','1030','7610',0,1);

--
-- Dumping data for table `pctypetabs`
--

INSERT INTO `pctypetabs` VALUES ('Default','Default');

--
-- Dumping data for table `periods`
--

INSERT INTO `periods` VALUES (14,'2013-01-31');
INSERT INTO `periods` VALUES (15,'2013-02-28');
INSERT INTO `periods` VALUES (16,'2013-03-31');
INSERT INTO `periods` VALUES (17,'2013-04-30');
INSERT INTO `periods` VALUES (18,'2013-05-31');
INSERT INTO `periods` VALUES (19,'2013-06-30');
INSERT INTO `periods` VALUES (20,'2013-07-31');
INSERT INTO `periods` VALUES (21,'2013-08-31');
INSERT INTO `periods` VALUES (22,'2013-09-30');
INSERT INTO `periods` VALUES (23,'2013-10-31');
INSERT INTO `periods` VALUES (24,'2013-11-30');
INSERT INTO `periods` VALUES (25,'2013-12-31');
INSERT INTO `periods` VALUES (26,'2014-01-31');
INSERT INTO `periods` VALUES (27,'2014-02-28');
INSERT INTO `periods` VALUES (28,'2014-03-31');
INSERT INTO `periods` VALUES (29,'2014-04-30');
INSERT INTO `periods` VALUES (30,'2014-05-31');
INSERT INTO `periods` VALUES (31,'2014-06-30');
INSERT INTO `periods` VALUES (32,'2014-07-31');
INSERT INTO `periods` VALUES (33,'2014-08-31');
INSERT INTO `periods` VALUES (34,'2014-09-30');
INSERT INTO `periods` VALUES (35,'2014-10-31');
INSERT INTO `periods` VALUES (36,'2014-11-30');
INSERT INTO `periods` VALUES (37,'2014-12-31');
INSERT INTO `periods` VALUES (38,'2015-01-31');
INSERT INTO `periods` VALUES (39,'2015-02-28');
INSERT INTO `periods` VALUES (40,'2015-03-31');
INSERT INTO `periods` VALUES (41,'2015-04-30');
INSERT INTO `periods` VALUES (42,'2015-05-31');
INSERT INTO `periods` VALUES (43,'2015-06-30');
INSERT INTO `periods` VALUES (44,'2015-07-31');
INSERT INTO `periods` VALUES (45,'2015-08-31');
INSERT INTO `periods` VALUES (46,'2015-09-30');
INSERT INTO `periods` VALUES (47,'2015-10-31');
INSERT INTO `periods` VALUES (48,'2015-11-30');
INSERT INTO `periods` VALUES (49,'2015-12-31');
INSERT INTO `periods` VALUES (50,'2016-01-31');
INSERT INTO `periods` VALUES (51,'2016-02-29');
INSERT INTO `periods` VALUES (52,'2016-03-31');
INSERT INTO `periods` VALUES (53,'2016-04-30');
INSERT INTO `periods` VALUES (54,'2016-05-31');
INSERT INTO `periods` VALUES (55,'2016-06-30');
INSERT INTO `periods` VALUES (56,'2016-07-31');
INSERT INTO `periods` VALUES (57,'2016-08-31');
INSERT INTO `periods` VALUES (58,'2016-09-30');
INSERT INTO `periods` VALUES (59,'2016-10-31');
INSERT INTO `periods` VALUES (60,'2016-11-30');
INSERT INTO `periods` VALUES (61,'2016-12-31');
INSERT INTO `periods` VALUES (62,'2017-01-31');
INSERT INTO `periods` VALUES (63,'2017-02-28');
INSERT INTO `periods` VALUES (64,'2017-03-31');
INSERT INTO `periods` VALUES (65,'2017-04-30');
INSERT INTO `periods` VALUES (66,'2017-05-31');
INSERT INTO `periods` VALUES (67,'2017-06-30');
INSERT INTO `periods` VALUES (68,'2017-07-31');
INSERT INTO `periods` VALUES (69,'2017-08-31');
INSERT INTO `periods` VALUES (70,'2017-09-30');
INSERT INTO `periods` VALUES (71,'2017-10-31');
INSERT INTO `periods` VALUES (72,'2017-11-30');
INSERT INTO `periods` VALUES (73,'2017-12-31');
INSERT INTO `periods` VALUES (74,'2018-01-31');
INSERT INTO `periods` VALUES (75,'2018-02-28');
INSERT INTO `periods` VALUES (76,'2018-03-31');
INSERT INTO `periods` VALUES (77,'2018-04-30');
INSERT INTO `periods` VALUES (78,'2018-05-31');
INSERT INTO `periods` VALUES (79,'2018-06-30');
INSERT INTO `periods` VALUES (80,'2018-07-31');
INSERT INTO `periods` VALUES (81,'2018-08-31');
INSERT INTO `periods` VALUES (82,'2018-09-30');
INSERT INTO `periods` VALUES (83,'2018-10-31');
INSERT INTO `periods` VALUES (84,'2018-11-30');

--
-- Dumping data for table `pickinglistdetails`
--


--
-- Dumping data for table `pickinglists`
--


--
-- Dumping data for table `pickreq`
--


--
-- Dumping data for table `pickreqdetails`
--


--
-- Dumping data for table `pickserialdetails`
--


--
-- Dumping data for table `pricematrix`
--


--
-- Dumping data for table `prices`
--

INSERT INTO `prices` VALUES ('BIGEARS12','DE','AUD','',4428.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('BirthdayCakeConstruc','DE','AUD','',1476.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('BREAD','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('CUTTING','DE','USD','',50.0000,'','2013-06-29','9999-12-31');
INSERT INTO `prices` VALUES ('DR_TUMMY','DE','AUD','',246.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('DVD-CASE','DE','AUD','',124.5000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('DVD-CASE','DE','GBP','DUMBLE',52.6500,'DUMBLE','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('DVD-DHWV','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('DVD-DHWV','DE','USD','',10.5000,'','2013-01-27','9999-12-31');
INSERT INTO `prices` VALUES ('DVD-LTWP','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('DVD-LTWP','DE','USD','',7.4900,'','2013-04-27','9999-12-31');
INSERT INTO `prices` VALUES ('DVD-TOPGUN','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('DVD-TOPGUN','DE','USD','',12.2500,'','2013-04-27','9999-12-31');
INSERT INTO `prices` VALUES ('DVD-UNSG','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('DVD-UNSG2','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('DVD_ACTION','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('FLOUR','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('FUJI990101','DE','AUD','',1353.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('FUJI990102','DE','AUD','',861.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('HIT3042-4','DE','AUD','',1107.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('HIT3043-5','DE','AUD','',1599.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('HIT3043-5','DE','USD','',2300.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('LABOUR','DE','USD','',150.0000,'','2014-07-26','9999-12-31');
INSERT INTO `prices` VALUES ('SALT','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('SLICE','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');
INSERT INTO `prices` VALUES ('TAPE1','DE','USD','',17.5000,'','2013-02-08','9999-12-31');
INSERT INTO `prices` VALUES ('YEAST','DE','AUD','',123.0000,'','1999-01-01','9999-12-31');

--
-- Dumping data for table `prodspecs`
--


--
-- Dumping data for table `purchdata`
--

INSERT INTO `purchdata` VALUES ('BINGO','DVD-CASE',1000.5900,'10,000',10000,'Mother load of DVD cases',1,1,'2011-03-26','',1);
INSERT INTO `purchdata` VALUES ('BINGO','DVD-DHWV',8.5000,'5 pack',5,'5 Pack Die Hard With Vengence',3,1,'2012-03-01','DHWV-5',1);
INSERT INTO `purchdata` VALUES ('BINGO','HIT3043-5',1235.0000,'',1,'',5,1,'2009-09-18','',1);
INSERT INTO `purchdata` VALUES ('CRUISE','DR_TUMMY',10.0000,'',1,'',10,1,'2016-10-19','',1);
INSERT INTO `purchdata` VALUES ('CRUISE','DVD-CASE',1151.2500,'2000 pack',2000,'2000 x DVD covers',50,0,'2011-06-26','coverx2000',1);
INSERT INTO `purchdata` VALUES ('CRUISE','DVD-UNSG2',200.0000,'10 Pack',10,'',5,1,'2009-09-18','',1);
INSERT INTO `purchdata` VALUES ('CRUISE','TAPE1',2.5000,'feet',1,'DFR Tape per Keystone spec',20,1,'2013-02-09','DFR-12',10);
INSERT INTO `purchdata` VALUES ('GOTSTUFF','BREAD',1.5800,'',1,'Loaf of bread',1,1,'2011-10-08','',5);

--
-- Dumping data for table `purchorderauth`
--

INSERT INTO `purchorderauth` VALUES ('admin','AUD',0,50000,0);
INSERT INTO `purchorderauth` VALUES ('admin','EUR',0,999999999,0);
INSERT INTO `purchorderauth` VALUES ('admin','GBP',0,9999999,0);
INSERT INTO `purchorderauth` VALUES ('admin','USD',0,9999999,0);

--
-- Dumping data for table `purchorderdetails`
--

INSERT INTO `purchorderdetails` VALUES (1,23,'DVD_ACTION','2013-01-06','Action Series Bundle','1460',1,50,52.35,16.22,1,1,0,'0',1,'each','',0,1);
INSERT INTO `purchorderdetails` VALUES (2,24,'DVD-CASE','2013-02-10','  Mother load of DVD cases','1460',0,1000.59,0,0,0,0,0,'',1,'10,000','',0,10000);
INSERT INTO `purchorderdetails` VALUES (3,25,'TAPE1','2013-03-01','DFR-12  DFR Tape per Keystone spec','1460',0,2.5,0,10,100,100,0,'',1,'feet','DFR-12',0,1);
INSERT INTO `purchorderdetails` VALUES (4,26,'BREAD','2013-02-10','  Loaf of bread','1460',0,1.58,0,0,10,0,0,'',1,'','',0,1);
INSERT INTO `purchorderdetails` VALUES (5,27,'TAPE1','2013-03-01','DFR-12 - DFR Tape per Keystone spec','1460',0,2.5,0,10,10,10,0,'0',1,'feet','DFR-12',0,1);
INSERT INTO `purchorderdetails` VALUES (6,28,'DVD-CASE','2013-06-20','coverx2000 - 2000 x DVD covers','1460',0,0.575625,0,0,4000,0,0,'0',0,'2000 pack','coverx2000',0,2000);
INSERT INTO `purchorderdetails` VALUES (7,24,'','2013-02-09','Some other thing','7630',0,0.65,0,0,25,0,0,'',0,'each','',0,1);
INSERT INTO `purchorderdetails` VALUES (8,29,'','2013-10-05','Some item','1',1,50,55,45.938993017273,1,1,0,'',0,'each','',0,1);
INSERT INTO `purchorderdetails` VALUES (9,30,'DVD-CASE','2014-01-13','webERP Demo DVD Case','1460',100,0.5,0.5,0.3,100,100,0,'',0,'10,000','',0,1);
INSERT INTO `purchorderdetails` VALUES (10,31,'DVD-CASE','2014-01-13','webERP Demo DVD Case','1460',10,0.1,0.1,0.8,10,10,0,'',0,'10,000','',0,1);
INSERT INTO `purchorderdetails` VALUES (11,32,'DVD-CASE','2014-01-13','webERP Demo DVD Case','1460',100,0.5,0.31,0.8091,100,100,0,'',0,'10,000','',0,1);
INSERT INTO `purchorderdetails` VALUES (12,33,'DVD-CASE','2014-01-14','webERP Demo DVD Case','1460',3,1.5,2,1,100,100,0,'',0,'10,000','',0,1);
INSERT INTO `purchorderdetails` VALUES (13,34,'LABOUR','2014-07-26','Labour item - Freddie','5500',0,5.9,0,75,2,2,0,'0',0,'each','',0,1);
INSERT INTO `purchorderdetails` VALUES (14,35,'DVD-CASE','2016-02-08','2000 x DVD covers to something else','1460',0,0.575625,0,1,2000,0,0,'0',0,'2000 pack','coverx2000',0,2000);
INSERT INTO `purchorderdetails` VALUES (15,36,'DVD-DHWV','2016-10-22','DHWV-5  5 Pack Die Hard With Vengence','1460',0,8.5,0,0,0,0,0,'',0,'5 pack','DHWV-5',0,5);
INSERT INTO `purchorderdetails` VALUES (16,37,'DR_TUMMY','2016-10-30','  ','1460',0,10,0,0,51,0,0,'',0,'','',0,1);

--
-- Dumping data for table `purchorders`
--

INSERT INTO `purchorders` VALUES (23,'BINGO','','2013-01-06 00:00:00',1,NULL,1,'admin','','MEL','1234 Collins Street','Melbourne','Victoria 2345','','','+61 3 56789012','+61 3 56789012','Box 3499','Gardenier','San Fransisco','California 54424','','US','','','Jack Roberts',2.00,'2013-02-09','','1','2013-01-06','Completed','09/02/2013 - Order Completed on entry of GRN<br />09/02/2013 - Order modified by <a href=\"mailto:info@weberp.org\">Demonstration user</a><br />','30','');
INSERT INTO `purchorders` VALUES (24,'BINGO','','2013-02-09 00:00:00',1,NULL,1,'Demonstration user','','MEL','Melbourne','1234 Collins Street','Melbourne','Victoria 2345','','+61 3 56789012','+61 3 56789012','Box 3499','Gardenier','San Fransisco','California 54424','','US','','','',2.00,'2013-06-11','','1','2013-02-09','Authorised','11/06/2013 - Order modified by &lt;a href=&quot;mailto:phil@logicworks.co.nz&quot;&gt;Demonstration user&lt;/a&gt;&lt;br /&gt;','30','');
INSERT INTO `purchorders` VALUES (25,'CRUISE','','2013-02-09 00:00:00',0.6324,NULL,1,'Demonstration user','','MEL','Melbourne','1234 Collins Street','Melbourne','Victoria 2345','','+61 3 56789012','+61 3 56789012','Box 2001','Ft Lauderdale, Florida','','','','','Barry Toad','','',2.00,'2013-02-09','','1','2013-02-09','Completed','09/02/2013 - Order Completed on entry of GRN<br />09/02/2013 - Order modified by <a href=\"mailto:info@weberp.org\">Demonstration user</a><br />','30','');
INSERT INTO `purchorders` VALUES (26,'GOTSTUFF',NULL,'2013-02-09 00:00:00',1,NULL,0,'Demonstration user',NULL,'MEL','Melbourne','1234 Collins Street','Melbourne','Victoria 2345','',' Australia','+61 3 56789012','Test line 1','Test line 2','Test line 3','Test line 4 - editing','','','','','',1.00,'2013-02-09','','1','2013-02-09','Cancelled','28/05/2013 - Cancelled by <a href=\"mailto:phil@logicworks.co.nz\">Demonstration user</a><br />28/05/2013 - Authorised by <a href=\"mailto:phil@logicworks.co.nz\">Demonstration user</a><br />28/05/2013 - Order set to pending status by <a href=\"mailto:phil@logicworks.co.nz\">Demonstration user</a><br />09/02/2013 - Authorised by <a href=\"mailto:info@weberp.org\">Demonstration user</a><br />09/02/2013 - Order Created by  <a href=\"mailto:info@weberp.org\">Demonstration user</a> - Auto created from sales orders<br />','20','');
INSERT INTO `purchorders` VALUES (27,'CRUISE','','2013-02-09 00:00:00',0.6324,'2013-02-09 00:00:00',0,'admin','','MEL','1234 Collins Street','Melbourne','Victoria 2345','','','Australia','+61 3 56789012','Box 2001','Ft Lauderdale, Florida','','','','','Barry Toad','','Jack Roberts',1.00,'2013-02-09','','1','2013-02-09','Printed','09/02/2013 - Printed by &lt;a href=&quot;mailto:info@weberp.org&quot;&gt;Demonstration user&lt;/a&gt;&lt;br /&gt;09/02/2013 - Order Created and Authorised by &lt;a href=&quot;mailto:info@weberp.org&quot;&gt;Demonstration user&lt;/a&gt;&lt;br /&gt;&lt;br /&gt;','30','');
INSERT INTO `purchorders` VALUES (28,'CRUISE','','2013-05-01 00:00:00',0.6432,NULL,1,'admin','','MEL','1234 Collins Street','Melbourne','Victoria 2345','','','Australia','+61 3 56789012','Box 2001','Ft Lauderdale, Florida','','','','','French Froggie','','Jack Roberts',1.00,'2013-05-01','','1','2013-05-01','Authorised','01/05/2013 - Order Created and Authorised by &lt;a href=&quot;mailto:phil@logicworks.co.nz&quot;&gt;Demonstration user&lt;/a&gt;&lt;br /&gt;&lt;br /&gt;','30','');
INSERT INTO `purchorders` VALUES (29,'OTHER','','2013-10-05 00:00:00',1.0884,NULL,1,'admin','','MEL','1234 Collins Street','Melbourne','Victoria 2345','','','Australia','+61 3 56789012','Supplier','','','','','','','','Jack Roberts',1.00,'2013-10-05','','1','2013-10-05','Completed','05/10/2013 - Order Completed on entry of GRN<br />05/10/2013 - Order Created and Authorised by <a href=\"mailto:admin@weberp.org\">Demonstration user</a><br /><br />','20','');
INSERT INTO `purchorders` VALUES (30,'BINGO','','2014-01-13 00:00:00',1,NULL,1,'admin','','MEL','1234 Collins Street','Melbourne','Victoria 2345','','2345','Australia','+(61) (3) 56789','Box 3499','Gardenier','San Fransisco','California 54424','','US','','','Jack Roberts',0.00,'2014-01-13','','','2014-01-13','Completed','13/01/2014 - Order Completed on entry of GRN<br />13/01/2014 - Order Created and Authorised by <a href=\"mailto:admin@weberp.org\">Demonstration user</a><br /><br />','30','');
INSERT INTO `purchorders` VALUES (31,'BINGO','','2014-01-13 00:00:00',1,NULL,1,'admin','','MEL','1234 Collins Street','Melbourne','Victoria 2345','','2345','Australia','+(61) (3) 56789','Box 3499','Gardenier','San Fransisco','California 54424','','US','','','Jack Roberts',0.00,'2014-01-13','','','2014-01-13','Completed','13/01/2014 - Order Completed on entry of GRN<br />13/01/2014 - Order Created and Authorised by <a href=\"mailto:admin@weberp.org\">Demonstration user</a><br /><br />','30','');
INSERT INTO `purchorders` VALUES (32,'BINGO','','2014-01-13 00:00:00',1,NULL,1,'admin','','MEL','1234 Collins Street','Melbourne','Victoria 2345','','2345','Australia','+(61) (3) 56789','Box 3499','Gardenier','San Fransisco','California 54424','','US','','','Jack Roberts',0.00,'2014-01-13','','','2014-01-13','Completed','13/01/2014 - Order Completed on entry of GRN<br />13/01/2014 - Order Created and Authorised by <a href=\"mailto:admin@weberp.org\">Demonstration user</a><br /><br />','30','');
INSERT INTO `purchorders` VALUES (33,'BINGO','','2014-01-14 00:00:00',1,NULL,1,'admin','','MEL','1234 Collins Street','Melbourne','Victoria 2345','','2345','Australia','+(61) (3) 56789','Box 3499','Gardenier','San Fransisco','California 54424','','US','','','Jack Roberts',0.00,'2014-01-14','','','2014-01-14','Completed','14/01/2014 - Order Completed on entry of GRN<br />14/01/2014 - Order Created and Authorised by <a href=\"mailto:admin@weberp.org\">Demonstration user</a><br /><br />','30','');
INSERT INTO `purchorders` VALUES (34,'WHYNOT','','2014-07-26 00:00:00',1.0884,NULL,1,'admin','','MEL','1234 Collins Street','Melbourne','Victoria 2345','','2345','Australia','+(61) (3) 5678901','Well I will ','If I','Want ','To','','','','12323','Jack Roberts',1.00,'2014-07-26','','1','2014-07-26','Completed','26/07/2014 - Order Completed on entry of GRN<br />26/07/2014 - Order Created and Authorised by <a href=\"mailto:admin@weberp.org\">Demonstration user</a><br /><br />','20','');
INSERT INTO `purchorders` VALUES (35,'CRUISE','','2015-12-20 00:00:00',0.6715,NULL,1,'admin','','MEL','1234 Collins Street','Melbourne','Victoria 2345','','2345','Australia','+(61) (3) 5678901','Box 2001','Ft Lauderdale, Florida','','','','','Barry Toad','','Jack Roberts',1.00,'2015-12-20','','1','2015-12-20','Printed','20/12/2015 GRN Reversed for 2000 x DVD covers to something else by Demonstration user<br />20/12/2015 - Order Completed on entry of GRN<br />20/12/2015 - Order Created and Authorised by <a href=\"mailto:admin@weberp.org\">Demonstration user</a><br /><br />','30','');
INSERT INTO `purchorders` VALUES (36,'BINGO',NULL,'2016-10-19 00:00:00',1,NULL,0,'admin',NULL,'MEL','Melbourne','1234 Collins Street','Melbourne','Victoria 2345','','2345 Australia','+(61) (3) 5678901','Box 3499','Gardenier','San Fransisco','California 54424','','US','','','',1.00,'2016-10-19','','1','2016-10-19','Pending','19/10/2016 - Order Created by  <a href=\"mailto:admin@weberp.org\">Demonstration user</a> - Auto created from sales orders<br />','30','');
INSERT INTO `purchorders` VALUES (37,'CRUISE',NULL,'2016-10-20 00:00:00',0.8147,NULL,1,'admin',NULL,'MEL','Melbourne','1234 Collins Street','Melbourne','Victoria 2345','','2345 Australia','+(61) (3) 5678901','Box 2001','Ft Lauderdale, Florida','','','','','','','',1.00,'2016-10-20','','1','2016-10-20','Authorised','20/10/2016 - Order Created and Authorized by <a href=\"mailto:admin@weberp.org\">Demonstration user</a> - Auto created from sales orders<br />','30','');

--
-- Dumping data for table `qasamples`
--


--
-- Dumping data for table `qatests`
--


--
-- Dumping data for table `recurringsalesorders`
--


--
-- Dumping data for table `recurrsalesorderdetails`
--


--
-- Dumping data for table `relateditems`
--


--
-- Dumping data for table `reportcolumns`
--

INSERT INTO `reportcolumns` VALUES (1,1,'Value','',0,0,7,'Net Value',0,0,'',1,'N',0);
INSERT INTO `reportcolumns` VALUES (1,2,'Gross','Profit',0,0,14,'Gross Profit',0,0,'',1,'N',0);
INSERT INTO `reportcolumns` VALUES (2,1,'Cost','Dec',0,1,1,'Cost',0,0,'',1,'N',0);
INSERT INTO `reportcolumns` VALUES (2,2,'Qty','Dec',0,1,1,'Quantity',0,0,'',1,'N',0);

--
-- Dumping data for table `reportfields`
--

INSERT INTO `reportfields` VALUES (1803,135,'critlist',1,'prices.currabrev','Currency','0','0','0');
INSERT INTO `reportfields` VALUES (1802,135,'fieldlist',4,'prices.currabrev','Currency','1','1','0');
INSERT INTO `reportfields` VALUES (1801,135,'fieldlist',3,'prices.typeabbrev','Price List','1','1','0');
INSERT INTO `reportfields` VALUES (1800,135,'fieldlist',2,'prices.price','Price','1','1','0');
INSERT INTO `reportfields` VALUES (1799,135,'fieldlist',1,'stockmaster.stockid','Item','1','1','0');
INSERT INTO `reportfields` VALUES (1797,135,'trunclong',0,'','','1','1','0');
INSERT INTO `reportfields` VALUES (1798,135,'dateselect',0,'','','1','1','a');
INSERT INTO `reportfields` VALUES (1804,135,'sortlist',1,'stockmaster.stockid','Item','0','0','1');
INSERT INTO `reportfields` VALUES (1805,136,'critlist',1,'stockmoves.stockid','Item','0','0','0');
INSERT INTO `reportfields` VALUES (1806,136,'critlist',2,'stockmoves.debtorno','Customer','0','0','0');
INSERT INTO `reportfields` VALUES (1807,136,'dateselect',0,'stockmoves.trandate','ab','1','1','a');
INSERT INTO `reportfields` VALUES (1808,136,'fieldlist',1,'stockmoves.stockid','Item','1','1','0');
INSERT INTO `reportfields` VALUES (1809,136,'fieldlist',2,'debtorsmaster.name','Customer','1','1','0');
INSERT INTO `reportfields` VALUES (1810,136,'fieldlist',3,'stockmoves.branchcode','branch','1','1','0');
INSERT INTO `reportfields` VALUES (1811,136,'fieldlist',4,'systypes.typename','Type','1','1','0');
INSERT INTO `reportfields` VALUES (1812,136,'fieldlist',5,'stockmoves.trandate','Date','1','1','0');
INSERT INTO `reportfields` VALUES (1813,136,'fieldlist',6,'stockmoves.qty','Quantity','1','1','1');
INSERT INTO `reportfields` VALUES (1814,136,'grouplist',1,'stockmoves.debtorno','Customer','0','0','1');
INSERT INTO `reportfields` VALUES (1815,136,'grouplist',2,'stockmoves.stockid','Item','0','0','1');
INSERT INTO `reportfields` VALUES (1816,136,'grouplist',3,'stockmoves.trandate','Date','0','0','1');
INSERT INTO `reportfields` VALUES (1817,136,'sortlist',1,'stockmoves.stockid','Item','0','0','1');
INSERT INTO `reportfields` VALUES (1818,136,'sortlist',2,'stockmoves.debtorno','Customer','0','0','0');
INSERT INTO `reportfields` VALUES (1819,136,'sortlist',3,'stockmoves.trandate','trans date','0','0','0');
INSERT INTO `reportfields` VALUES (1820,136,'trunclong',0,'','','1','1','0');
INSERT INTO `reportfields` VALUES (1821,137,'critlist',1,'stockserialmoves.serialno','Serial No.','0','0','1');
INSERT INTO `reportfields` VALUES (1822,137,'dateselect',0,'','a','1','1','a');
INSERT INTO `reportfields` VALUES (1823,137,'fieldlist',1,'worequirements.wo','Work Order','1','1','0');
INSERT INTO `reportfields` VALUES (1824,137,'fieldlist',2,'worequirements.parentstockid','Parent_Item','1','1','0');
INSERT INTO `reportfields` VALUES (1825,137,'fieldlist',3,'worequirements.stockid','Item','1','1','0');
INSERT INTO `reportfields` VALUES (1826,137,'fieldlist',4,'stockserialmoves.serialno','Serial_No.','1','1','0');
INSERT INTO `reportfields` VALUES (1827,137,'fieldlist',5,'workorders.requiredby','Due_Date','1','1','0');
INSERT INTO `reportfields` VALUES (1828,137,'sortlist',1,'worequirements.wo','Work Order','0','0','1');
INSERT INTO `reportfields` VALUES (1829,137,'sortlist',2,'stockserialmoves.stockid','Item','0','0','1');
INSERT INTO `reportfields` VALUES (1830,137,'trunclong',0,'','','1','1','0');
INSERT INTO `reportfields` VALUES (1831,138,'critlist',1,'stockmoves.stockid','Item','0','0','0');
INSERT INTO `reportfields` VALUES (1832,138,'critlist',2,'stockmoves.debtorno','Customer','0','0','0');
INSERT INTO `reportfields` VALUES (1833,138,'critlist',3,'stockserialmoves.serialno','Serial Number','0','0','0');
INSERT INTO `reportfields` VALUES (1834,138,'dateselect',0,'stockmoves.trandate','ab','1','1','a');
INSERT INTO `reportfields` VALUES (1835,138,'fieldlist',1,'stockmoves.stockid','Item','1','1','0');
INSERT INTO `reportfields` VALUES (1836,138,'fieldlist',2,'debtorsmaster.name','Customer','1','1','0');
INSERT INTO `reportfields` VALUES (1837,138,'fieldlist',3,'stockmoves.branchcode','branch','1','1','0');
INSERT INTO `reportfields` VALUES (1838,138,'fieldlist',4,'systypes.typename','Type','1','1','0');
INSERT INTO `reportfields` VALUES (1839,138,'fieldlist',5,'stockmoves.trandate','Date','1','1','0');
INSERT INTO `reportfields` VALUES (1840,138,'fieldlist',6,'stockserialmoves.serialno','Serial Number','1','1','0');
INSERT INTO `reportfields` VALUES (1841,138,'grouplist',1,'stockmoves.debtorno','Customer','0','0','0');
INSERT INTO `reportfields` VALUES (1842,138,'grouplist',2,'stockmoves.stockid','Item','0','0','0');
INSERT INTO `reportfields` VALUES (1843,138,'grouplist',3,'stockmoves.trandate','Date','0','0','0');
INSERT INTO `reportfields` VALUES (1844,138,'sortlist',1,'stockmoves.stockid','Item','0','0','1');
INSERT INTO `reportfields` VALUES (1845,138,'sortlist',2,'stockmoves.debtorno','Customer','0','0','0');
INSERT INTO `reportfields` VALUES (1846,138,'sortlist',3,'stockmoves.trandate','trans date','0','0','0');
INSERT INTO `reportfields` VALUES (1847,138,'sortlist',4,'stockserialmoves.serialno','Serial Number','0','0','0');
INSERT INTO `reportfields` VALUES (1848,138,'trunclong',0,'','','1','1','1');
INSERT INTO `reportfields` VALUES (1849,139,'critlist',1,'stockserialitems.serialno','Serial No.','0','0','1');
INSERT INTO `reportfields` VALUES (1850,139,'dateselect',0,'','a','1','1','a');
INSERT INTO `reportfields` VALUES (1851,139,'fieldlist',1,'stockmoves.trandate','date','1','1','0');
INSERT INTO `reportfields` VALUES (1852,139,'fieldlist',2,'stockmoves.stkmoveno','move','1','1','0');
INSERT INTO `reportfields` VALUES (1853,139,'fieldlist',3,'stockserialitems.stockid','item','1','1','0');
INSERT INTO `reportfields` VALUES (1854,139,'fieldlist',4,'stockserialitems.serialno','Serial_No.','1','1','0');
INSERT INTO `reportfields` VALUES (1855,139,'fieldlist',5,'worequirements.wo','Work_Order','1','1','0');
INSERT INTO `reportfields` VALUES (1856,139,'sortlist',1,'stockmoves.stkmoveno','moves','0','0','1');
INSERT INTO `reportfields` VALUES (1857,139,'trunclong',0,'','','1','1','0');
INSERT INTO `reportfields` VALUES (1858,140,'critlist',1,'stockserialitems.serialno','Serial_No.','0','0','1');
INSERT INTO `reportfields` VALUES (1859,140,'dateselect',0,'','a','1','1','a');
INSERT INTO `reportfields` VALUES (1860,140,'fieldlist',1,'stockmoves.trandate','Date','1','1','0');
INSERT INTO `reportfields` VALUES (1861,140,'fieldlist',2,'stockmoves.stkmoveno','seq.','1','1','0');
INSERT INTO `reportfields` VALUES (1862,140,'fieldlist',3,'stockserialitems.serialno','Serial_No.','1','1','0');
INSERT INTO `reportfields` VALUES (1863,140,'fieldlist',4,'stockserialitems.stockid','Ident','1','1','0');
INSERT INTO `reportfields` VALUES (1864,140,'fieldlist',5,'worequirements.wo','Work_Order','1','1','0');
INSERT INTO `reportfields` VALUES (1865,140,'fieldlist',6,'stockmoves.loccode','loc','1','1','0');
INSERT INTO `reportfields` VALUES (1866,140,'fieldlist',7,'stockserialmoves.moveqty','change','1','1','0');
INSERT INTO `reportfields` VALUES (1867,140,'fieldlist',8,'stockserialitems.quantity','onhand','1','1','0');
INSERT INTO `reportfields` VALUES (1868,140,'sortlist',1,'stockmoves.stkmoveno','move','0','0','1');
INSERT INTO `reportfields` VALUES (1869,140,'sortlist',2,'stockserialitems.serialno','Serial_No.','0','0','1');
INSERT INTO `reportfields` VALUES (1870,140,'sortlist',3,'stockserialitems.stockid','Item','0','0','1');
INSERT INTO `reportfields` VALUES (1871,140,'trunclong',0,'','','1','1','0');
INSERT INTO `reportfields` VALUES (1872,141,'critlist',1,'workorders.closed','Closed','0','0','2');
INSERT INTO `reportfields` VALUES (1873,141,'dateselect',0,'workorders.requiredby','abcdf','1','1','a');
INSERT INTO `reportfields` VALUES (1874,141,'fieldlist',1,'workorders.wo','Work Order','1','1','0');
INSERT INTO `reportfields` VALUES (1875,141,'fieldlist',2,'workorders.loccode','Location','1','1','0');
INSERT INTO `reportfields` VALUES (1876,141,'fieldlist',3,'woitems.stockid','part','1','1','0');
INSERT INTO `reportfields` VALUES (1877,141,'fieldlist',4,'workorders.requiredby','delivery','1','1','0');
INSERT INTO `reportfields` VALUES (1878,141,'fieldlist',5,'woitems.qtyreqd','required','1','1','0');
INSERT INTO `reportfields` VALUES (1879,141,'fieldlist',6,'woitems.qtyrecd','produced','1','1','0');
INSERT INTO `reportfields` VALUES (1880,141,'sortlist',1,'workorders.requiredby','Due Date','0','0','1');
INSERT INTO `reportfields` VALUES (1881,141,'sortlist',2,'workorders.wo','Work Order','0','0','1');
INSERT INTO `reportfields` VALUES (1882,141,'trunclong',0,'','','1','1','0');

--
-- Dumping data for table `reportheaders`
--

INSERT INTO `reportheaders` VALUES (1,'Test report','Sales Area',0,'0','zzzzz','Customer Code',0,'1','zzzzzzzzzz','Product Code',0,'1','zzzzzzzzz','Not Used',0,'','');
INSERT INTO `reportheaders` VALUES (2,'Sales DVD-UNS','Product Code',0,'DVD-UN','DVD-UNZZZZ','Not Used',0,'','','Not Used',0,'','','Not Used',0,'','');

--
-- Dumping data for table `reportlinks`
--

INSERT INTO `reportlinks` VALUES ('accountgroups','accountsection','accountgroups.sectioninaccounts=accountsection.sectionid');
INSERT INTO `reportlinks` VALUES ('accountsection','accountgroups','accountsection.sectionid=accountgroups.sectioninaccounts');
INSERT INTO `reportlinks` VALUES ('bankaccounts','chartmaster','bankaccounts.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','bankaccounts','chartmaster.accountcode=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('banktrans','systypes','banktrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','banktrans','systypes.typeid=banktrans.type');
INSERT INTO `reportlinks` VALUES ('banktrans','bankaccounts','banktrans.bankact=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('bankaccounts','banktrans','bankaccounts.accountcode=banktrans.bankact');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.parent=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.parent');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.component');
INSERT INTO `reportlinks` VALUES ('bom','workcentres','bom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','bom','workcentres.code=bom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('bom','locations','bom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','bom','locations.loccode=bom.loccode');
INSERT INTO `reportlinks` VALUES ('buckets','workcentres','buckets.workcentre=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','buckets','workcentres.code=buckets.workcentre');
INSERT INTO `reportlinks` VALUES ('chartdetails','chartmaster','chartdetails.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','chartdetails','chartmaster.accountcode=chartdetails.accountcode');
INSERT INTO `reportlinks` VALUES ('chartdetails','periods','chartdetails.period=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','chartdetails','periods.periodno=chartdetails.period');
INSERT INTO `reportlinks` VALUES ('chartmaster','accountgroups','chartmaster.group_=accountgroups.groupname');
INSERT INTO `reportlinks` VALUES ('accountgroups','chartmaster','accountgroups.groupname=chartmaster.group_');
INSERT INTO `reportlinks` VALUES ('contractbom','workcentres','contractbom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','contractbom','workcentres.code=contractbom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('contractbom','locations','contractbom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','contractbom','locations.loccode=contractbom.loccode');
INSERT INTO `reportlinks` VALUES ('contractbom','stockmaster','contractbom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','contractbom','stockmaster.stockid=contractbom.component');
INSERT INTO `reportlinks` VALUES ('contractreqts','contracts','contractreqts.contract=contracts.contractref');
INSERT INTO `reportlinks` VALUES ('contracts','contractreqts','contracts.contractref=contractreqts.contract');
INSERT INTO `reportlinks` VALUES ('contracts','custbranch','contracts.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','contracts','custbranch.debtorno=contracts.debtorno');
INSERT INTO `reportlinks` VALUES ('contracts','stockcategory','contracts.branchcode=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','contracts','stockcategory.categoryid=contracts.branchcode');
INSERT INTO `reportlinks` VALUES ('contracts','salestypes','contracts.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','contracts','salestypes.typeabbrev=contracts.typeabbrev');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocfrom=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocto=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocto');
INSERT INTO `reportlinks` VALUES ('custbranch','debtorsmaster','custbranch.debtorno=debtorsmaster.debtorno');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','custbranch','debtorsmaster.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','areas','custbranch.area=areas.areacode');
INSERT INTO `reportlinks` VALUES ('areas','custbranch','areas.areacode=custbranch.area');
INSERT INTO `reportlinks` VALUES ('custbranch','salesman','custbranch.salesman=salesman.salesmancode');
INSERT INTO `reportlinks` VALUES ('salesman','custbranch','salesman.salesmancode=custbranch.salesman');
INSERT INTO `reportlinks` VALUES ('custbranch','locations','custbranch.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','custbranch','locations.loccode=custbranch.defaultlocation');
INSERT INTO `reportlinks` VALUES ('custbranch','shippers','custbranch.defaultshipvia=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','custbranch','shippers.shipper_id=custbranch.defaultshipvia');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','holdreasons','debtorsmaster.holdreason=holdreasons.reasoncode');
INSERT INTO `reportlinks` VALUES ('holdreasons','debtorsmaster','holdreasons.reasoncode=debtorsmaster.holdreason');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','currencies','debtorsmaster.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','debtorsmaster','currencies.currabrev=debtorsmaster.currcode');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','paymentterms','debtorsmaster.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','debtorsmaster','paymentterms.termsindicator=debtorsmaster.paymentterms');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','salestypes','debtorsmaster.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','debtorsmaster','salestypes.typeabbrev=debtorsmaster.salestype');
INSERT INTO `reportlinks` VALUES ('debtortrans','custbranch','debtortrans.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','debtortrans','custbranch.debtorno=debtortrans.debtorno');
INSERT INTO `reportlinks` VALUES ('debtortrans','systypes','debtortrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','debtortrans','systypes.typeid=debtortrans.type');
INSERT INTO `reportlinks` VALUES ('debtortrans','periods','debtortrans.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','debtortrans','periods.periodno=debtortrans.prd');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','taxauthorities','debtortranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','debtortranstaxes','taxauthorities.taxid=debtortranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','debtortrans','debtortranstaxes.debtortransid=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','debtortranstaxes','debtortrans.id=debtortranstaxes.debtortransid');
INSERT INTO `reportlinks` VALUES ('discountmatrix','salestypes','discountmatrix.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','discountmatrix','salestypes.typeabbrev=discountmatrix.salestype');
INSERT INTO `reportlinks` VALUES ('freightcosts','locations','freightcosts.locationfrom=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','freightcosts','locations.loccode=freightcosts.locationfrom');
INSERT INTO `reportlinks` VALUES ('freightcosts','shippers','freightcosts.shipperid=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','freightcosts','shippers.shipper_id=freightcosts.shipperid');
INSERT INTO `reportlinks` VALUES ('gltrans','chartmaster','gltrans.account=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','gltrans','chartmaster.accountcode=gltrans.account');
INSERT INTO `reportlinks` VALUES ('gltrans','systypes','gltrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','gltrans','systypes.typeid=gltrans.type');
INSERT INTO `reportlinks` VALUES ('gltrans','periods','gltrans.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','gltrans','periods.periodno=gltrans.periodno');
INSERT INTO `reportlinks` VALUES ('grns','suppliers','grns.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','grns','suppliers.supplierid=grns.supplierid');
INSERT INTO `reportlinks` VALUES ('grns','purchorderdetails','grns.podetailitem=purchorderdetails.podetailitem');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','grns','purchorderdetails.podetailitem=grns.podetailitem');
INSERT INTO `reportlinks` VALUES ('locations','taxprovinces','locations.taxprovinceid=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','locations','taxprovinces.taxprovinceid=locations.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('locstock','locations','locstock.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','locstock','locations.loccode=locstock.loccode');
INSERT INTO `reportlinks` VALUES ('locstock','stockmaster','locstock.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','locstock','stockmaster.stockid=locstock.stockid');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.shiploc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.shiploc');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.recloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.recloc');
INSERT INTO `reportlinks` VALUES ('loctransfers','stockmaster','loctransfers.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','loctransfers','stockmaster.stockid=loctransfers.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','stockmaster','orderdeliverydifferenceslog.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','orderdeliverydifferencesl','stockmaster.stockid=orderdeliverydifferenceslog.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','custbranch','orderdeliverydifferenceslog.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','orderdeliverydifferencesl','custbranch.debtorno=orderdeliverydifferenceslog.debtorno');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','salesorders','orderdeliverydifferenceslog.branchcode=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','orderdeliverydifferencesl','salesorders.orderno=orderdeliverydifferenceslog.branchcode');
INSERT INTO `reportlinks` VALUES ('prices','stockmaster','prices.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','prices','stockmaster.stockid=prices.stockid');
INSERT INTO `reportlinks` VALUES ('prices','currencies','prices.currabrev=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','prices','currencies.currabrev=prices.currabrev');
INSERT INTO `reportlinks` VALUES ('prices','salestypes','prices.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','prices','salestypes.typeabbrev=prices.typeabbrev');
INSERT INTO `reportlinks` VALUES ('purchdata','stockmaster','purchdata.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','purchdata','stockmaster.stockid=purchdata.stockid');
INSERT INTO `reportlinks` VALUES ('purchdata','suppliers','purchdata.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchdata','suppliers.supplierid=purchdata.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','purchorders','purchorderdetails.orderno=purchorders.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','purchorderdetails','purchorders.orderno=purchorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','suppliers','purchorders.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchorders','suppliers.supplierid=purchorders.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorders','locations','purchorders.intostocklocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','purchorders','locations.loccode=purchorders.intostocklocation');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','custbranch','recurringsalesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','recurringsalesorders','custbranch.branchcode=recurringsalesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','recurringsalesorders','recurrsalesorderdetails.recurrorderno=recurringsalesorders.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','recurrsalesorderdetails','recurringsalesorders.recurrorderno=recurrsalesorderdetails.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','stockmaster','recurrsalesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','recurrsalesorderdetails','stockmaster.stockid=recurrsalesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('reportcolumns','reportheaders','reportcolumns.reportid=reportheaders.reportid');
INSERT INTO `reportlinks` VALUES ('reportheaders','reportcolumns','reportheaders.reportid=reportcolumns.reportid');
INSERT INTO `reportlinks` VALUES ('salesanalysis','periods','salesanalysis.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','salesanalysis','periods.periodno=salesanalysis.periodno');
INSERT INTO `reportlinks` VALUES ('salescatprod','stockmaster','salescatprod.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salescatprod','stockmaster.stockid=salescatprod.stockid');
INSERT INTO `reportlinks` VALUES ('salescatprod','salescat','salescatprod.salescatid=salescat.salescatid');
INSERT INTO `reportlinks` VALUES ('salescat','salescatprod','salescat.salescatid=salescatprod.salescatid');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','salesorders','salesorderdetails.orderno=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','salesorderdetails','salesorders.orderno=salesorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','stockmaster','salesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salesorderdetails','stockmaster.stockid=salesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('salesorders','custbranch','salesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','salesorders','custbranch.branchcode=salesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('salesorders','shippers','salesorders.debtorno=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','salesorders','shippers.shipper_id=salesorders.debtorno');
INSERT INTO `reportlinks` VALUES ('salesorders','locations','salesorders.fromstkloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','salesorders','locations.loccode=salesorders.fromstkloc');
INSERT INTO `reportlinks` VALUES ('securitygroups','securityroles','securitygroups.secroleid=securityroles.secroleid');
INSERT INTO `reportlinks` VALUES ('securityroles','securitygroups','securityroles.secroleid=securitygroups.secroleid');
INSERT INTO `reportlinks` VALUES ('securitygroups','securitytokens','securitygroups.tokenid=securitytokens.tokenid');
INSERT INTO `reportlinks` VALUES ('securitytokens','securitygroups','securitytokens.tokenid=securitygroups.tokenid');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','shipments','shipmentcharges.shiptref=shipments.shiptref');
INSERT INTO `reportlinks` VALUES ('shipments','shipmentcharges','shipments.shiptref=shipmentcharges.shiptref');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','systypes','shipmentcharges.transtype=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','shipmentcharges','systypes.typeid=shipmentcharges.transtype');
INSERT INTO `reportlinks` VALUES ('shipments','suppliers','shipments.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','shipments','suppliers.supplierid=shipments.supplierid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','stockmaster','stockcheckfreeze.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcheckfreeze','stockmaster.stockid=stockcheckfreeze.stockid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','locations','stockcheckfreeze.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcheckfreeze','locations.loccode=stockcheckfreeze.loccode');
INSERT INTO `reportlinks` VALUES ('stockcounts','stockmaster','stockcounts.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcounts','stockmaster.stockid=stockcounts.stockid');
INSERT INTO `reportlinks` VALUES ('stockcounts','locations','stockcounts.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcounts','locations.loccode=stockcounts.loccode');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcategory','stockmaster.categoryid=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','stockmaster','stockcategory.categoryid=stockmaster.categoryid');
INSERT INTO `reportlinks` VALUES ('stockmaster','taxcategories','stockmaster.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','stockmaster','taxcategories.taxcatid=stockmaster.taxcatid');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockmaster','stockmoves.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockmoves','stockmaster.stockid=stockmoves.stockid');
INSERT INTO `reportlinks` VALUES ('stockmoves','systypes','stockmoves.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','stockmoves','systypes.typeid=stockmoves.type');
INSERT INTO `reportlinks` VALUES ('stockmoves','locations','stockmoves.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockmoves','locations.loccode=stockmoves.loccode');
INSERT INTO `reportlinks` VALUES ('stockmoves','periods','stockmoves.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','stockmoves','periods.periodno=stockmoves.prd');
INSERT INTO `reportlinks` VALUES ('stockmovestaxes','taxauthorities','stockmovestaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','stockmovestaxes','taxauthorities.taxid=stockmovestaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockmaster','stockserialitems.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockserialitems','stockmaster.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','locations','stockserialitems.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockserialitems','locations.loccode=stockserialitems.loccode');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockmoves','stockserialmoves.stockmoveno=stockmoves.stkmoveno');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockserialmoves','stockmoves.stkmoveno=stockserialmoves.stockmoveno');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockserialitems','stockserialmoves.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockserialmoves','stockserialitems.stockid=stockserialmoves.stockid');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocfrom=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocto=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocto');
INSERT INTO `reportlinks` VALUES ('suppliercontacts','suppliers','suppliercontacts.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','suppliercontacts','suppliers.supplierid=suppliercontacts.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','currencies','suppliers.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','suppliers','currencies.currabrev=suppliers.currcode');
INSERT INTO `reportlinks` VALUES ('suppliers','paymentterms','suppliers.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','suppliers','paymentterms.termsindicator=suppliers.paymentterms');
INSERT INTO `reportlinks` VALUES ('suppliers','taxgroups','suppliers.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','suppliers','taxgroups.taxgroupid=suppliers.taxgroupid');
INSERT INTO `reportlinks` VALUES ('supptrans','systypes','supptrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','supptrans','systypes.typeid=supptrans.type');
INSERT INTO `reportlinks` VALUES ('supptrans','suppliers','supptrans.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','supptrans','suppliers.supplierid=supptrans.supplierno');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','taxauthorities','supptranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','supptranstaxes','taxauthorities.taxid=supptranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','supptrans','supptranstaxes.supptransid=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','supptranstaxes','supptrans.id=supptranstaxes.supptransid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.taxglcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.taxglcode');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.purchtaxglaccount=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.purchtaxglaccount');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxauthorities','taxauthrates.taxauthority=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxauthrates','taxauthorities.taxid=taxauthrates.taxauthority');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxcategories','taxauthrates.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','taxauthrates','taxcategories.taxcatid=taxauthrates.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxprovinces','taxauthrates.dispatchtaxprovince=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','taxauthrates','taxprovinces.taxprovinceid=taxauthrates.dispatchtaxprovince');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxgroups','taxgrouptaxes.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','taxgrouptaxes','taxgroups.taxgroupid=taxgrouptaxes.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxauthorities','taxgrouptaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxgrouptaxes','taxauthorities.taxid=taxgrouptaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('workcentres','locations','workcentres.location=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','workcentres','locations.loccode=workcentres.location');
INSERT INTO `reportlinks` VALUES ('worksorders','locations','worksorders.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','worksorders','locations.loccode=worksorders.loccode');
INSERT INTO `reportlinks` VALUES ('worksorders','stockmaster','worksorders.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','worksorders','stockmaster.stockid=worksorders.stockid');
INSERT INTO `reportlinks` VALUES ('www_users','locations','www_users.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','www_users','locations.loccode=www_users.defaultlocation');
INSERT INTO `reportlinks` VALUES ('accountgroups','accountsection','accountgroups.sectioninaccounts=accountsection.sectionid');
INSERT INTO `reportlinks` VALUES ('accountsection','accountgroups','accountsection.sectionid=accountgroups.sectioninaccounts');
INSERT INTO `reportlinks` VALUES ('bankaccounts','chartmaster','bankaccounts.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','bankaccounts','chartmaster.accountcode=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('banktrans','systypes','banktrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','banktrans','systypes.typeid=banktrans.type');
INSERT INTO `reportlinks` VALUES ('banktrans','bankaccounts','banktrans.bankact=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('bankaccounts','banktrans','bankaccounts.accountcode=banktrans.bankact');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.parent=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.parent');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.component');
INSERT INTO `reportlinks` VALUES ('bom','workcentres','bom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','bom','workcentres.code=bom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('bom','locations','bom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','bom','locations.loccode=bom.loccode');
INSERT INTO `reportlinks` VALUES ('buckets','workcentres','buckets.workcentre=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','buckets','workcentres.code=buckets.workcentre');
INSERT INTO `reportlinks` VALUES ('chartdetails','chartmaster','chartdetails.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','chartdetails','chartmaster.accountcode=chartdetails.accountcode');
INSERT INTO `reportlinks` VALUES ('chartdetails','periods','chartdetails.period=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','chartdetails','periods.periodno=chartdetails.period');
INSERT INTO `reportlinks` VALUES ('chartmaster','accountgroups','chartmaster.group_=accountgroups.groupname');
INSERT INTO `reportlinks` VALUES ('accountgroups','chartmaster','accountgroups.groupname=chartmaster.group_');
INSERT INTO `reportlinks` VALUES ('contractbom','workcentres','contractbom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','contractbom','workcentres.code=contractbom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('contractbom','locations','contractbom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','contractbom','locations.loccode=contractbom.loccode');
INSERT INTO `reportlinks` VALUES ('contractbom','stockmaster','contractbom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','contractbom','stockmaster.stockid=contractbom.component');
INSERT INTO `reportlinks` VALUES ('contractreqts','contracts','contractreqts.contract=contracts.contractref');
INSERT INTO `reportlinks` VALUES ('contracts','contractreqts','contracts.contractref=contractreqts.contract');
INSERT INTO `reportlinks` VALUES ('contracts','custbranch','contracts.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','contracts','custbranch.debtorno=contracts.debtorno');
INSERT INTO `reportlinks` VALUES ('contracts','stockcategory','contracts.branchcode=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','contracts','stockcategory.categoryid=contracts.branchcode');
INSERT INTO `reportlinks` VALUES ('contracts','salestypes','contracts.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','contracts','salestypes.typeabbrev=contracts.typeabbrev');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocfrom=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocto=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocto');
INSERT INTO `reportlinks` VALUES ('custbranch','debtorsmaster','custbranch.debtorno=debtorsmaster.debtorno');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','custbranch','debtorsmaster.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','areas','custbranch.area=areas.areacode');
INSERT INTO `reportlinks` VALUES ('areas','custbranch','areas.areacode=custbranch.area');
INSERT INTO `reportlinks` VALUES ('custbranch','salesman','custbranch.salesman=salesman.salesmancode');
INSERT INTO `reportlinks` VALUES ('salesman','custbranch','salesman.salesmancode=custbranch.salesman');
INSERT INTO `reportlinks` VALUES ('custbranch','locations','custbranch.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','custbranch','locations.loccode=custbranch.defaultlocation');
INSERT INTO `reportlinks` VALUES ('custbranch','shippers','custbranch.defaultshipvia=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','custbranch','shippers.shipper_id=custbranch.defaultshipvia');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','holdreasons','debtorsmaster.holdreason=holdreasons.reasoncode');
INSERT INTO `reportlinks` VALUES ('holdreasons','debtorsmaster','holdreasons.reasoncode=debtorsmaster.holdreason');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','currencies','debtorsmaster.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','debtorsmaster','currencies.currabrev=debtorsmaster.currcode');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','paymentterms','debtorsmaster.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','debtorsmaster','paymentterms.termsindicator=debtorsmaster.paymentterms');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','salestypes','debtorsmaster.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','debtorsmaster','salestypes.typeabbrev=debtorsmaster.salestype');
INSERT INTO `reportlinks` VALUES ('debtortrans','custbranch','debtortrans.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','debtortrans','custbranch.debtorno=debtortrans.debtorno');
INSERT INTO `reportlinks` VALUES ('debtortrans','systypes','debtortrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','debtortrans','systypes.typeid=debtortrans.type');
INSERT INTO `reportlinks` VALUES ('debtortrans','periods','debtortrans.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','debtortrans','periods.periodno=debtortrans.prd');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','taxauthorities','debtortranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','debtortranstaxes','taxauthorities.taxid=debtortranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','debtortrans','debtortranstaxes.debtortransid=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','debtortranstaxes','debtortrans.id=debtortranstaxes.debtortransid');
INSERT INTO `reportlinks` VALUES ('discountmatrix','salestypes','discountmatrix.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','discountmatrix','salestypes.typeabbrev=discountmatrix.salestype');
INSERT INTO `reportlinks` VALUES ('freightcosts','locations','freightcosts.locationfrom=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','freightcosts','locations.loccode=freightcosts.locationfrom');
INSERT INTO `reportlinks` VALUES ('freightcosts','shippers','freightcosts.shipperid=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','freightcosts','shippers.shipper_id=freightcosts.shipperid');
INSERT INTO `reportlinks` VALUES ('gltrans','chartmaster','gltrans.account=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','gltrans','chartmaster.accountcode=gltrans.account');
INSERT INTO `reportlinks` VALUES ('gltrans','systypes','gltrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','gltrans','systypes.typeid=gltrans.type');
INSERT INTO `reportlinks` VALUES ('gltrans','periods','gltrans.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','gltrans','periods.periodno=gltrans.periodno');
INSERT INTO `reportlinks` VALUES ('grns','suppliers','grns.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','grns','suppliers.supplierid=grns.supplierid');
INSERT INTO `reportlinks` VALUES ('grns','purchorderdetails','grns.podetailitem=purchorderdetails.podetailitem');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','grns','purchorderdetails.podetailitem=grns.podetailitem');
INSERT INTO `reportlinks` VALUES ('locations','taxprovinces','locations.taxprovinceid=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','locations','taxprovinces.taxprovinceid=locations.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('locstock','locations','locstock.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','locstock','locations.loccode=locstock.loccode');
INSERT INTO `reportlinks` VALUES ('locstock','stockmaster','locstock.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','locstock','stockmaster.stockid=locstock.stockid');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.shiploc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.shiploc');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.recloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.recloc');
INSERT INTO `reportlinks` VALUES ('loctransfers','stockmaster','loctransfers.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','loctransfers','stockmaster.stockid=loctransfers.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','stockmaster','orderdeliverydifferenceslog.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','orderdeliverydifferencesl','stockmaster.stockid=orderdeliverydifferenceslog.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','custbranch','orderdeliverydifferenceslog.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','orderdeliverydifferencesl','custbranch.debtorno=orderdeliverydifferenceslog.debtorno');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','salesorders','orderdeliverydifferenceslog.branchcode=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','orderdeliverydifferencesl','salesorders.orderno=orderdeliverydifferenceslog.branchcode');
INSERT INTO `reportlinks` VALUES ('prices','stockmaster','prices.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','prices','stockmaster.stockid=prices.stockid');
INSERT INTO `reportlinks` VALUES ('prices','currencies','prices.currabrev=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','prices','currencies.currabrev=prices.currabrev');
INSERT INTO `reportlinks` VALUES ('prices','salestypes','prices.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','prices','salestypes.typeabbrev=prices.typeabbrev');
INSERT INTO `reportlinks` VALUES ('purchdata','stockmaster','purchdata.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','purchdata','stockmaster.stockid=purchdata.stockid');
INSERT INTO `reportlinks` VALUES ('purchdata','suppliers','purchdata.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchdata','suppliers.supplierid=purchdata.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','purchorders','purchorderdetails.orderno=purchorders.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','purchorderdetails','purchorders.orderno=purchorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','suppliers','purchorders.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchorders','suppliers.supplierid=purchorders.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorders','locations','purchorders.intostocklocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','purchorders','locations.loccode=purchorders.intostocklocation');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','custbranch','recurringsalesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','recurringsalesorders','custbranch.branchcode=recurringsalesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','recurringsalesorders','recurrsalesorderdetails.recurrorderno=recurringsalesorders.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','recurrsalesorderdetails','recurringsalesorders.recurrorderno=recurrsalesorderdetails.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','stockmaster','recurrsalesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','recurrsalesorderdetails','stockmaster.stockid=recurrsalesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('reportcolumns','reportheaders','reportcolumns.reportid=reportheaders.reportid');
INSERT INTO `reportlinks` VALUES ('reportheaders','reportcolumns','reportheaders.reportid=reportcolumns.reportid');
INSERT INTO `reportlinks` VALUES ('salesanalysis','periods','salesanalysis.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','salesanalysis','periods.periodno=salesanalysis.periodno');
INSERT INTO `reportlinks` VALUES ('salescatprod','stockmaster','salescatprod.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salescatprod','stockmaster.stockid=salescatprod.stockid');
INSERT INTO `reportlinks` VALUES ('salescatprod','salescat','salescatprod.salescatid=salescat.salescatid');
INSERT INTO `reportlinks` VALUES ('salescat','salescatprod','salescat.salescatid=salescatprod.salescatid');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','salesorders','salesorderdetails.orderno=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','salesorderdetails','salesorders.orderno=salesorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','stockmaster','salesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salesorderdetails','stockmaster.stockid=salesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('salesorders','custbranch','salesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','salesorders','custbranch.branchcode=salesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('salesorders','shippers','salesorders.debtorno=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','salesorders','shippers.shipper_id=salesorders.debtorno');
INSERT INTO `reportlinks` VALUES ('salesorders','locations','salesorders.fromstkloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','salesorders','locations.loccode=salesorders.fromstkloc');
INSERT INTO `reportlinks` VALUES ('securitygroups','securityroles','securitygroups.secroleid=securityroles.secroleid');
INSERT INTO `reportlinks` VALUES ('securityroles','securitygroups','securityroles.secroleid=securitygroups.secroleid');
INSERT INTO `reportlinks` VALUES ('securitygroups','securitytokens','securitygroups.tokenid=securitytokens.tokenid');
INSERT INTO `reportlinks` VALUES ('securitytokens','securitygroups','securitytokens.tokenid=securitygroups.tokenid');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','shipments','shipmentcharges.shiptref=shipments.shiptref');
INSERT INTO `reportlinks` VALUES ('shipments','shipmentcharges','shipments.shiptref=shipmentcharges.shiptref');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','systypes','shipmentcharges.transtype=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','shipmentcharges','systypes.typeid=shipmentcharges.transtype');
INSERT INTO `reportlinks` VALUES ('shipments','suppliers','shipments.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','shipments','suppliers.supplierid=shipments.supplierid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','stockmaster','stockcheckfreeze.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcheckfreeze','stockmaster.stockid=stockcheckfreeze.stockid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','locations','stockcheckfreeze.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcheckfreeze','locations.loccode=stockcheckfreeze.loccode');
INSERT INTO `reportlinks` VALUES ('stockcounts','stockmaster','stockcounts.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcounts','stockmaster.stockid=stockcounts.stockid');
INSERT INTO `reportlinks` VALUES ('stockcounts','locations','stockcounts.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcounts','locations.loccode=stockcounts.loccode');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcategory','stockmaster.categoryid=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','stockmaster','stockcategory.categoryid=stockmaster.categoryid');
INSERT INTO `reportlinks` VALUES ('stockmaster','taxcategories','stockmaster.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','stockmaster','taxcategories.taxcatid=stockmaster.taxcatid');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockmaster','stockmoves.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockmoves','stockmaster.stockid=stockmoves.stockid');
INSERT INTO `reportlinks` VALUES ('stockmoves','systypes','stockmoves.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','stockmoves','systypes.typeid=stockmoves.type');
INSERT INTO `reportlinks` VALUES ('stockmoves','locations','stockmoves.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockmoves','locations.loccode=stockmoves.loccode');
INSERT INTO `reportlinks` VALUES ('stockmoves','periods','stockmoves.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','stockmoves','periods.periodno=stockmoves.prd');
INSERT INTO `reportlinks` VALUES ('stockmovestaxes','taxauthorities','stockmovestaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','stockmovestaxes','taxauthorities.taxid=stockmovestaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockmaster','stockserialitems.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockserialitems','stockmaster.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','locations','stockserialitems.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockserialitems','locations.loccode=stockserialitems.loccode');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockmoves','stockserialmoves.stockmoveno=stockmoves.stkmoveno');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockserialmoves','stockmoves.stkmoveno=stockserialmoves.stockmoveno');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockserialitems','stockserialmoves.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockserialmoves','stockserialitems.stockid=stockserialmoves.stockid');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocfrom=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocto=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocto');
INSERT INTO `reportlinks` VALUES ('suppliercontacts','suppliers','suppliercontacts.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','suppliercontacts','suppliers.supplierid=suppliercontacts.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','currencies','suppliers.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','suppliers','currencies.currabrev=suppliers.currcode');
INSERT INTO `reportlinks` VALUES ('suppliers','paymentterms','suppliers.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','suppliers','paymentterms.termsindicator=suppliers.paymentterms');
INSERT INTO `reportlinks` VALUES ('suppliers','taxgroups','suppliers.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','suppliers','taxgroups.taxgroupid=suppliers.taxgroupid');
INSERT INTO `reportlinks` VALUES ('supptrans','systypes','supptrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','supptrans','systypes.typeid=supptrans.type');
INSERT INTO `reportlinks` VALUES ('supptrans','suppliers','supptrans.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','supptrans','suppliers.supplierid=supptrans.supplierno');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','taxauthorities','supptranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','supptranstaxes','taxauthorities.taxid=supptranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','supptrans','supptranstaxes.supptransid=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','supptranstaxes','supptrans.id=supptranstaxes.supptransid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.taxglcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.taxglcode');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.purchtaxglaccount=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.purchtaxglaccount');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxauthorities','taxauthrates.taxauthority=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxauthrates','taxauthorities.taxid=taxauthrates.taxauthority');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxcategories','taxauthrates.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','taxauthrates','taxcategories.taxcatid=taxauthrates.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxprovinces','taxauthrates.dispatchtaxprovince=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','taxauthrates','taxprovinces.taxprovinceid=taxauthrates.dispatchtaxprovince');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxgroups','taxgrouptaxes.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','taxgrouptaxes','taxgroups.taxgroupid=taxgrouptaxes.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxauthorities','taxgrouptaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxgrouptaxes','taxauthorities.taxid=taxgrouptaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('workcentres','locations','workcentres.location=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','workcentres','locations.loccode=workcentres.location');
INSERT INTO `reportlinks` VALUES ('worksorders','locations','worksorders.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','worksorders','locations.loccode=worksorders.loccode');
INSERT INTO `reportlinks` VALUES ('worksorders','stockmaster','worksorders.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','worksorders','stockmaster.stockid=worksorders.stockid');
INSERT INTO `reportlinks` VALUES ('www_users','locations','www_users.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','www_users','locations.loccode=www_users.defaultlocation');
INSERT INTO `reportlinks` VALUES ('accountgroups','accountsection','accountgroups.sectioninaccounts=accountsection.sectionid');
INSERT INTO `reportlinks` VALUES ('accountsection','accountgroups','accountsection.sectionid=accountgroups.sectioninaccounts');
INSERT INTO `reportlinks` VALUES ('bankaccounts','chartmaster','bankaccounts.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','bankaccounts','chartmaster.accountcode=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('banktrans','systypes','banktrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','banktrans','systypes.typeid=banktrans.type');
INSERT INTO `reportlinks` VALUES ('banktrans','bankaccounts','banktrans.bankact=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('bankaccounts','banktrans','bankaccounts.accountcode=banktrans.bankact');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.parent=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.parent');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.component');
INSERT INTO `reportlinks` VALUES ('bom','workcentres','bom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','bom','workcentres.code=bom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('bom','locations','bom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','bom','locations.loccode=bom.loccode');
INSERT INTO `reportlinks` VALUES ('buckets','workcentres','buckets.workcentre=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','buckets','workcentres.code=buckets.workcentre');
INSERT INTO `reportlinks` VALUES ('chartdetails','chartmaster','chartdetails.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','chartdetails','chartmaster.accountcode=chartdetails.accountcode');
INSERT INTO `reportlinks` VALUES ('chartdetails','periods','chartdetails.period=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','chartdetails','periods.periodno=chartdetails.period');
INSERT INTO `reportlinks` VALUES ('chartmaster','accountgroups','chartmaster.group_=accountgroups.groupname');
INSERT INTO `reportlinks` VALUES ('accountgroups','chartmaster','accountgroups.groupname=chartmaster.group_');
INSERT INTO `reportlinks` VALUES ('contractbom','workcentres','contractbom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','contractbom','workcentres.code=contractbom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('contractbom','locations','contractbom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','contractbom','locations.loccode=contractbom.loccode');
INSERT INTO `reportlinks` VALUES ('contractbom','stockmaster','contractbom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','contractbom','stockmaster.stockid=contractbom.component');
INSERT INTO `reportlinks` VALUES ('contractreqts','contracts','contractreqts.contract=contracts.contractref');
INSERT INTO `reportlinks` VALUES ('contracts','contractreqts','contracts.contractref=contractreqts.contract');
INSERT INTO `reportlinks` VALUES ('contracts','custbranch','contracts.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','contracts','custbranch.debtorno=contracts.debtorno');
INSERT INTO `reportlinks` VALUES ('contracts','stockcategory','contracts.branchcode=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','contracts','stockcategory.categoryid=contracts.branchcode');
INSERT INTO `reportlinks` VALUES ('contracts','salestypes','contracts.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','contracts','salestypes.typeabbrev=contracts.typeabbrev');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocfrom=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocto=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocto');
INSERT INTO `reportlinks` VALUES ('custbranch','debtorsmaster','custbranch.debtorno=debtorsmaster.debtorno');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','custbranch','debtorsmaster.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','areas','custbranch.area=areas.areacode');
INSERT INTO `reportlinks` VALUES ('areas','custbranch','areas.areacode=custbranch.area');
INSERT INTO `reportlinks` VALUES ('custbranch','salesman','custbranch.salesman=salesman.salesmancode');
INSERT INTO `reportlinks` VALUES ('salesman','custbranch','salesman.salesmancode=custbranch.salesman');
INSERT INTO `reportlinks` VALUES ('custbranch','locations','custbranch.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','custbranch','locations.loccode=custbranch.defaultlocation');
INSERT INTO `reportlinks` VALUES ('custbranch','shippers','custbranch.defaultshipvia=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','custbranch','shippers.shipper_id=custbranch.defaultshipvia');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','holdreasons','debtorsmaster.holdreason=holdreasons.reasoncode');
INSERT INTO `reportlinks` VALUES ('holdreasons','debtorsmaster','holdreasons.reasoncode=debtorsmaster.holdreason');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','currencies','debtorsmaster.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','debtorsmaster','currencies.currabrev=debtorsmaster.currcode');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','paymentterms','debtorsmaster.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','debtorsmaster','paymentterms.termsindicator=debtorsmaster.paymentterms');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','salestypes','debtorsmaster.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','debtorsmaster','salestypes.typeabbrev=debtorsmaster.salestype');
INSERT INTO `reportlinks` VALUES ('debtortrans','custbranch','debtortrans.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','debtortrans','custbranch.debtorno=debtortrans.debtorno');
INSERT INTO `reportlinks` VALUES ('debtortrans','systypes','debtortrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','debtortrans','systypes.typeid=debtortrans.type');
INSERT INTO `reportlinks` VALUES ('debtortrans','periods','debtortrans.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','debtortrans','periods.periodno=debtortrans.prd');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','taxauthorities','debtortranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','debtortranstaxes','taxauthorities.taxid=debtortranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','debtortrans','debtortranstaxes.debtortransid=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','debtortranstaxes','debtortrans.id=debtortranstaxes.debtortransid');
INSERT INTO `reportlinks` VALUES ('discountmatrix','salestypes','discountmatrix.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','discountmatrix','salestypes.typeabbrev=discountmatrix.salestype');
INSERT INTO `reportlinks` VALUES ('freightcosts','locations','freightcosts.locationfrom=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','freightcosts','locations.loccode=freightcosts.locationfrom');
INSERT INTO `reportlinks` VALUES ('freightcosts','shippers','freightcosts.shipperid=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','freightcosts','shippers.shipper_id=freightcosts.shipperid');
INSERT INTO `reportlinks` VALUES ('gltrans','chartmaster','gltrans.account=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','gltrans','chartmaster.accountcode=gltrans.account');
INSERT INTO `reportlinks` VALUES ('gltrans','systypes','gltrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','gltrans','systypes.typeid=gltrans.type');
INSERT INTO `reportlinks` VALUES ('gltrans','periods','gltrans.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','gltrans','periods.periodno=gltrans.periodno');
INSERT INTO `reportlinks` VALUES ('grns','suppliers','grns.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','grns','suppliers.supplierid=grns.supplierid');
INSERT INTO `reportlinks` VALUES ('grns','purchorderdetails','grns.podetailitem=purchorderdetails.podetailitem');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','grns','purchorderdetails.podetailitem=grns.podetailitem');
INSERT INTO `reportlinks` VALUES ('locations','taxprovinces','locations.taxprovinceid=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','locations','taxprovinces.taxprovinceid=locations.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('locstock','locations','locstock.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','locstock','locations.loccode=locstock.loccode');
INSERT INTO `reportlinks` VALUES ('locstock','stockmaster','locstock.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','locstock','stockmaster.stockid=locstock.stockid');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.shiploc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.shiploc');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.recloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.recloc');
INSERT INTO `reportlinks` VALUES ('loctransfers','stockmaster','loctransfers.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','loctransfers','stockmaster.stockid=loctransfers.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','stockmaster','orderdeliverydifferenceslog.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','orderdeliverydifferencesl','stockmaster.stockid=orderdeliverydifferenceslog.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','custbranch','orderdeliverydifferenceslog.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','orderdeliverydifferencesl','custbranch.debtorno=orderdeliverydifferenceslog.debtorno');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','salesorders','orderdeliverydifferenceslog.branchcode=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','orderdeliverydifferencesl','salesorders.orderno=orderdeliverydifferenceslog.branchcode');
INSERT INTO `reportlinks` VALUES ('prices','stockmaster','prices.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','prices','stockmaster.stockid=prices.stockid');
INSERT INTO `reportlinks` VALUES ('prices','currencies','prices.currabrev=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','prices','currencies.currabrev=prices.currabrev');
INSERT INTO `reportlinks` VALUES ('prices','salestypes','prices.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','prices','salestypes.typeabbrev=prices.typeabbrev');
INSERT INTO `reportlinks` VALUES ('purchdata','stockmaster','purchdata.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','purchdata','stockmaster.stockid=purchdata.stockid');
INSERT INTO `reportlinks` VALUES ('purchdata','suppliers','purchdata.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchdata','suppliers.supplierid=purchdata.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','purchorders','purchorderdetails.orderno=purchorders.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','purchorderdetails','purchorders.orderno=purchorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','suppliers','purchorders.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchorders','suppliers.supplierid=purchorders.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorders','locations','purchorders.intostocklocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','purchorders','locations.loccode=purchorders.intostocklocation');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','custbranch','recurringsalesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','recurringsalesorders','custbranch.branchcode=recurringsalesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','recurringsalesorders','recurrsalesorderdetails.recurrorderno=recurringsalesorders.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','recurrsalesorderdetails','recurringsalesorders.recurrorderno=recurrsalesorderdetails.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','stockmaster','recurrsalesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','recurrsalesorderdetails','stockmaster.stockid=recurrsalesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('reportcolumns','reportheaders','reportcolumns.reportid=reportheaders.reportid');
INSERT INTO `reportlinks` VALUES ('reportheaders','reportcolumns','reportheaders.reportid=reportcolumns.reportid');
INSERT INTO `reportlinks` VALUES ('salesanalysis','periods','salesanalysis.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','salesanalysis','periods.periodno=salesanalysis.periodno');
INSERT INTO `reportlinks` VALUES ('salescatprod','stockmaster','salescatprod.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salescatprod','stockmaster.stockid=salescatprod.stockid');
INSERT INTO `reportlinks` VALUES ('salescatprod','salescat','salescatprod.salescatid=salescat.salescatid');
INSERT INTO `reportlinks` VALUES ('salescat','salescatprod','salescat.salescatid=salescatprod.salescatid');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','salesorders','salesorderdetails.orderno=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','salesorderdetails','salesorders.orderno=salesorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','stockmaster','salesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salesorderdetails','stockmaster.stockid=salesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('salesorders','custbranch','salesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','salesorders','custbranch.branchcode=salesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('salesorders','shippers','salesorders.debtorno=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','salesorders','shippers.shipper_id=salesorders.debtorno');
INSERT INTO `reportlinks` VALUES ('salesorders','locations','salesorders.fromstkloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','salesorders','locations.loccode=salesorders.fromstkloc');
INSERT INTO `reportlinks` VALUES ('securitygroups','securityroles','securitygroups.secroleid=securityroles.secroleid');
INSERT INTO `reportlinks` VALUES ('securityroles','securitygroups','securityroles.secroleid=securitygroups.secroleid');
INSERT INTO `reportlinks` VALUES ('securitygroups','securitytokens','securitygroups.tokenid=securitytokens.tokenid');
INSERT INTO `reportlinks` VALUES ('securitytokens','securitygroups','securitytokens.tokenid=securitygroups.tokenid');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','shipments','shipmentcharges.shiptref=shipments.shiptref');
INSERT INTO `reportlinks` VALUES ('shipments','shipmentcharges','shipments.shiptref=shipmentcharges.shiptref');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','systypes','shipmentcharges.transtype=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','shipmentcharges','systypes.typeid=shipmentcharges.transtype');
INSERT INTO `reportlinks` VALUES ('shipments','suppliers','shipments.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','shipments','suppliers.supplierid=shipments.supplierid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','stockmaster','stockcheckfreeze.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcheckfreeze','stockmaster.stockid=stockcheckfreeze.stockid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','locations','stockcheckfreeze.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcheckfreeze','locations.loccode=stockcheckfreeze.loccode');
INSERT INTO `reportlinks` VALUES ('stockcounts','stockmaster','stockcounts.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcounts','stockmaster.stockid=stockcounts.stockid');
INSERT INTO `reportlinks` VALUES ('stockcounts','locations','stockcounts.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcounts','locations.loccode=stockcounts.loccode');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcategory','stockmaster.categoryid=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','stockmaster','stockcategory.categoryid=stockmaster.categoryid');
INSERT INTO `reportlinks` VALUES ('stockmaster','taxcategories','stockmaster.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','stockmaster','taxcategories.taxcatid=stockmaster.taxcatid');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockmaster','stockmoves.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockmoves','stockmaster.stockid=stockmoves.stockid');
INSERT INTO `reportlinks` VALUES ('stockmoves','systypes','stockmoves.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','stockmoves','systypes.typeid=stockmoves.type');
INSERT INTO `reportlinks` VALUES ('stockmoves','locations','stockmoves.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockmoves','locations.loccode=stockmoves.loccode');
INSERT INTO `reportlinks` VALUES ('stockmoves','periods','stockmoves.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','stockmoves','periods.periodno=stockmoves.prd');
INSERT INTO `reportlinks` VALUES ('stockmovestaxes','taxauthorities','stockmovestaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','stockmovestaxes','taxauthorities.taxid=stockmovestaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockmaster','stockserialitems.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockserialitems','stockmaster.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','locations','stockserialitems.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockserialitems','locations.loccode=stockserialitems.loccode');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockmoves','stockserialmoves.stockmoveno=stockmoves.stkmoveno');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockserialmoves','stockmoves.stkmoveno=stockserialmoves.stockmoveno');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockserialitems','stockserialmoves.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockserialmoves','stockserialitems.stockid=stockserialmoves.stockid');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocfrom=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocto=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocto');
INSERT INTO `reportlinks` VALUES ('suppliercontacts','suppliers','suppliercontacts.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','suppliercontacts','suppliers.supplierid=suppliercontacts.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','currencies','suppliers.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','suppliers','currencies.currabrev=suppliers.currcode');
INSERT INTO `reportlinks` VALUES ('suppliers','paymentterms','suppliers.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','suppliers','paymentterms.termsindicator=suppliers.paymentterms');
INSERT INTO `reportlinks` VALUES ('suppliers','taxgroups','suppliers.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','suppliers','taxgroups.taxgroupid=suppliers.taxgroupid');
INSERT INTO `reportlinks` VALUES ('supptrans','systypes','supptrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','supptrans','systypes.typeid=supptrans.type');
INSERT INTO `reportlinks` VALUES ('supptrans','suppliers','supptrans.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','supptrans','suppliers.supplierid=supptrans.supplierno');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','taxauthorities','supptranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','supptranstaxes','taxauthorities.taxid=supptranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','supptrans','supptranstaxes.supptransid=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','supptranstaxes','supptrans.id=supptranstaxes.supptransid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.taxglcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.taxglcode');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.purchtaxglaccount=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.purchtaxglaccount');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxauthorities','taxauthrates.taxauthority=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxauthrates','taxauthorities.taxid=taxauthrates.taxauthority');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxcategories','taxauthrates.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','taxauthrates','taxcategories.taxcatid=taxauthrates.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxprovinces','taxauthrates.dispatchtaxprovince=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','taxauthrates','taxprovinces.taxprovinceid=taxauthrates.dispatchtaxprovince');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxgroups','taxgrouptaxes.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','taxgrouptaxes','taxgroups.taxgroupid=taxgrouptaxes.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxauthorities','taxgrouptaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxgrouptaxes','taxauthorities.taxid=taxgrouptaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('workcentres','locations','workcentres.location=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','workcentres','locations.loccode=workcentres.location');
INSERT INTO `reportlinks` VALUES ('worksorders','locations','worksorders.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','worksorders','locations.loccode=worksorders.loccode');
INSERT INTO `reportlinks` VALUES ('worksorders','stockmaster','worksorders.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','worksorders','stockmaster.stockid=worksorders.stockid');
INSERT INTO `reportlinks` VALUES ('www_users','locations','www_users.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','www_users','locations.loccode=www_users.defaultlocation');
INSERT INTO `reportlinks` VALUES ('accountgroups','accountsection','accountgroups.sectioninaccounts=accountsection.sectionid');
INSERT INTO `reportlinks` VALUES ('accountsection','accountgroups','accountsection.sectionid=accountgroups.sectioninaccounts');
INSERT INTO `reportlinks` VALUES ('bankaccounts','chartmaster','bankaccounts.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','bankaccounts','chartmaster.accountcode=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('banktrans','systypes','banktrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','banktrans','systypes.typeid=banktrans.type');
INSERT INTO `reportlinks` VALUES ('banktrans','bankaccounts','banktrans.bankact=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('bankaccounts','banktrans','bankaccounts.accountcode=banktrans.bankact');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.parent=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.parent');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.component');
INSERT INTO `reportlinks` VALUES ('bom','workcentres','bom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','bom','workcentres.code=bom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('bom','locations','bom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','bom','locations.loccode=bom.loccode');
INSERT INTO `reportlinks` VALUES ('buckets','workcentres','buckets.workcentre=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','buckets','workcentres.code=buckets.workcentre');
INSERT INTO `reportlinks` VALUES ('chartdetails','chartmaster','chartdetails.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','chartdetails','chartmaster.accountcode=chartdetails.accountcode');
INSERT INTO `reportlinks` VALUES ('chartdetails','periods','chartdetails.period=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','chartdetails','periods.periodno=chartdetails.period');
INSERT INTO `reportlinks` VALUES ('chartmaster','accountgroups','chartmaster.group_=accountgroups.groupname');
INSERT INTO `reportlinks` VALUES ('accountgroups','chartmaster','accountgroups.groupname=chartmaster.group_');
INSERT INTO `reportlinks` VALUES ('contractbom','workcentres','contractbom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','contractbom','workcentres.code=contractbom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('contractbom','locations','contractbom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','contractbom','locations.loccode=contractbom.loccode');
INSERT INTO `reportlinks` VALUES ('contractbom','stockmaster','contractbom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','contractbom','stockmaster.stockid=contractbom.component');
INSERT INTO `reportlinks` VALUES ('contractreqts','contracts','contractreqts.contract=contracts.contractref');
INSERT INTO `reportlinks` VALUES ('contracts','contractreqts','contracts.contractref=contractreqts.contract');
INSERT INTO `reportlinks` VALUES ('contracts','custbranch','contracts.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','contracts','custbranch.debtorno=contracts.debtorno');
INSERT INTO `reportlinks` VALUES ('contracts','stockcategory','contracts.branchcode=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','contracts','stockcategory.categoryid=contracts.branchcode');
INSERT INTO `reportlinks` VALUES ('contracts','salestypes','contracts.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','contracts','salestypes.typeabbrev=contracts.typeabbrev');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocfrom=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocto=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocto');
INSERT INTO `reportlinks` VALUES ('custbranch','debtorsmaster','custbranch.debtorno=debtorsmaster.debtorno');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','custbranch','debtorsmaster.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','areas','custbranch.area=areas.areacode');
INSERT INTO `reportlinks` VALUES ('areas','custbranch','areas.areacode=custbranch.area');
INSERT INTO `reportlinks` VALUES ('custbranch','salesman','custbranch.salesman=salesman.salesmancode');
INSERT INTO `reportlinks` VALUES ('salesman','custbranch','salesman.salesmancode=custbranch.salesman');
INSERT INTO `reportlinks` VALUES ('custbranch','locations','custbranch.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','custbranch','locations.loccode=custbranch.defaultlocation');
INSERT INTO `reportlinks` VALUES ('custbranch','shippers','custbranch.defaultshipvia=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','custbranch','shippers.shipper_id=custbranch.defaultshipvia');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','holdreasons','debtorsmaster.holdreason=holdreasons.reasoncode');
INSERT INTO `reportlinks` VALUES ('holdreasons','debtorsmaster','holdreasons.reasoncode=debtorsmaster.holdreason');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','currencies','debtorsmaster.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','debtorsmaster','currencies.currabrev=debtorsmaster.currcode');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','paymentterms','debtorsmaster.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','debtorsmaster','paymentterms.termsindicator=debtorsmaster.paymentterms');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','salestypes','debtorsmaster.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','debtorsmaster','salestypes.typeabbrev=debtorsmaster.salestype');
INSERT INTO `reportlinks` VALUES ('debtortrans','custbranch','debtortrans.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','debtortrans','custbranch.debtorno=debtortrans.debtorno');
INSERT INTO `reportlinks` VALUES ('debtortrans','systypes','debtortrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','debtortrans','systypes.typeid=debtortrans.type');
INSERT INTO `reportlinks` VALUES ('debtortrans','periods','debtortrans.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','debtortrans','periods.periodno=debtortrans.prd');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','taxauthorities','debtortranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','debtortranstaxes','taxauthorities.taxid=debtortranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','debtortrans','debtortranstaxes.debtortransid=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','debtortranstaxes','debtortrans.id=debtortranstaxes.debtortransid');
INSERT INTO `reportlinks` VALUES ('discountmatrix','salestypes','discountmatrix.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','discountmatrix','salestypes.typeabbrev=discountmatrix.salestype');
INSERT INTO `reportlinks` VALUES ('freightcosts','locations','freightcosts.locationfrom=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','freightcosts','locations.loccode=freightcosts.locationfrom');
INSERT INTO `reportlinks` VALUES ('freightcosts','shippers','freightcosts.shipperid=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','freightcosts','shippers.shipper_id=freightcosts.shipperid');
INSERT INTO `reportlinks` VALUES ('gltrans','chartmaster','gltrans.account=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','gltrans','chartmaster.accountcode=gltrans.account');
INSERT INTO `reportlinks` VALUES ('gltrans','systypes','gltrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','gltrans','systypes.typeid=gltrans.type');
INSERT INTO `reportlinks` VALUES ('gltrans','periods','gltrans.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','gltrans','periods.periodno=gltrans.periodno');
INSERT INTO `reportlinks` VALUES ('grns','suppliers','grns.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','grns','suppliers.supplierid=grns.supplierid');
INSERT INTO `reportlinks` VALUES ('grns','purchorderdetails','grns.podetailitem=purchorderdetails.podetailitem');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','grns','purchorderdetails.podetailitem=grns.podetailitem');
INSERT INTO `reportlinks` VALUES ('locations','taxprovinces','locations.taxprovinceid=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','locations','taxprovinces.taxprovinceid=locations.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('locstock','locations','locstock.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','locstock','locations.loccode=locstock.loccode');
INSERT INTO `reportlinks` VALUES ('locstock','stockmaster','locstock.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','locstock','stockmaster.stockid=locstock.stockid');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.shiploc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.shiploc');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.recloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.recloc');
INSERT INTO `reportlinks` VALUES ('loctransfers','stockmaster','loctransfers.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','loctransfers','stockmaster.stockid=loctransfers.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','stockmaster','orderdeliverydifferenceslog.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','orderdeliverydifferencesl','stockmaster.stockid=orderdeliverydifferenceslog.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','custbranch','orderdeliverydifferenceslog.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','orderdeliverydifferencesl','custbranch.debtorno=orderdeliverydifferenceslog.debtorno');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','salesorders','orderdeliverydifferenceslog.branchcode=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','orderdeliverydifferencesl','salesorders.orderno=orderdeliverydifferenceslog.branchcode');
INSERT INTO `reportlinks` VALUES ('prices','stockmaster','prices.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','prices','stockmaster.stockid=prices.stockid');
INSERT INTO `reportlinks` VALUES ('prices','currencies','prices.currabrev=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','prices','currencies.currabrev=prices.currabrev');
INSERT INTO `reportlinks` VALUES ('prices','salestypes','prices.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','prices','salestypes.typeabbrev=prices.typeabbrev');
INSERT INTO `reportlinks` VALUES ('purchdata','stockmaster','purchdata.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','purchdata','stockmaster.stockid=purchdata.stockid');
INSERT INTO `reportlinks` VALUES ('purchdata','suppliers','purchdata.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchdata','suppliers.supplierid=purchdata.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','purchorders','purchorderdetails.orderno=purchorders.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','purchorderdetails','purchorders.orderno=purchorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','suppliers','purchorders.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchorders','suppliers.supplierid=purchorders.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorders','locations','purchorders.intostocklocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','purchorders','locations.loccode=purchorders.intostocklocation');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','custbranch','recurringsalesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','recurringsalesorders','custbranch.branchcode=recurringsalesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','recurringsalesorders','recurrsalesorderdetails.recurrorderno=recurringsalesorders.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','recurrsalesorderdetails','recurringsalesorders.recurrorderno=recurrsalesorderdetails.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','stockmaster','recurrsalesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','recurrsalesorderdetails','stockmaster.stockid=recurrsalesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('reportcolumns','reportheaders','reportcolumns.reportid=reportheaders.reportid');
INSERT INTO `reportlinks` VALUES ('reportheaders','reportcolumns','reportheaders.reportid=reportcolumns.reportid');
INSERT INTO `reportlinks` VALUES ('salesanalysis','periods','salesanalysis.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','salesanalysis','periods.periodno=salesanalysis.periodno');
INSERT INTO `reportlinks` VALUES ('salescatprod','stockmaster','salescatprod.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salescatprod','stockmaster.stockid=salescatprod.stockid');
INSERT INTO `reportlinks` VALUES ('salescatprod','salescat','salescatprod.salescatid=salescat.salescatid');
INSERT INTO `reportlinks` VALUES ('salescat','salescatprod','salescat.salescatid=salescatprod.salescatid');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','salesorders','salesorderdetails.orderno=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','salesorderdetails','salesorders.orderno=salesorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','stockmaster','salesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salesorderdetails','stockmaster.stockid=salesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('salesorders','custbranch','salesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','salesorders','custbranch.branchcode=salesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('salesorders','shippers','salesorders.debtorno=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','salesorders','shippers.shipper_id=salesorders.debtorno');
INSERT INTO `reportlinks` VALUES ('salesorders','locations','salesorders.fromstkloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','salesorders','locations.loccode=salesorders.fromstkloc');
INSERT INTO `reportlinks` VALUES ('securitygroups','securityroles','securitygroups.secroleid=securityroles.secroleid');
INSERT INTO `reportlinks` VALUES ('securityroles','securitygroups','securityroles.secroleid=securitygroups.secroleid');
INSERT INTO `reportlinks` VALUES ('securitygroups','securitytokens','securitygroups.tokenid=securitytokens.tokenid');
INSERT INTO `reportlinks` VALUES ('securitytokens','securitygroups','securitytokens.tokenid=securitygroups.tokenid');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','shipments','shipmentcharges.shiptref=shipments.shiptref');
INSERT INTO `reportlinks` VALUES ('shipments','shipmentcharges','shipments.shiptref=shipmentcharges.shiptref');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','systypes','shipmentcharges.transtype=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','shipmentcharges','systypes.typeid=shipmentcharges.transtype');
INSERT INTO `reportlinks` VALUES ('shipments','suppliers','shipments.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','shipments','suppliers.supplierid=shipments.supplierid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','stockmaster','stockcheckfreeze.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcheckfreeze','stockmaster.stockid=stockcheckfreeze.stockid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','locations','stockcheckfreeze.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcheckfreeze','locations.loccode=stockcheckfreeze.loccode');
INSERT INTO `reportlinks` VALUES ('stockcounts','stockmaster','stockcounts.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcounts','stockmaster.stockid=stockcounts.stockid');
INSERT INTO `reportlinks` VALUES ('stockcounts','locations','stockcounts.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcounts','locations.loccode=stockcounts.loccode');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcategory','stockmaster.categoryid=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','stockmaster','stockcategory.categoryid=stockmaster.categoryid');
INSERT INTO `reportlinks` VALUES ('stockmaster','taxcategories','stockmaster.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','stockmaster','taxcategories.taxcatid=stockmaster.taxcatid');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockmaster','stockmoves.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockmoves','stockmaster.stockid=stockmoves.stockid');
INSERT INTO `reportlinks` VALUES ('stockmoves','systypes','stockmoves.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','stockmoves','systypes.typeid=stockmoves.type');
INSERT INTO `reportlinks` VALUES ('stockmoves','locations','stockmoves.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockmoves','locations.loccode=stockmoves.loccode');
INSERT INTO `reportlinks` VALUES ('stockmoves','periods','stockmoves.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','stockmoves','periods.periodno=stockmoves.prd');
INSERT INTO `reportlinks` VALUES ('stockmovestaxes','taxauthorities','stockmovestaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','stockmovestaxes','taxauthorities.taxid=stockmovestaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockmaster','stockserialitems.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockserialitems','stockmaster.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','locations','stockserialitems.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockserialitems','locations.loccode=stockserialitems.loccode');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockmoves','stockserialmoves.stockmoveno=stockmoves.stkmoveno');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockserialmoves','stockmoves.stkmoveno=stockserialmoves.stockmoveno');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockserialitems','stockserialmoves.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockserialmoves','stockserialitems.stockid=stockserialmoves.stockid');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocfrom=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocto=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocto');
INSERT INTO `reportlinks` VALUES ('suppliercontacts','suppliers','suppliercontacts.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','suppliercontacts','suppliers.supplierid=suppliercontacts.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','currencies','suppliers.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','suppliers','currencies.currabrev=suppliers.currcode');
INSERT INTO `reportlinks` VALUES ('suppliers','paymentterms','suppliers.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','suppliers','paymentterms.termsindicator=suppliers.paymentterms');
INSERT INTO `reportlinks` VALUES ('suppliers','taxgroups','suppliers.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','suppliers','taxgroups.taxgroupid=suppliers.taxgroupid');
INSERT INTO `reportlinks` VALUES ('supptrans','systypes','supptrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','supptrans','systypes.typeid=supptrans.type');
INSERT INTO `reportlinks` VALUES ('supptrans','suppliers','supptrans.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','supptrans','suppliers.supplierid=supptrans.supplierno');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','taxauthorities','supptranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','supptranstaxes','taxauthorities.taxid=supptranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','supptrans','supptranstaxes.supptransid=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','supptranstaxes','supptrans.id=supptranstaxes.supptransid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.taxglcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.taxglcode');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.purchtaxglaccount=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.purchtaxglaccount');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxauthorities','taxauthrates.taxauthority=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxauthrates','taxauthorities.taxid=taxauthrates.taxauthority');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxcategories','taxauthrates.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','taxauthrates','taxcategories.taxcatid=taxauthrates.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxprovinces','taxauthrates.dispatchtaxprovince=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','taxauthrates','taxprovinces.taxprovinceid=taxauthrates.dispatchtaxprovince');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxgroups','taxgrouptaxes.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','taxgrouptaxes','taxgroups.taxgroupid=taxgrouptaxes.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxauthorities','taxgrouptaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxgrouptaxes','taxauthorities.taxid=taxgrouptaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('workcentres','locations','workcentres.location=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','workcentres','locations.loccode=workcentres.location');
INSERT INTO `reportlinks` VALUES ('worksorders','locations','worksorders.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','worksorders','locations.loccode=worksorders.loccode');
INSERT INTO `reportlinks` VALUES ('worksorders','stockmaster','worksorders.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','worksorders','stockmaster.stockid=worksorders.stockid');
INSERT INTO `reportlinks` VALUES ('www_users','locations','www_users.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','www_users','locations.loccode=www_users.defaultlocation');
INSERT INTO `reportlinks` VALUES ('accountgroups','accountsection','accountgroups.sectioninaccounts=accountsection.sectionid');
INSERT INTO `reportlinks` VALUES ('accountsection','accountgroups','accountsection.sectionid=accountgroups.sectioninaccounts');
INSERT INTO `reportlinks` VALUES ('bankaccounts','chartmaster','bankaccounts.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','bankaccounts','chartmaster.accountcode=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('banktrans','systypes','banktrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','banktrans','systypes.typeid=banktrans.type');
INSERT INTO `reportlinks` VALUES ('banktrans','bankaccounts','banktrans.bankact=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('bankaccounts','banktrans','bankaccounts.accountcode=banktrans.bankact');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.parent=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.parent');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.component');
INSERT INTO `reportlinks` VALUES ('bom','workcentres','bom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','bom','workcentres.code=bom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('bom','locations','bom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','bom','locations.loccode=bom.loccode');
INSERT INTO `reportlinks` VALUES ('buckets','workcentres','buckets.workcentre=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','buckets','workcentres.code=buckets.workcentre');
INSERT INTO `reportlinks` VALUES ('chartdetails','chartmaster','chartdetails.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','chartdetails','chartmaster.accountcode=chartdetails.accountcode');
INSERT INTO `reportlinks` VALUES ('chartdetails','periods','chartdetails.period=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','chartdetails','periods.periodno=chartdetails.period');
INSERT INTO `reportlinks` VALUES ('chartmaster','accountgroups','chartmaster.group_=accountgroups.groupname');
INSERT INTO `reportlinks` VALUES ('accountgroups','chartmaster','accountgroups.groupname=chartmaster.group_');
INSERT INTO `reportlinks` VALUES ('contractbom','workcentres','contractbom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','contractbom','workcentres.code=contractbom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('contractbom','locations','contractbom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','contractbom','locations.loccode=contractbom.loccode');
INSERT INTO `reportlinks` VALUES ('contractbom','stockmaster','contractbom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','contractbom','stockmaster.stockid=contractbom.component');
INSERT INTO `reportlinks` VALUES ('contractreqts','contracts','contractreqts.contract=contracts.contractref');
INSERT INTO `reportlinks` VALUES ('contracts','contractreqts','contracts.contractref=contractreqts.contract');
INSERT INTO `reportlinks` VALUES ('contracts','custbranch','contracts.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','contracts','custbranch.debtorno=contracts.debtorno');
INSERT INTO `reportlinks` VALUES ('contracts','stockcategory','contracts.branchcode=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','contracts','stockcategory.categoryid=contracts.branchcode');
INSERT INTO `reportlinks` VALUES ('contracts','salestypes','contracts.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','contracts','salestypes.typeabbrev=contracts.typeabbrev');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocfrom=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocto=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocto');
INSERT INTO `reportlinks` VALUES ('custbranch','debtorsmaster','custbranch.debtorno=debtorsmaster.debtorno');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','custbranch','debtorsmaster.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','areas','custbranch.area=areas.areacode');
INSERT INTO `reportlinks` VALUES ('areas','custbranch','areas.areacode=custbranch.area');
INSERT INTO `reportlinks` VALUES ('custbranch','salesman','custbranch.salesman=salesman.salesmancode');
INSERT INTO `reportlinks` VALUES ('salesman','custbranch','salesman.salesmancode=custbranch.salesman');
INSERT INTO `reportlinks` VALUES ('custbranch','locations','custbranch.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','custbranch','locations.loccode=custbranch.defaultlocation');
INSERT INTO `reportlinks` VALUES ('custbranch','shippers','custbranch.defaultshipvia=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','custbranch','shippers.shipper_id=custbranch.defaultshipvia');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','holdreasons','debtorsmaster.holdreason=holdreasons.reasoncode');
INSERT INTO `reportlinks` VALUES ('holdreasons','debtorsmaster','holdreasons.reasoncode=debtorsmaster.holdreason');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','currencies','debtorsmaster.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','debtorsmaster','currencies.currabrev=debtorsmaster.currcode');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','paymentterms','debtorsmaster.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','debtorsmaster','paymentterms.termsindicator=debtorsmaster.paymentterms');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','salestypes','debtorsmaster.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','debtorsmaster','salestypes.typeabbrev=debtorsmaster.salestype');
INSERT INTO `reportlinks` VALUES ('debtortrans','custbranch','debtortrans.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','debtortrans','custbranch.debtorno=debtortrans.debtorno');
INSERT INTO `reportlinks` VALUES ('debtortrans','systypes','debtortrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','debtortrans','systypes.typeid=debtortrans.type');
INSERT INTO `reportlinks` VALUES ('debtortrans','periods','debtortrans.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','debtortrans','periods.periodno=debtortrans.prd');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','taxauthorities','debtortranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','debtortranstaxes','taxauthorities.taxid=debtortranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','debtortrans','debtortranstaxes.debtortransid=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','debtortranstaxes','debtortrans.id=debtortranstaxes.debtortransid');
INSERT INTO `reportlinks` VALUES ('discountmatrix','salestypes','discountmatrix.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','discountmatrix','salestypes.typeabbrev=discountmatrix.salestype');
INSERT INTO `reportlinks` VALUES ('freightcosts','locations','freightcosts.locationfrom=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','freightcosts','locations.loccode=freightcosts.locationfrom');
INSERT INTO `reportlinks` VALUES ('freightcosts','shippers','freightcosts.shipperid=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','freightcosts','shippers.shipper_id=freightcosts.shipperid');
INSERT INTO `reportlinks` VALUES ('gltrans','chartmaster','gltrans.account=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','gltrans','chartmaster.accountcode=gltrans.account');
INSERT INTO `reportlinks` VALUES ('gltrans','systypes','gltrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','gltrans','systypes.typeid=gltrans.type');
INSERT INTO `reportlinks` VALUES ('gltrans','periods','gltrans.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','gltrans','periods.periodno=gltrans.periodno');
INSERT INTO `reportlinks` VALUES ('grns','suppliers','grns.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','grns','suppliers.supplierid=grns.supplierid');
INSERT INTO `reportlinks` VALUES ('grns','purchorderdetails','grns.podetailitem=purchorderdetails.podetailitem');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','grns','purchorderdetails.podetailitem=grns.podetailitem');
INSERT INTO `reportlinks` VALUES ('locations','taxprovinces','locations.taxprovinceid=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','locations','taxprovinces.taxprovinceid=locations.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('locstock','locations','locstock.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','locstock','locations.loccode=locstock.loccode');
INSERT INTO `reportlinks` VALUES ('locstock','stockmaster','locstock.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','locstock','stockmaster.stockid=locstock.stockid');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.shiploc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.shiploc');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.recloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.recloc');
INSERT INTO `reportlinks` VALUES ('loctransfers','stockmaster','loctransfers.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','loctransfers','stockmaster.stockid=loctransfers.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','stockmaster','orderdeliverydifferenceslog.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','orderdeliverydifferencesl','stockmaster.stockid=orderdeliverydifferenceslog.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','custbranch','orderdeliverydifferenceslog.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','orderdeliverydifferencesl','custbranch.debtorno=orderdeliverydifferenceslog.debtorno');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','salesorders','orderdeliverydifferenceslog.branchcode=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','orderdeliverydifferencesl','salesorders.orderno=orderdeliverydifferenceslog.branchcode');
INSERT INTO `reportlinks` VALUES ('prices','stockmaster','prices.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','prices','stockmaster.stockid=prices.stockid');
INSERT INTO `reportlinks` VALUES ('prices','currencies','prices.currabrev=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','prices','currencies.currabrev=prices.currabrev');
INSERT INTO `reportlinks` VALUES ('prices','salestypes','prices.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','prices','salestypes.typeabbrev=prices.typeabbrev');
INSERT INTO `reportlinks` VALUES ('purchdata','stockmaster','purchdata.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','purchdata','stockmaster.stockid=purchdata.stockid');
INSERT INTO `reportlinks` VALUES ('purchdata','suppliers','purchdata.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchdata','suppliers.supplierid=purchdata.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','purchorders','purchorderdetails.orderno=purchorders.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','purchorderdetails','purchorders.orderno=purchorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','suppliers','purchorders.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchorders','suppliers.supplierid=purchorders.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorders','locations','purchorders.intostocklocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','purchorders','locations.loccode=purchorders.intostocklocation');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','custbranch','recurringsalesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','recurringsalesorders','custbranch.branchcode=recurringsalesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','recurringsalesorders','recurrsalesorderdetails.recurrorderno=recurringsalesorders.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','recurrsalesorderdetails','recurringsalesorders.recurrorderno=recurrsalesorderdetails.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','stockmaster','recurrsalesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','recurrsalesorderdetails','stockmaster.stockid=recurrsalesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('reportcolumns','reportheaders','reportcolumns.reportid=reportheaders.reportid');
INSERT INTO `reportlinks` VALUES ('reportheaders','reportcolumns','reportheaders.reportid=reportcolumns.reportid');
INSERT INTO `reportlinks` VALUES ('salesanalysis','periods','salesanalysis.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','salesanalysis','periods.periodno=salesanalysis.periodno');
INSERT INTO `reportlinks` VALUES ('salescatprod','stockmaster','salescatprod.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salescatprod','stockmaster.stockid=salescatprod.stockid');
INSERT INTO `reportlinks` VALUES ('salescatprod','salescat','salescatprod.salescatid=salescat.salescatid');
INSERT INTO `reportlinks` VALUES ('salescat','salescatprod','salescat.salescatid=salescatprod.salescatid');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','salesorders','salesorderdetails.orderno=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','salesorderdetails','salesorders.orderno=salesorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','stockmaster','salesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salesorderdetails','stockmaster.stockid=salesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('salesorders','custbranch','salesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','salesorders','custbranch.branchcode=salesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('salesorders','shippers','salesorders.debtorno=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','salesorders','shippers.shipper_id=salesorders.debtorno');
INSERT INTO `reportlinks` VALUES ('salesorders','locations','salesorders.fromstkloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','salesorders','locations.loccode=salesorders.fromstkloc');
INSERT INTO `reportlinks` VALUES ('securitygroups','securityroles','securitygroups.secroleid=securityroles.secroleid');
INSERT INTO `reportlinks` VALUES ('securityroles','securitygroups','securityroles.secroleid=securitygroups.secroleid');
INSERT INTO `reportlinks` VALUES ('securitygroups','securitytokens','securitygroups.tokenid=securitytokens.tokenid');
INSERT INTO `reportlinks` VALUES ('securitytokens','securitygroups','securitytokens.tokenid=securitygroups.tokenid');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','shipments','shipmentcharges.shiptref=shipments.shiptref');
INSERT INTO `reportlinks` VALUES ('shipments','shipmentcharges','shipments.shiptref=shipmentcharges.shiptref');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','systypes','shipmentcharges.transtype=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','shipmentcharges','systypes.typeid=shipmentcharges.transtype');
INSERT INTO `reportlinks` VALUES ('shipments','suppliers','shipments.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','shipments','suppliers.supplierid=shipments.supplierid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','stockmaster','stockcheckfreeze.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcheckfreeze','stockmaster.stockid=stockcheckfreeze.stockid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','locations','stockcheckfreeze.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcheckfreeze','locations.loccode=stockcheckfreeze.loccode');
INSERT INTO `reportlinks` VALUES ('stockcounts','stockmaster','stockcounts.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcounts','stockmaster.stockid=stockcounts.stockid');
INSERT INTO `reportlinks` VALUES ('stockcounts','locations','stockcounts.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcounts','locations.loccode=stockcounts.loccode');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcategory','stockmaster.categoryid=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','stockmaster','stockcategory.categoryid=stockmaster.categoryid');
INSERT INTO `reportlinks` VALUES ('stockmaster','taxcategories','stockmaster.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','stockmaster','taxcategories.taxcatid=stockmaster.taxcatid');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockmaster','stockmoves.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockmoves','stockmaster.stockid=stockmoves.stockid');
INSERT INTO `reportlinks` VALUES ('stockmoves','systypes','stockmoves.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','stockmoves','systypes.typeid=stockmoves.type');
INSERT INTO `reportlinks` VALUES ('stockmoves','locations','stockmoves.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockmoves','locations.loccode=stockmoves.loccode');
INSERT INTO `reportlinks` VALUES ('stockmoves','periods','stockmoves.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','stockmoves','periods.periodno=stockmoves.prd');
INSERT INTO `reportlinks` VALUES ('stockmovestaxes','taxauthorities','stockmovestaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','stockmovestaxes','taxauthorities.taxid=stockmovestaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockmaster','stockserialitems.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockserialitems','stockmaster.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','locations','stockserialitems.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockserialitems','locations.loccode=stockserialitems.loccode');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockmoves','stockserialmoves.stockmoveno=stockmoves.stkmoveno');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockserialmoves','stockmoves.stkmoveno=stockserialmoves.stockmoveno');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockserialitems','stockserialmoves.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockserialmoves','stockserialitems.stockid=stockserialmoves.stockid');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocfrom=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocto=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocto');
INSERT INTO `reportlinks` VALUES ('suppliercontacts','suppliers','suppliercontacts.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','suppliercontacts','suppliers.supplierid=suppliercontacts.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','currencies','suppliers.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','suppliers','currencies.currabrev=suppliers.currcode');
INSERT INTO `reportlinks` VALUES ('suppliers','paymentterms','suppliers.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','suppliers','paymentterms.termsindicator=suppliers.paymentterms');
INSERT INTO `reportlinks` VALUES ('suppliers','taxgroups','suppliers.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','suppliers','taxgroups.taxgroupid=suppliers.taxgroupid');
INSERT INTO `reportlinks` VALUES ('supptrans','systypes','supptrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','supptrans','systypes.typeid=supptrans.type');
INSERT INTO `reportlinks` VALUES ('supptrans','suppliers','supptrans.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','supptrans','suppliers.supplierid=supptrans.supplierno');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','taxauthorities','supptranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','supptranstaxes','taxauthorities.taxid=supptranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','supptrans','supptranstaxes.supptransid=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','supptranstaxes','supptrans.id=supptranstaxes.supptransid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.taxglcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.taxglcode');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.purchtaxglaccount=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.purchtaxglaccount');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxauthorities','taxauthrates.taxauthority=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxauthrates','taxauthorities.taxid=taxauthrates.taxauthority');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxcategories','taxauthrates.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','taxauthrates','taxcategories.taxcatid=taxauthrates.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxprovinces','taxauthrates.dispatchtaxprovince=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','taxauthrates','taxprovinces.taxprovinceid=taxauthrates.dispatchtaxprovince');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxgroups','taxgrouptaxes.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','taxgrouptaxes','taxgroups.taxgroupid=taxgrouptaxes.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxauthorities','taxgrouptaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxgrouptaxes','taxauthorities.taxid=taxgrouptaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('workcentres','locations','workcentres.location=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','workcentres','locations.loccode=workcentres.location');
INSERT INTO `reportlinks` VALUES ('worksorders','locations','worksorders.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','worksorders','locations.loccode=worksorders.loccode');
INSERT INTO `reportlinks` VALUES ('worksorders','stockmaster','worksorders.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','worksorders','stockmaster.stockid=worksorders.stockid');
INSERT INTO `reportlinks` VALUES ('www_users','locations','www_users.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','www_users','locations.loccode=www_users.defaultlocation');
INSERT INTO `reportlinks` VALUES ('accountgroups','accountsection','accountgroups.sectioninaccounts=accountsection.sectionid');
INSERT INTO `reportlinks` VALUES ('accountsection','accountgroups','accountsection.sectionid=accountgroups.sectioninaccounts');
INSERT INTO `reportlinks` VALUES ('bankaccounts','chartmaster','bankaccounts.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','bankaccounts','chartmaster.accountcode=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('banktrans','systypes','banktrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','banktrans','systypes.typeid=banktrans.type');
INSERT INTO `reportlinks` VALUES ('banktrans','bankaccounts','banktrans.bankact=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('bankaccounts','banktrans','bankaccounts.accountcode=banktrans.bankact');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.parent=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.parent');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.component');
INSERT INTO `reportlinks` VALUES ('bom','workcentres','bom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','bom','workcentres.code=bom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('bom','locations','bom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','bom','locations.loccode=bom.loccode');
INSERT INTO `reportlinks` VALUES ('buckets','workcentres','buckets.workcentre=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','buckets','workcentres.code=buckets.workcentre');
INSERT INTO `reportlinks` VALUES ('chartdetails','chartmaster','chartdetails.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','chartdetails','chartmaster.accountcode=chartdetails.accountcode');
INSERT INTO `reportlinks` VALUES ('chartdetails','periods','chartdetails.period=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','chartdetails','periods.periodno=chartdetails.period');
INSERT INTO `reportlinks` VALUES ('chartmaster','accountgroups','chartmaster.group_=accountgroups.groupname');
INSERT INTO `reportlinks` VALUES ('accountgroups','chartmaster','accountgroups.groupname=chartmaster.group_');
INSERT INTO `reportlinks` VALUES ('contractbom','workcentres','contractbom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','contractbom','workcentres.code=contractbom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('contractbom','locations','contractbom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','contractbom','locations.loccode=contractbom.loccode');
INSERT INTO `reportlinks` VALUES ('contractbom','stockmaster','contractbom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','contractbom','stockmaster.stockid=contractbom.component');
INSERT INTO `reportlinks` VALUES ('contractreqts','contracts','contractreqts.contract=contracts.contractref');
INSERT INTO `reportlinks` VALUES ('contracts','contractreqts','contracts.contractref=contractreqts.contract');
INSERT INTO `reportlinks` VALUES ('contracts','custbranch','contracts.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','contracts','custbranch.debtorno=contracts.debtorno');
INSERT INTO `reportlinks` VALUES ('contracts','stockcategory','contracts.branchcode=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','contracts','stockcategory.categoryid=contracts.branchcode');
INSERT INTO `reportlinks` VALUES ('contracts','salestypes','contracts.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','contracts','salestypes.typeabbrev=contracts.typeabbrev');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocfrom=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocto=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocto');
INSERT INTO `reportlinks` VALUES ('custbranch','debtorsmaster','custbranch.debtorno=debtorsmaster.debtorno');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','custbranch','debtorsmaster.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','areas','custbranch.area=areas.areacode');
INSERT INTO `reportlinks` VALUES ('areas','custbranch','areas.areacode=custbranch.area');
INSERT INTO `reportlinks` VALUES ('custbranch','salesman','custbranch.salesman=salesman.salesmancode');
INSERT INTO `reportlinks` VALUES ('salesman','custbranch','salesman.salesmancode=custbranch.salesman');
INSERT INTO `reportlinks` VALUES ('custbranch','locations','custbranch.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','custbranch','locations.loccode=custbranch.defaultlocation');
INSERT INTO `reportlinks` VALUES ('custbranch','shippers','custbranch.defaultshipvia=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','custbranch','shippers.shipper_id=custbranch.defaultshipvia');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','holdreasons','debtorsmaster.holdreason=holdreasons.reasoncode');
INSERT INTO `reportlinks` VALUES ('holdreasons','debtorsmaster','holdreasons.reasoncode=debtorsmaster.holdreason');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','currencies','debtorsmaster.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','debtorsmaster','currencies.currabrev=debtorsmaster.currcode');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','paymentterms','debtorsmaster.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','debtorsmaster','paymentterms.termsindicator=debtorsmaster.paymentterms');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','salestypes','debtorsmaster.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','debtorsmaster','salestypes.typeabbrev=debtorsmaster.salestype');
INSERT INTO `reportlinks` VALUES ('debtortrans','custbranch','debtortrans.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','debtortrans','custbranch.debtorno=debtortrans.debtorno');
INSERT INTO `reportlinks` VALUES ('debtortrans','systypes','debtortrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','debtortrans','systypes.typeid=debtortrans.type');
INSERT INTO `reportlinks` VALUES ('debtortrans','periods','debtortrans.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','debtortrans','periods.periodno=debtortrans.prd');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','taxauthorities','debtortranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','debtortranstaxes','taxauthorities.taxid=debtortranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('debtortranstaxes','debtortrans','debtortranstaxes.debtortransid=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','debtortranstaxes','debtortrans.id=debtortranstaxes.debtortransid');
INSERT INTO `reportlinks` VALUES ('discountmatrix','salestypes','discountmatrix.salestype=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','discountmatrix','salestypes.typeabbrev=discountmatrix.salestype');
INSERT INTO `reportlinks` VALUES ('freightcosts','locations','freightcosts.locationfrom=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','freightcosts','locations.loccode=freightcosts.locationfrom');
INSERT INTO `reportlinks` VALUES ('freightcosts','shippers','freightcosts.shipperid=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','freightcosts','shippers.shipper_id=freightcosts.shipperid');
INSERT INTO `reportlinks` VALUES ('gltrans','chartmaster','gltrans.account=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','gltrans','chartmaster.accountcode=gltrans.account');
INSERT INTO `reportlinks` VALUES ('gltrans','systypes','gltrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','gltrans','systypes.typeid=gltrans.type');
INSERT INTO `reportlinks` VALUES ('gltrans','periods','gltrans.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','gltrans','periods.periodno=gltrans.periodno');
INSERT INTO `reportlinks` VALUES ('grns','suppliers','grns.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','grns','suppliers.supplierid=grns.supplierid');
INSERT INTO `reportlinks` VALUES ('grns','purchorderdetails','grns.podetailitem=purchorderdetails.podetailitem');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','grns','purchorderdetails.podetailitem=grns.podetailitem');
INSERT INTO `reportlinks` VALUES ('locations','taxprovinces','locations.taxprovinceid=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','locations','taxprovinces.taxprovinceid=locations.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('locstock','locations','locstock.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','locstock','locations.loccode=locstock.loccode');
INSERT INTO `reportlinks` VALUES ('locstock','stockmaster','locstock.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','locstock','stockmaster.stockid=locstock.stockid');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.shiploc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.shiploc');
INSERT INTO `reportlinks` VALUES ('loctransfers','locations','loctransfers.recloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','loctransfers','locations.loccode=loctransfers.recloc');
INSERT INTO `reportlinks` VALUES ('loctransfers','stockmaster','loctransfers.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','loctransfers','stockmaster.stockid=loctransfers.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','stockmaster','orderdeliverydifferenceslog.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','orderdeliverydifferencesl','stockmaster.stockid=orderdeliverydifferenceslog.stockid');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','custbranch','orderdeliverydifferenceslog.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','orderdeliverydifferencesl','custbranch.debtorno=orderdeliverydifferenceslog.debtorno');
INSERT INTO `reportlinks` VALUES ('orderdeliverydifferencesl','salesorders','orderdeliverydifferenceslog.branchcode=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','orderdeliverydifferencesl','salesorders.orderno=orderdeliverydifferenceslog.branchcode');
INSERT INTO `reportlinks` VALUES ('prices','stockmaster','prices.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','prices','stockmaster.stockid=prices.stockid');
INSERT INTO `reportlinks` VALUES ('prices','currencies','prices.currabrev=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','prices','currencies.currabrev=prices.currabrev');
INSERT INTO `reportlinks` VALUES ('prices','salestypes','prices.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','prices','salestypes.typeabbrev=prices.typeabbrev');
INSERT INTO `reportlinks` VALUES ('purchdata','stockmaster','purchdata.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','purchdata','stockmaster.stockid=purchdata.stockid');
INSERT INTO `reportlinks` VALUES ('purchdata','suppliers','purchdata.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchdata','suppliers.supplierid=purchdata.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorderdetails','purchorders','purchorderdetails.orderno=purchorders.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','purchorderdetails','purchorders.orderno=purchorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('purchorders','suppliers','purchorders.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','purchorders','suppliers.supplierid=purchorders.supplierno');
INSERT INTO `reportlinks` VALUES ('purchorders','locations','purchorders.intostocklocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','purchorders','locations.loccode=purchorders.intostocklocation');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','custbranch','recurringsalesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','recurringsalesorders','custbranch.branchcode=recurringsalesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','recurringsalesorders','recurrsalesorderdetails.recurrorderno=recurringsalesorders.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurringsalesorders','recurrsalesorderdetails','recurringsalesorders.recurrorderno=recurrsalesorderdetails.recurrorderno');
INSERT INTO `reportlinks` VALUES ('recurrsalesorderdetails','stockmaster','recurrsalesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','recurrsalesorderdetails','stockmaster.stockid=recurrsalesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('reportcolumns','reportheaders','reportcolumns.reportid=reportheaders.reportid');
INSERT INTO `reportlinks` VALUES ('reportheaders','reportcolumns','reportheaders.reportid=reportcolumns.reportid');
INSERT INTO `reportlinks` VALUES ('salesanalysis','periods','salesanalysis.periodno=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','salesanalysis','periods.periodno=salesanalysis.periodno');
INSERT INTO `reportlinks` VALUES ('salescatprod','stockmaster','salescatprod.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salescatprod','stockmaster.stockid=salescatprod.stockid');
INSERT INTO `reportlinks` VALUES ('salescatprod','salescat','salescatprod.salescatid=salescat.salescatid');
INSERT INTO `reportlinks` VALUES ('salescat','salescatprod','salescat.salescatid=salescatprod.salescatid');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','salesorders','salesorderdetails.orderno=salesorders.orderno');
INSERT INTO `reportlinks` VALUES ('salesorders','salesorderdetails','salesorders.orderno=salesorderdetails.orderno');
INSERT INTO `reportlinks` VALUES ('salesorderdetails','stockmaster','salesorderdetails.stkcode=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','salesorderdetails','stockmaster.stockid=salesorderdetails.stkcode');
INSERT INTO `reportlinks` VALUES ('salesorders','custbranch','salesorders.branchcode=custbranch.branchcode');
INSERT INTO `reportlinks` VALUES ('custbranch','salesorders','custbranch.branchcode=salesorders.branchcode');
INSERT INTO `reportlinks` VALUES ('salesorders','shippers','salesorders.debtorno=shippers.shipper_id');
INSERT INTO `reportlinks` VALUES ('shippers','salesorders','shippers.shipper_id=salesorders.debtorno');
INSERT INTO `reportlinks` VALUES ('salesorders','locations','salesorders.fromstkloc=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','salesorders','locations.loccode=salesorders.fromstkloc');
INSERT INTO `reportlinks` VALUES ('securitygroups','securityroles','securitygroups.secroleid=securityroles.secroleid');
INSERT INTO `reportlinks` VALUES ('securityroles','securitygroups','securityroles.secroleid=securitygroups.secroleid');
INSERT INTO `reportlinks` VALUES ('securitygroups','securitytokens','securitygroups.tokenid=securitytokens.tokenid');
INSERT INTO `reportlinks` VALUES ('securitytokens','securitygroups','securitytokens.tokenid=securitygroups.tokenid');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','shipments','shipmentcharges.shiptref=shipments.shiptref');
INSERT INTO `reportlinks` VALUES ('shipments','shipmentcharges','shipments.shiptref=shipmentcharges.shiptref');
INSERT INTO `reportlinks` VALUES ('shipmentcharges','systypes','shipmentcharges.transtype=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','shipmentcharges','systypes.typeid=shipmentcharges.transtype');
INSERT INTO `reportlinks` VALUES ('shipments','suppliers','shipments.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','shipments','suppliers.supplierid=shipments.supplierid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','stockmaster','stockcheckfreeze.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcheckfreeze','stockmaster.stockid=stockcheckfreeze.stockid');
INSERT INTO `reportlinks` VALUES ('stockcheckfreeze','locations','stockcheckfreeze.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcheckfreeze','locations.loccode=stockcheckfreeze.loccode');
INSERT INTO `reportlinks` VALUES ('stockcounts','stockmaster','stockcounts.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcounts','stockmaster.stockid=stockcounts.stockid');
INSERT INTO `reportlinks` VALUES ('stockcounts','locations','stockcounts.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockcounts','locations.loccode=stockcounts.loccode');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockcategory','stockmaster.categoryid=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','stockmaster','stockcategory.categoryid=stockmaster.categoryid');
INSERT INTO `reportlinks` VALUES ('stockmaster','taxcategories','stockmaster.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','stockmaster','taxcategories.taxcatid=stockmaster.taxcatid');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockmaster','stockmoves.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockmoves','stockmaster.stockid=stockmoves.stockid');
INSERT INTO `reportlinks` VALUES ('stockmoves','systypes','stockmoves.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','stockmoves','systypes.typeid=stockmoves.type');
INSERT INTO `reportlinks` VALUES ('stockmoves','locations','stockmoves.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockmoves','locations.loccode=stockmoves.loccode');
INSERT INTO `reportlinks` VALUES ('stockmoves','periods','stockmoves.prd=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','stockmoves','periods.periodno=stockmoves.prd');
INSERT INTO `reportlinks` VALUES ('stockmovestaxes','taxauthorities','stockmovestaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','stockmovestaxes','taxauthorities.taxid=stockmovestaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockmaster','stockserialitems.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','stockserialitems','stockmaster.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','locations','stockserialitems.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','stockserialitems','locations.loccode=stockserialitems.loccode');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockmoves','stockserialmoves.stockmoveno=stockmoves.stkmoveno');
INSERT INTO `reportlinks` VALUES ('stockmoves','stockserialmoves','stockmoves.stkmoveno=stockserialmoves.stockmoveno');
INSERT INTO `reportlinks` VALUES ('stockserialmoves','stockserialitems','stockserialmoves.stockid=stockserialitems.stockid');
INSERT INTO `reportlinks` VALUES ('stockserialitems','stockserialmoves','stockserialitems.stockid=stockserialmoves.stockid');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocfrom=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('suppallocs','supptrans','suppallocs.transid_allocto=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','suppallocs','supptrans.id=suppallocs.transid_allocto');
INSERT INTO `reportlinks` VALUES ('suppliercontacts','suppliers','suppliercontacts.supplierid=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','suppliercontacts','suppliers.supplierid=suppliercontacts.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','currencies','suppliers.currcode=currencies.currabrev');
INSERT INTO `reportlinks` VALUES ('currencies','suppliers','currencies.currabrev=suppliers.currcode');
INSERT INTO `reportlinks` VALUES ('suppliers','paymentterms','suppliers.paymentterms=paymentterms.termsindicator');
INSERT INTO `reportlinks` VALUES ('paymentterms','suppliers','paymentterms.termsindicator=suppliers.paymentterms');
INSERT INTO `reportlinks` VALUES ('suppliers','taxgroups','suppliers.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','suppliers','taxgroups.taxgroupid=suppliers.taxgroupid');
INSERT INTO `reportlinks` VALUES ('supptrans','systypes','supptrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','supptrans','systypes.typeid=supptrans.type');
INSERT INTO `reportlinks` VALUES ('supptrans','suppliers','supptrans.supplierno=suppliers.supplierid');
INSERT INTO `reportlinks` VALUES ('suppliers','supptrans','suppliers.supplierid=supptrans.supplierno');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','taxauthorities','supptranstaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','supptranstaxes','taxauthorities.taxid=supptranstaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('supptranstaxes','supptrans','supptranstaxes.supptransid=supptrans.id');
INSERT INTO `reportlinks` VALUES ('supptrans','supptranstaxes','supptrans.id=supptranstaxes.supptransid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.taxglcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.taxglcode');
INSERT INTO `reportlinks` VALUES ('taxauthorities','chartmaster','taxauthorities.purchtaxglaccount=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','taxauthorities','chartmaster.accountcode=taxauthorities.purchtaxglaccount');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxauthorities','taxauthrates.taxauthority=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxauthrates','taxauthorities.taxid=taxauthrates.taxauthority');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxcategories','taxauthrates.taxcatid=taxcategories.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxcategories','taxauthrates','taxcategories.taxcatid=taxauthrates.taxcatid');
INSERT INTO `reportlinks` VALUES ('taxauthrates','taxprovinces','taxauthrates.dispatchtaxprovince=taxprovinces.taxprovinceid');
INSERT INTO `reportlinks` VALUES ('taxprovinces','taxauthrates','taxprovinces.taxprovinceid=taxauthrates.dispatchtaxprovince');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxgroups','taxgrouptaxes.taxgroupid=taxgroups.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgroups','taxgrouptaxes','taxgroups.taxgroupid=taxgrouptaxes.taxgroupid');
INSERT INTO `reportlinks` VALUES ('taxgrouptaxes','taxauthorities','taxgrouptaxes.taxauthid=taxauthorities.taxid');
INSERT INTO `reportlinks` VALUES ('taxauthorities','taxgrouptaxes','taxauthorities.taxid=taxgrouptaxes.taxauthid');
INSERT INTO `reportlinks` VALUES ('workcentres','locations','workcentres.location=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','workcentres','locations.loccode=workcentres.location');
INSERT INTO `reportlinks` VALUES ('worksorders','locations','worksorders.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','worksorders','locations.loccode=worksorders.loccode');
INSERT INTO `reportlinks` VALUES ('worksorders','stockmaster','worksorders.stockid=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','worksorders','stockmaster.stockid=worksorders.stockid');
INSERT INTO `reportlinks` VALUES ('www_users','locations','www_users.defaultlocation=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','www_users','locations.loccode=www_users.defaultlocation');
INSERT INTO `reportlinks` VALUES ('accountgroups','accountsection','accountgroups.sectioninaccounts=accountsection.sectionid');
INSERT INTO `reportlinks` VALUES ('accountsection','accountgroups','accountsection.sectionid=accountgroups.sectioninaccounts');
INSERT INTO `reportlinks` VALUES ('bankaccounts','chartmaster','bankaccounts.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','bankaccounts','chartmaster.accountcode=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('banktrans','systypes','banktrans.type=systypes.typeid');
INSERT INTO `reportlinks` VALUES ('systypes','banktrans','systypes.typeid=banktrans.type');
INSERT INTO `reportlinks` VALUES ('banktrans','bankaccounts','banktrans.bankact=bankaccounts.accountcode');
INSERT INTO `reportlinks` VALUES ('bankaccounts','banktrans','bankaccounts.accountcode=banktrans.bankact');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.parent=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.parent');
INSERT INTO `reportlinks` VALUES ('bom','stockmaster','bom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','bom','stockmaster.stockid=bom.component');
INSERT INTO `reportlinks` VALUES ('bom','workcentres','bom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','bom','workcentres.code=bom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('bom','locations','bom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','bom','locations.loccode=bom.loccode');
INSERT INTO `reportlinks` VALUES ('buckets','workcentres','buckets.workcentre=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','buckets','workcentres.code=buckets.workcentre');
INSERT INTO `reportlinks` VALUES ('chartdetails','chartmaster','chartdetails.accountcode=chartmaster.accountcode');
INSERT INTO `reportlinks` VALUES ('chartmaster','chartdetails','chartmaster.accountcode=chartdetails.accountcode');
INSERT INTO `reportlinks` VALUES ('chartdetails','periods','chartdetails.period=periods.periodno');
INSERT INTO `reportlinks` VALUES ('periods','chartdetails','periods.periodno=chartdetails.period');
INSERT INTO `reportlinks` VALUES ('chartmaster','accountgroups','chartmaster.group_=accountgroups.groupname');
INSERT INTO `reportlinks` VALUES ('accountgroups','chartmaster','accountgroups.groupname=chartmaster.group_');
INSERT INTO `reportlinks` VALUES ('contractbom','workcentres','contractbom.workcentreadded=workcentres.code');
INSERT INTO `reportlinks` VALUES ('workcentres','contractbom','workcentres.code=contractbom.workcentreadded');
INSERT INTO `reportlinks` VALUES ('contractbom','locations','contractbom.loccode=locations.loccode');
INSERT INTO `reportlinks` VALUES ('locations','contractbom','locations.loccode=contractbom.loccode');
INSERT INTO `reportlinks` VALUES ('contractbom','stockmaster','contractbom.component=stockmaster.stockid');
INSERT INTO `reportlinks` VALUES ('stockmaster','contractbom','stockmaster.stockid=contractbom.component');
INSERT INTO `reportlinks` VALUES ('contractreqts','contracts','contractreqts.contract=contracts.contractref');
INSERT INTO `reportlinks` VALUES ('contracts','contractreqts','contracts.contractref=contractreqts.contract');
INSERT INTO `reportlinks` VALUES ('contracts','custbranch','contracts.debtorno=custbranch.debtorno');
INSERT INTO `reportlinks` VALUES ('custbranch','contracts','custbranch.debtorno=contracts.debtorno');
INSERT INTO `reportlinks` VALUES ('contracts','stockcategory','contracts.branchcode=stockcategory.categoryid');
INSERT INTO `reportlinks` VALUES ('stockcategory','contracts','stockcategory.categoryid=contracts.branchcode');
INSERT INTO `reportlinks` VALUES ('contracts','salestypes','contracts.typeabbrev=salestypes.typeabbrev');
INSERT INTO `reportlinks` VALUES ('salestypes','contracts','salestypes.typeabbrev=contracts.typeabbrev');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocfrom=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocfrom');
INSERT INTO `reportlinks` VALUES ('custallocns','debtortrans','custallocns.transid_allocto=debtortrans.id');
INSERT INTO `reportlinks` VALUES ('debtortrans','custallocns','debtortrans.id=custallocns.transid_allocto');
INSERT INTO `reportlinks` VALUES ('custbranch','debtorsmaster','custbranch.debtorno=debtorsmaster.debtorno');
INSERT INTO `reportlinks` VALUES ('debtorsmaster','custbranch','debtorsmaster.debtorno=cust